/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.baking.IBakedPosAction;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3i;

public class PlacedBlueprint
implements NBT {
    private List<IBakedPosAction> pendingPosActions;
    private BlueprintDefinition def;
    private int definitionID;
    private String registryId;
    private ICreationData<?> data;
    private BakedBlueprint baked;
    private Region region;

    public PlacedBlueprint() {
    }

    public PlacedBlueprint(BakedBlueprint baked, ICreationData<?> data) {
        this.def = baked.getDefinition();
        this.registryId = this.def.getRegistry().getRegistryId();
        this.definitionID = this.def.getRegistry().getID(this.def);
        this.data = data;
        this.baked = baked;
        this.pendingPosActions = this.baked.getBakedPositionActions();
        for (int i = 0; i < this.pendingPosActions.size(); ++i) {
            IBakedPosAction action = this.pendingPosActions.get(i).copy();
            action.setPos(action.getPos().func_177971_a((Vec3i)this.getCreationData().getPos()));
            this.pendingPosActions.set(i, action);
        }
        this.region = new Region(this.baked.getBakedRegion());
        this.region.add(this.getCreationData().getPos());
    }

    public BakedBlueprint getBaked() {
        if (this.baked == null) {
            this.baked = new BakedBlueprint(this.def, this.data);
        }
        return this.baked;
    }

    public BlueprintDefinition getDef() {
        return this.def;
    }

    public ICreationData<?> getCreationData() {
        return this.data;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74778_a("registryId", this.registryId);
        tag.func_74768_a("definitionId", this.definitionID);
        funnel.set("creation", this.data);
        funnel.set("region", this.region);
        funnel.setList("pendingPosActions", this.pendingPosActions);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.registryId = tag.func_74779_i("registryId");
        this.definitionID = tag.func_74762_e("definitionId");
        this.def = OrbisLib.services().findDefinitionRegistry(this.registryId).get(this.definitionID);
        this.data = (ICreationData)funnel.get("creation");
        this.region = (Region)funnel.get("region");
        this.pendingPosActions = funnel.getList("pendingPosActions");
    }

    public Region getRegion() {
        return this.region;
    }

    public List<IBakedPosAction> getPendingPosActions() {
        return this.pendingPosActions;
    }
}

