/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.baking;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.baking.BakedScheduleLayers;
import com.gildedgames.orbis.lib.core.baking.IBakedPosAction;
import com.gildedgames.orbis.lib.core.tree.INode;
import com.gildedgames.orbis.lib.core.util.BlueprintUtil;
import com.gildedgames.orbis.lib.core.variables.post_resolve_actions.IPostResolveAction;
import com.gildedgames.orbis.lib.data.IDataUser;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintDataPalette;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.schedules.IPosActionBaker;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayer;
import com.gildedgames.orbis.lib.data.schedules.PostGenReplaceLayer;
import com.gildedgames.orbis.lib.data.schedules.ScheduleBlueprint;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRegion;
import com.gildedgames.orbis.lib.util.RotationHelp;
import com.gildedgames.orbis.lib.util.mc.BlockUtil;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;

public class BakedBlueprint {
    private List<ScheduleRegion> bakedScheduleRegions = Lists.newArrayList();
    private List<BakedBlueprint> bakedBlueprintChildren = Lists.newArrayList();
    private BlockDataContainer bakedBlocks;
    private Region bakedRegion;
    private BlueprintData blueprintData;
    private ICreationData<?> creationData;
    private BlueprintDefinition definition;
    private BakedScheduleLayers bakedScheduleLayers;

    public BakedBlueprint(BlueprintDefinition definition, ICreationData<?> creationData) {
        this(definition.getData(), creationData);
        this.definition = definition;
    }

    public BakedBlueprint(BlueprintData data, ICreationData<?> creationData) {
        this(data, new BakedScheduleLayers(data, creationData.getRandom()), creationData);
    }

    public BakedBlueprint(BlueprintData data, BakedScheduleLayers bakedScheduleLayers, ICreationData<?> creationData) {
        this.blueprintData = data;
        this.bakedScheduleLayers = bakedScheduleLayers;
        this.creationData = creationData;
        this.bake();
    }

    public ICreationData<?> getCreationData() {
        return this.creationData;
    }

    public ScheduleRegion getScheduleFromTriggerID(String triggerId) {
        for (ScheduleRegion s : this.bakedScheduleRegions) {
            if (!s.getTriggerId().equals(triggerId)) continue;
            return s;
        }
        return null;
    }

    private void updateBlueprintChildren() {
        for (INode iNode : this.bakedScheduleLayers.getScheduleLayerNodes()) {
            IScheduleLayer layer = (IScheduleLayer)iNode.getData();
            for (ScheduleBlueprint s : layer.getScheduleRecord().getSchedules(ScheduleBlueprint.class)) {
                BlockPos pos = s.getBounds().getMin();
                BlueprintDataPalette palette = s.getPalette();
                if (palette.getData().size() <= 0) continue;
                BlueprintData data = palette.fetchRandom(this.creationData.getWorld(), this.creationData.getRandom());
                CreationData creationData = new CreationData(this.creationData.getWorld(), this.creationData.getRandom().nextLong()).pos(this.creationData.getPos().func_177971_a((Vec3i)pos)).rotation(s.getRotation()).placesAir(this.creationData.placeAir());
                BakedBlueprint baked = new BakedBlueprint(data, creationData);
                this.bakedBlueprintChildren.add(baked);
            }
        }
    }

    public List<IBakedPosAction> getBakedPositionActions() {
        Region boundsBeforeRotateAtOrigin = new Region(new BlockPos(0, 0, 0), new BlockPos(this.blueprintData.getWidth() - 1, this.blueprintData.getHeight() - 1, this.blueprintData.getLength() - 1));
        for (INode iNode : this.bakedScheduleLayers.getScheduleLayerNodes()) {
            IScheduleLayer layer = (IScheduleLayer)iNode.getData();
            for (ScheduleRegion s : layer.getScheduleRecord().getSchedules(ScheduleRegion.class)) {
                IRegion rotatedBounds = RotationHelp.rotate(s.getBounds(), (IRegion)boundsBeforeRotateAtOrigin, this.creationData.getRotation());
                if (!s.getConditionNodeTree().isEmpty() && !this.bakedScheduleLayers.resolveChildrenConditions(s.getConditionNodeTree().getRootNode())) continue;
                Region bounds = new Region(this.creationData.getPos().func_177971_a((Vec3i)rotatedBounds.getMin()), this.creationData.getPos().func_177971_a((Vec3i)rotatedBounds.getMax()));
                for (INode<IPostResolveAction, NBT> actionNode : s.getPostResolveActionNodeTree().getNodes()) {
                    IDataUser dataUser;
                    if (actionNode.getData() instanceof IDataUser && (dataUser = (IDataUser)((Object)actionNode.getData())).getDataIdentifier().equals("scheduleRegion")) {
                        dataUser.setUsedData(s);
                    }
                    actionNode.getData().resolve(this.creationData.getRandom());
                    if (!(actionNode.getData() instanceof IPosActionBaker)) continue;
                    IPosActionBaker baker = (IPosActionBaker)((Object)actionNode.getData());
                    return baker.bakeActions(bounds, this.creationData.getRandom(), this.creationData.getRotation());
                }
            }
        }
        return new ArrayList<IBakedPosAction>();
    }

    private void updatePostGenReplaceLayers() {
        for (PostGenReplaceLayer postGenReplaceLayer : this.blueprintData.getPostGenReplaceLayers().values()) {
            if (postGenReplaceLayer.getFilterLayer().getRequiredBlocks().isEmpty() || postGenReplaceLayer.getFilterLayer().getReplacementBlocks().isEmpty()) continue;
            boolean choosesPerBlockOld = postGenReplaceLayer.getOptions().getChoosesPerBlockVar().getData();
            postGenReplaceLayer.getOptions().getChoosesPerBlockVar().setData(this.blueprintData.getBlueprintMetadata().getChoosePerBlockOnPostGenVar().getData());
            int width = this.bakedBlocks.getWidth();
            int height = this.bakedBlocks.getHeight();
            int length = this.bakedBlocks.getLength();
            BlockPos min = new BlockPos(0, 0, 0);
            BlockPos max = new BlockPos(width - 1, height - 1, length - 1);
            Region region = new Region(min, max);
            postGenReplaceLayer.getFilter().apply(region.createShapeData(), this.bakedBlocks, this.creationData, postGenReplaceLayer.getOptions());
            postGenReplaceLayer.getOptions().getChoosesPerBlockVar().setData(choosesPerBlockOld);
        }
    }

    private void updateBlocks() {
        BlockDataContainer blocks = this.blueprintData.getBlockDataContainer();
        Rotation rotation = this.creationData.getRotation();
        this.bakedBlocks = this.rotateBlocksAndApplyLayers(blocks, rotation);
        BlockPos dimensions = new BlockPos(blocks.getWidth() - 1, blocks.getHeight() - 1, blocks.getLength() - 1);
        this.bakedRegion = new Region(BlockPos.field_177992_a, RotationHelp.transformedBlockPos(dimensions, rotation));
        this.bakedRegion.add(this.creationData.getPos());
    }

    public BlockDataContainer rotateBlocksAndApplyLayers(BlockDataContainer origBlocks, Rotation rotation) {
        RotationHandler rotater;
        switch (rotation) {
            case NONE: {
                rotater = new RotationHandlerIdentity();
                break;
            }
            case CLOCKWISE_90: {
                rotater = new RotationHandlerClockwise90();
                break;
            }
            case CLOCKWISE_180: {
                rotater = new RotationHandlerClockwise180();
                break;
            }
            case COUNTERCLOCKWISE_90: {
                rotater = new RotationHandlerCounterclockwise90();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rotation");
            }
        }
        BlockPos dim = new BlockPos(origBlocks.getWidth(), origBlocks.getHeight(), origBlocks.getLength());
        BlockPos rotatedDim = rotater.getDimensions(dim);
        BlockDataContainer rotatedBlocks = new BlockDataContainer(origBlocks, rotatedDim.func_177958_n(), rotatedDim.func_177956_o(), rotatedDim.func_177952_p());
        BlockPos.MutableBlockPos rotatedPos = new BlockPos.MutableBlockPos();
        for (int z = 0; z < origBlocks.getLength(); ++z) {
            for (int i = 0; i < origBlocks.getHeight(); ++i) {
                for (int x = 0; x < origBlocks.getWidth(); ++x) {
                    rotater.applyTransformation(rotatedPos.func_181079_c(x, i, z), dim);
                    rotatedBlocks.copyBlockStateWithRotation(origBlocks, x, i, z, rotatedPos.func_177958_n(), rotatedPos.func_177956_o(), rotatedPos.func_177952_p(), rotation);
                }
            }
        }
        for (INode iNode : this.bakedScheduleLayers.getScheduleLayerNodes()) {
            IScheduleLayer layer = (IScheduleLayer)iNode.getData();
            if (layer.getStateRecord().getData().length == 0) continue;
            for (BlockPos pos : layer.getStateRecord().getRegion()) {
                IBlockState layerState = layer.getStateRecord().get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                for (IBlockState predicate : layer.getStateRecord().getData()) {
                    if (predicate != layerState) continue;
                    rotater.applyTransformation(rotatedPos.func_189533_g((Vec3i)pos), dim);
                    if (!layer.getOptions().getReplacesSolidBlocksVar().getData().booleanValue() && BlockUtil.isSolid(rotatedBlocks.getBlockState((BlockPos)rotatedPos))) continue;
                    rotatedBlocks.setBlockState(predicate, (BlockPos)rotatedPos);
                }
            }
        }
        for (BlockDataContainer.TileEntityEntry tileEntityEntry : origBlocks.getTileEntityEntries()) {
            rotater.applyTransformation(rotatedPos.func_189533_g((Vec3i)tileEntityEntry.pos), dim);
            rotatedBlocks.setTileEntity(tileEntityEntry.data.func_74737_b(), (BlockPos)rotatedPos);
        }
        return rotatedBlocks;
    }

    private void updateScheduleRegions() {
        Rotation rotation = this.creationData.getRotation();
        for (INode iNode : this.bakedScheduleLayers.getScheduleLayerNodes()) {
            IScheduleLayer layer = (IScheduleLayer)iNode.getData();
            for (ScheduleRegion s : layer.getScheduleRecord().getSchedules(ScheduleRegion.class)) {
                ScheduleRegion c = NBTHelper.clone(s);
                BlockPos min = RotationHelp.transformedBlockPos(c.getBounds().getMin(), rotation);
                BlockPos max = RotationHelp.transformedBlockPos(c.getBounds().getMax(), rotation);
                c.getBounds().setBounds(min, max);
                this.bakedScheduleRegions.add(c);
            }
        }
    }

    private void bake() {
        this.updateBlocks();
        this.updateBlueprintChildren();
        this.updateScheduleRegions();
        this.updatePostGenReplaceLayers();
    }

    public ChunkPos[] getOccupiedChunks(BlockPos offset) {
        return BlueprintUtil.getChunksInsideTemplate(this.bakedBlocks, this.bakedRegion.getMin().func_177971_a((Vec3i)offset), Rotation.NONE);
    }

    public int getWidth() {
        return this.bakedRegion.getWidth();
    }

    public int getHeight() {
        return this.bakedRegion.getHeight();
    }

    public int getLength() {
        return this.bakedRegion.getLength();
    }

    public BlockDataContainer getBlockData() {
        return this.bakedBlocks;
    }

    public Region getBakedRegion() {
        return this.bakedRegion;
    }

    public List<BakedBlueprint> getBakedBlueprintChildren() {
        return this.bakedBlueprintChildren;
    }

    public BakedScheduleLayers getScheduleLayers() {
        return this.bakedScheduleLayers;
    }

    @Nullable
    public BlueprintDefinition getDefinition() {
        return this.definition;
    }

    private static class RotationHandlerIdentity
    implements RotationHandler {
        private RotationHandlerIdentity() {
        }

        @Override
        public BlockPos.MutableBlockPos applyTransformation(BlockPos.MutableBlockPos pos, BlockPos dimensions) {
            return pos;
        }

        @Override
        public BlockPos getDimensions(BlockPos dimensions) {
            return dimensions;
        }
    }

    private static class RotationHandlerClockwise180
    implements RotationHandler {
        private RotationHandlerClockwise180() {
        }

        @Override
        public BlockPos.MutableBlockPos applyTransformation(BlockPos.MutableBlockPos pos, BlockPos dimensions) {
            int x = dimensions.func_177958_n() - pos.func_177958_n() - 1;
            int z = dimensions.func_177952_p() - pos.func_177952_p() - 1;
            return pos.func_181079_c(x, pos.func_177956_o(), z);
        }

        @Override
        public BlockPos getDimensions(BlockPos dimensions) {
            return dimensions;
        }
    }

    private static class RotationHandlerCounterclockwise90
    implements RotationHandler {
        private RotationHandlerCounterclockwise90() {
        }

        @Override
        public BlockPos.MutableBlockPos applyTransformation(BlockPos.MutableBlockPos pos, BlockPos dimensions) {
            int x = pos.func_177952_p();
            int z = dimensions.func_177958_n() - pos.func_177958_n() - 1;
            return pos.func_181079_c(x, pos.func_177956_o(), z);
        }

        @Override
        public BlockPos getDimensions(BlockPos dimensions) {
            return new BlockPos(dimensions.func_177952_p(), dimensions.func_177956_o(), dimensions.func_177958_n());
        }
    }

    private static class RotationHandlerClockwise90
    implements RotationHandler {
        private RotationHandlerClockwise90() {
        }

        @Override
        public BlockPos.MutableBlockPos applyTransformation(BlockPos.MutableBlockPos pos, BlockPos dimensions) {
            int x = dimensions.func_177952_p() - pos.func_177952_p() - 1;
            int z = pos.func_177958_n();
            return pos.func_181079_c(x, pos.func_177956_o(), z);
        }

        @Override
        public BlockPos getDimensions(BlockPos dimensions) {
            return new BlockPos(dimensions.func_177952_p(), dimensions.func_177956_o(), dimensions.func_177958_n());
        }
    }

    private static interface RotationHandler {
        public BlockPos.MutableBlockPos applyTransformation(BlockPos.MutableBlockPos var1, BlockPos var2);

        public BlockPos getDimensions(BlockPos var1);
    }
}

