/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.baking;

import com.gildedgames.orbis.lib.core.baking.IBakedPosAction;
import com.gildedgames.orbis.lib.processing.DataPrimer;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BakedEntitySpawn
implements IBakedPosAction {
    private ItemStack egg;
    private BlockPos pos;
    private boolean customRotation;
    private float rotationDegrees;

    private BakedEntitySpawn() {
    }

    public BakedEntitySpawn(ItemStack egg, BlockPos pos, boolean customRotation, float rotationDegrees) {
        this.egg = egg;
        this.pos = pos;
        this.customRotation = customRotation;
        this.rotationDegrees = rotationDegrees;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void call(DataPrimer primer) {
        World world = primer.getWorld();
        Entity entity = EntityUtil.spawnCreature(primer, world, ItemMonsterPlacer.func_190908_h((ItemStack)this.egg), (double)this.pos.func_177958_n() + 0.5, this.pos.func_177956_o(), (double)this.pos.func_177952_p() + 0.5, this.customRotation, this.rotationDegrees);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && this.egg.func_82837_s()) {
                entity.func_96094_a(this.egg.func_82833_r());
            }
            if (world != null) {
                ItemMonsterPlacer.func_185079_a((World)world, null, (ItemStack)this.egg, (Entity)entity);
            }
        }
    }

    @Override
    public IBakedPosAction copy() {
        BakedEntitySpawn spawn = new BakedEntitySpawn();
        spawn.customRotation = this.customRotation;
        spawn.egg = this.egg;
        spawn.pos = this.pos;
        spawn.rotationDegrees = this.rotationDegrees;
        return spawn;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setStack("egg", this.egg);
        funnel.setPos("pos", this.pos);
        tag.func_74757_a("customRotation", this.customRotation);
        tag.func_74776_a("rotationDegrees", this.rotationDegrees);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.egg = funnel.getStack("egg");
        this.pos = funnel.getPos("pos");
        this.customRotation = tag.func_74767_n("customRotation");
        this.rotationDegrees = tag.func_74760_g("rotationDegrees");
    }
}

