/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.conditions;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.core.PlacementCondition;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.util.ArrayHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class PlacementConditionOnBlock
implements PlacementCondition {
    private final Block[] blocks;

    public PlacementConditionOnBlock(Block ... blocks) {
        this.blocks = blocks;
    }

    @Override
    public boolean validate(IBlockAccessExtended access, BakedBlueprint blueprint, BlockPos offset) {
        BlockDataContainer container = blueprint.getBlockData();
        int floorHeight = blueprint.getDefinition().getFloorHeight();
        if (!access.canAccess(offset.func_177958_n(), offset.func_177956_o() + floorHeight - 1, offset.func_177952_p(), offset.func_177958_n() + container.getWidth(), offset.func_177956_o() + floorHeight, offset.func_177952_p() + container.getLength())) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < container.getWidth(); ++x) {
            for (int z = 0; z < container.getLength(); ++z) {
                IBlockState blueprintBlock = container.getBlockState(x, floorHeight, z);
                if (blueprintBlock.func_177230_c() == Blocks.field_150350_a || blueprintBlock.func_177230_c() == Blocks.field_189881_dj) continue;
                pos.func_181079_c(offset.func_177958_n() + x, offset.func_177956_o() + floorHeight - 1, offset.func_177952_p() + z);
                if (ArrayHelper.contains(this.blocks, access.func_180495_p((BlockPos)pos).func_177230_c())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

