/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.conditions;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.core.PlacementCondition;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.util.BlueprintUtil;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.util.ArrayHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class PlacementConditionReplaceableMaterials
implements PlacementCondition {
    private final Material[] acceptedMaterials;

    public PlacementConditionReplaceableMaterials(Material ... acceptedMaterials) {
        this.acceptedMaterials = acceptedMaterials;
    }

    @Override
    public boolean validate(IBlockAccessExtended access, BakedBlueprint blueprint, BlockPos offset) {
        BlockDataContainer container = blueprint.getBlockData();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < container.getWidth(); ++x) {
            for (int z = 0; z < container.getLength(); ++z) {
                for (int y = 0; y < container.getHeight(); ++y) {
                    IBlockState blueprintBlock = container.getBlockState(x, y, z);
                    if (!blueprintBlock.func_185904_a().func_76220_a()) continue;
                    pos.func_181079_c(offset.func_177958_n() + x, offset.func_177956_o() + y, offset.func_177952_p() + z);
                    IBlockState worldBlock = access.func_180495_p((BlockPos)pos);
                    if (BlueprintUtil.isReplaceable(worldBlock) || ArrayHelper.contains(this.acceptedMaterials, worldBlock.func_185904_a()) || blueprintBlock == worldBlock) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

