/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.registry;

import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.core.registry.IOrbisDefinitionRegistry;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

public class OrbisDefinitionRegistry
implements IOrbisDefinitionRegistry {
    private final BiMap<Integer, BlueprintDefinition> idToTemplate = HashBiMap.create();
    private final String registryId;

    public OrbisDefinitionRegistry(String registryId) {
        this.registryId = registryId;
    }

    @Override
    public String getRegistryId() {
        return this.registryId;
    }

    @Override
    public int getID(BlueprintDefinition def) {
        return (Integer)this.idToTemplate.inverse().get((Object)def);
    }

    @Override
    public BlueprintDefinition get(int id) {
        return (BlueprintDefinition)this.idToTemplate.get((Object)id);
    }

    @Override
    public void register(int id, BlueprintDefinition def) {
        this.idToTemplate.put((Object)id, (Object)def);
    }
}

