/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.util;

import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.util.RotationHelp;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;

public class BlueprintUtil {
    public static IRegion getRegionFromDefinition(IDimensions data, BlockPos pos, Rotation rotation) {
        Region region = rotation == Rotation.NONE ? new Region(data) : RotationHelp.rotate(new Region(data), rotation);
        return (IRegion)region.translate(pos);
    }

    public static ChunkPos[] getChunksInsideTemplate(IDimensions data, BlockPos pos, Rotation rotation) {
        IRegion bb = BlueprintUtil.getRegionFromDefinition(data, pos, rotation);
        int minX = Math.min(bb.getMin().func_177958_n(), bb.getMax().func_177958_n());
        int minZ = Math.min(bb.getMin().func_177952_p(), bb.getMax().func_177952_p());
        int maxX = Math.max(bb.getMin().func_177958_n(), bb.getMax().func_177958_n());
        int maxZ = Math.max(bb.getMin().func_177952_p(), bb.getMax().func_177952_p());
        int startChunkX = minX >> 4;
        int startChunkY = minZ >> 4;
        int endChunkX = maxX >> 4;
        int endChunkY = maxZ >> 4;
        int width = endChunkX - startChunkX + 1;
        int length = endChunkY - startChunkY + 1;
        ChunkPos[] chunks = new ChunkPos[width * length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < length; ++y) {
                chunks[x + y * width] = new ChunkPos(startChunkX + x, startChunkY + y);
            }
        }
        return chunks;
    }

    public static boolean canGrowInto(Block block) {
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151597_y;
    }

    public static boolean isReplaceable(IBlockAccessExtended world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || BlueprintUtil.canGrowInto(state.func_177230_c());
    }

    public static boolean isReplaceable(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151597_y;
    }
}

