/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables;

import com.gildedgames.orbis.lib.client.gui.data.DropdownElementWithData;
import com.gildedgames.orbis.lib.client.gui.data.IDropdownElement;
import com.gildedgames.orbis.lib.client.gui.util.GuiDropdown;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.core.tree.INode;
import com.gildedgames.orbis.lib.core.tree.INodeTreeListener;
import com.gildedgames.orbis.lib.core.tree.NodeTree;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.IGuiVarCompareExpression;
import com.gildedgames.orbis.lib.core.variables.IGuiVarMutateExpression;
import com.gildedgames.orbis.lib.core.variables.displays.GuiVarDisplay;
import com.gildedgames.orbis.lib.data.IDataUser;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintVariable;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiVarBlueprintVariable
implements IGuiVar<INode<BlueprintVariable, NBT>, GuiDropdown<DropdownElementWithData<INode<BlueprintVariable, NBT>>>>,
IDataUser<NodeTree<BlueprintVariable, NBT>>,
INodeTreeListener<BlueprintVariable, NBT> {
    private GuiVarDisplay parentDisplay;
    private NodeTree<BlueprintVariable, NBT> blueprintVariables;
    private String name;
    private INode<BlueprintVariable, NBT> data;
    private int dataIndex;
    private Consumer<BlueprintVariable<?>> onSetData;

    private GuiVarBlueprintVariable() {
    }

    public GuiVarBlueprintVariable(String name, Consumer<BlueprintVariable<?>> onSetData) {
        this.name = name;
        this.onSetData = onSetData;
    }

    public void setOnSetData(Consumer<BlueprintVariable<?>> onSetData) {
        this.onSetData = onSetData;
    }

    @Override
    public void setParentDisplay(GuiVarDisplay parentDisplay) {
        this.parentDisplay = parentDisplay;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public String getDataName() {
        return "orbis.gui.blueprint_variable";
    }

    @Override
    public INode<BlueprintVariable, NBT> getData() {
        return this.data;
    }

    @Override
    public void setData(INode<BlueprintVariable, NBT> data) {
        this.data = data;
        if (this.blueprintVariables != null) {
            this.dataIndex = this.blueprintVariables.get(this.data);
        }
    }

    @Override
    public GuiDropdown<DropdownElementWithData<INode<BlueprintVariable, NBT>>> createDisplay(int maxWidth) {
        ArrayList elements = Lists.newArrayList();
        if (this.blueprintVariables != null) {
            this.blueprintVariables.getNodes().forEach(n -> {
                DropdownElementWithData<INode> element = new DropdownElementWithData<INode>((ITextComponent)new TextComponentTranslation(((BlueprintVariable)n.getData()).getUniqueNameVar().getData(), new Object[0]), (INode)n);
                elements.add(element);
            });
        }
        GuiDropdown dropdown = new GuiDropdown(Dim2D.build().width(maxWidth).flush(), e -> {
            this.setData((INode)e.getData());
            if (this.onSetData != null) {
                this.onSetData.accept(this.data.getData());
            }
        }, (IDropdownElement[])new DropdownElementWithData[0]);
        dropdown.getList().setDropdownElements(elements);
        if (this.blueprintVariables != null && elements.size() > this.dataIndex) {
            DropdownElementWithData element = (DropdownElementWithData)elements.get(this.dataIndex);
            dropdown.setChosenElement(element);
            if (this.data == null) {
                this.setData((INode)element.getData());
                if (this.onSetData != null) {
                    this.onSetData.accept(this.data.getData());
                }
            }
        }
        return dropdown;
    }

    @Override
    public void updateDataFromDisplay(GuiDropdown<DropdownElementWithData<INode<BlueprintVariable, NBT>>> blueprintVariableGuiDropdown) {
        if (blueprintVariableGuiDropdown.getChosenElement() != null && blueprintVariableGuiDropdown.getChosenElement().getData() != null) {
            this.setData(blueprintVariableGuiDropdown.getChosenElement().getData());
        }
    }

    @Override
    public void resetDisplayFromData(GuiDropdown<DropdownElementWithData<INode<BlueprintVariable, NBT>>> blueprintVariableGuiDropdown) {
        DropdownElementWithData<INode<BlueprintVariable, NBT>> element = null;
        for (DropdownElementWithData<INode<BlueprintVariable, NBT>> e : blueprintVariableGuiDropdown.getList().getElements()) {
            if (e.getData() != this.data) continue;
            element = e;
            break;
        }
        blueprintVariableGuiDropdown.setChosenElement(element);
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarCompareExpression>>> getCompareExpressions() {
        return Collections.emptyList();
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarMutateExpression>>> getMutateExpressions() {
        return Collections.emptyList();
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("dataIndex", this.dataIndex);
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.dataIndex = tag.func_74762_e("dataIndex");
    }

    @Override
    public void onSetData(INode<BlueprintVariable, NBT> node, BlueprintVariable variable, int id) {
        if (id == this.dataIndex) {
            this.setData(node);
            if (this.onSetData != null) {
                this.onSetData.accept(this.data.getData());
            }
        }
    }

    @Override
    public void onPut(INode<BlueprintVariable, NBT> node, int id) {
        if (id == this.dataIndex) {
            this.setData(node);
            if (this.onSetData != null) {
                this.onSetData.accept(this.data.getData());
            }
        }
    }

    @Override
    public void onRemove(INode<BlueprintVariable, NBT> node, int id) {
        if (id == this.dataIndex) {
            this.setData(null);
            if (this.onSetData != null) {
                this.onSetData.accept(null);
            }
        }
    }

    @Override
    public String getDataIdentifier() {
        return "blueprintVariables";
    }

    @Override
    public void setUsedData(NodeTree<BlueprintVariable, NBT> data) {
        this.blueprintVariables = data;
        this.data = this.blueprintVariables.get(this.dataIndex);
        this.blueprintVariables.listen(this);
    }
}

