/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables;

import com.gildedgames.orbis.lib.client.gui.data.DropdownElement;
import com.gildedgames.orbis.lib.client.gui.data.DropdownElementWithData;
import com.gildedgames.orbis.lib.client.gui.data.IDropdownElement;
import com.gildedgames.orbis.lib.client.gui.util.GuiDropdown;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.IGuiVarCompareExpression;
import com.gildedgames.orbis.lib.core.variables.IGuiVarMutateExpression;
import com.gildedgames.orbis.lib.core.variables.displays.GuiVarDisplay;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiVarDropdown<DATA extends NBT>
implements IGuiVar<DATA, GuiDropdown<IDropdownElement>> {
    private GuiVarDisplay parentDisplay;
    private String name;
    private DATA data;
    private int dataIndex;
    private List<String> elements;
    private Function<String, DATA> stringToDataFactory;
    private Consumer<DATA> onSetData;

    private GuiVarDropdown() {
    }

    public GuiVarDropdown(String name, List<String> elements, Function<String, DATA> stringToDataFactory) {
        this.name = name;
        this.elements = elements;
        this.stringToDataFactory = stringToDataFactory;
    }

    public void setStringElements(List<String> elements) {
        this.elements = elements;
    }

    public void setStringToDataFactory(Function<String, DATA> stringToDataFactory) {
        this.stringToDataFactory = stringToDataFactory;
    }

    public void setOnSetData(Consumer<DATA> onSetData) {
        this.onSetData = onSetData;
    }

    @Override
    public void setParentDisplay(GuiVarDisplay parentDisplay) {
        this.parentDisplay = parentDisplay;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public String getDataName() {
        return "orbis.gui.dropdown";
    }

    @Override
    public DATA getData() {
        return this.data;
    }

    @Override
    public void setData(DATA data) {
        this.data = data;
        this.onSetData.accept(data);
    }

    @Override
    public GuiDropdown<IDropdownElement> createDisplay(int maxWidth) {
        ArrayList elements = Lists.newArrayList();
        this.elements.forEach(elementName -> {
            DropdownElement element = new DropdownElement((ITextComponent)new TextComponentTranslation(elementName, new Object[0]));
            elements.add(element);
        });
        GuiDropdown dropdown = new GuiDropdown(Dim2D.build().width(maxWidth).flush(), e -> {
            NBT data = (NBT)this.stringToDataFactory.apply(e.text().func_150261_e());
            this.setData((DATA)data);
            this.dataIndex = this.elements.indexOf(e.text().func_150261_e());
        }, new IDropdownElement[0]);
        dropdown.getList().setDropdownElements(elements);
        if (elements.size() > this.dataIndex) {
            IDropdownElement element = (IDropdownElement)elements.get(this.dataIndex);
            dropdown.setChosenElement(element);
            if (this.data == null) {
                NBT data = (NBT)this.stringToDataFactory.apply(element.text().func_150261_e());
                this.setData((DATA)data);
            }
        }
        return dropdown;
    }

    @Override
    public void updateDataFromDisplay(GuiDropdown<IDropdownElement> dropdown) {
    }

    @Override
    public void resetDisplayFromData(GuiDropdown<IDropdownElement> dropdown) {
        IDropdownElement element = null;
        for (IDropdownElement e : dropdown.getList().getElements()) {
            if (!e.text().func_150261_e().equals(this.elements.get(this.dataIndex))) continue;
            element = e;
            break;
        }
        dropdown.setChosenElement(element);
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarCompareExpression>>> getCompareExpressions() {
        return Collections.emptyList();
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarMutateExpression>>> getMutateExpressions() {
        return Collections.emptyList();
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("dataIndex", this.dataIndex);
        funnel.set("data", (NBT)this.data);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.name = tag.func_74779_i("name");
        this.dataIndex = tag.func_74762_e("dataIndex");
        this.data = funnel.get("data");
    }
}

