/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables;

import com.gildedgames.orbis.lib.client.gui.data.DropdownElementWithData;
import com.gildedgames.orbis.lib.client.gui.util.GuiInputSlider;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.IGuiVarCompareExpression;
import com.gildedgames.orbis.lib.core.variables.IGuiVarMutateExpression;
import com.gildedgames.orbis.lib.core.variables.displays.GuiVarDisplay;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;

public class GuiVarFloatRange
implements IGuiVar<Float, GuiInputSlider> {
    private float min;
    private float max;
    private float data;
    private String name = "";

    private GuiVarFloatRange() {
    }

    public GuiVarFloatRange(String name, float min, float max) {
        this.name = name;
        this.min = min;
        this.max = max;
    }

    @Override
    public void setParentDisplay(GuiVarDisplay parentDisplay) {
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public String getDataName() {
        return "orbis.gui.float_range";
    }

    @Override
    public Float getData() {
        return Float.valueOf(this.data);
    }

    @Override
    public void setData(Float data) {
        this.data = data.floatValue();
    }

    @Override
    public GuiInputSlider createDisplay(int maxWidth) {
        return new GuiInputSlider(Dim2D.build().width(maxWidth).x(1.0f).height(20.0f).flush(), this.min, this.max, this.data <= 0.0f ? 0.0f : this.data / this.max);
    }

    @Override
    public void updateDataFromDisplay(GuiInputSlider guiFrame) {
        this.data = guiFrame.getSliderValue() * this.max;
    }

    @Override
    public void resetDisplayFromData(GuiInputSlider guiFrame) {
        guiFrame.setSliderValue(this.data / this.max);
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarCompareExpression>>> getCompareExpressions() {
        return null;
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarMutateExpression>>> getMutateExpressions() {
        return null;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74776_a("data", this.data);
        tag.func_74776_a("min", this.min);
        tag.func_74776_a("max", this.max);
        tag.func_74778_a("name", this.name);
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.data = tag.func_74760_g("data");
        this.min = tag.func_74760_g("min");
        this.max = tag.func_74760_g("max");
        this.name = tag.func_74779_i("name");
    }
}

