/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables;

import com.gildedgames.orbis.lib.client.gui.data.DropdownElementWithData;
import com.gildedgames.orbis.lib.client.gui.util.GuiInput;
import com.gildedgames.orbis.lib.client.gui.util.IGuiInputListener;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.IGuiVarCompareExpression;
import com.gildedgames.orbis.lib.core.variables.IGuiVarMutateExpression;
import com.gildedgames.orbis.lib.core.variables.displays.GuiVarDisplay;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiVarString
implements IGuiVar<String, GuiInput>,
IGuiInputListener {
    public static final List<DropdownElementWithData<Supplier<IGuiVarCompareExpression>>> COMPARE_EXPRESSIONS = Lists.newArrayList((Object[])new DropdownElementWithData[]{new DropdownElementWithData<Supplier<IGuiVarCompareExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.equals", new Object[0]), Equals::new), new DropdownElementWithData<Supplier<IGuiVarCompareExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.doesnt_equal", new Object[0]), DoesntEqual::new), new DropdownElementWithData<Supplier<IGuiVarCompareExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.contains", new Object[0]), Contains::new)});
    public static final List<DropdownElementWithData<Supplier<IGuiVarMutateExpression>>> MUTATE_EXPRESSIONS = Lists.newArrayList((Object[])new DropdownElementWithData[]{new DropdownElementWithData<Supplier<IGuiVarMutateExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.set", new Object[0]), Set::new), new DropdownElementWithData<Supplier<IGuiVarMutateExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.concatenate", new Object[0]), Concatenate::new), new DropdownElementWithData<Supplier<IGuiVarMutateExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.replace", new Object[0]), Replace::new), new DropdownElementWithData<Supplier<IGuiVarMutateExpression>>((ITextComponent)new TextComponentTranslation("orbis.gui.clear", new Object[0]), Clear::new)});
    private String data = "";
    private String name = "";
    private int maxStringLength;
    private GuiVarDisplay parentDisplay;

    private GuiVarString() {
    }

    public GuiVarString(String name, int maxStringLength) {
        this.name = name;
        this.maxStringLength = maxStringLength;
    }

    public GuiVarString(String name) {
        this.name = name;
        this.maxStringLength = -1;
    }

    @Override
    public void setParentDisplay(GuiVarDisplay parentDisplay) {
        this.parentDisplay = parentDisplay;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public String getDataName() {
        return "orbis.gui.string";
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public GuiInput createDisplay(int maxWidth) {
        GuiInput input = new GuiInput(Dim2D.build().width(maxWidth).x(1.0f).height(20.0f).flush());
        input.getInner().func_146180_a(this.data);
        input.listen(this);
        if (this.maxStringLength >= 0) {
            input.getInner().func_146203_f(this.maxStringLength);
        }
        return input;
    }

    @Override
    public void updateDataFromDisplay(GuiInput guiInput) {
        this.data = guiInput.getInner().func_146179_b();
    }

    @Override
    public void resetDisplayFromData(GuiInput guiInput) {
        guiInput.getInner().func_146180_a(this.data);
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarCompareExpression>>> getCompareExpressions() {
        return COMPARE_EXPRESSIONS;
    }

    @Override
    public List<DropdownElementWithData<Supplier<IGuiVarMutateExpression>>> getMutateExpressions() {
        return MUTATE_EXPRESSIONS;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74778_a("data", this.data);
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("maxStringLength", this.maxStringLength);
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.data = tag.func_74779_i("data");
        this.name = tag.func_74779_i("name");
        this.maxStringLength = tag.func_74762_e("maxStringLength");
    }

    @Override
    public void onPressEnter() {
        if (this.parentDisplay != null) {
            this.parentDisplay.updateVariableData();
        }
    }

    public static class Clear
    implements IGuiVarMutateExpression<String> {
        @Override
        public String mutate(String input) {
            return "";
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.clear";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return Collections.emptyList();
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
        }

        @Override
        public void write(NBTTagCompound tag) {
        }

        @Override
        public void read(NBTTagCompound tag) {
        }
    }

    public static class Replace
    implements IGuiVarMutateExpression<String> {
        private GuiVarString replace;
        private GuiVarString with;
        private List<IGuiVar<String, ?>> inputs = Lists.newArrayList();

        public Replace() {
            this.replace = new GuiVarString("orbis.gui.replace");
            this.with = new GuiVarString("orbis.gui.with");
            this.inputs.add(this.replace);
            this.inputs.add(this.with);
        }

        @Override
        public String mutate(String input) {
            return input.replace(this.replace.getData(), this.with.getData());
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.replace";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
            if (prevInputs.size() >= 1) {
                this.replace.setData(prevInputs.get(0).getData());
            }
            if (prevInputs.size() >= 2) {
                this.with.setData(prevInputs.get(1).getData());
            }
        }

        @Override
        public void write(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("replace", this.replace);
            funnel.set("with", this.with);
        }

        @Override
        public void read(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            this.replace = (GuiVarString)funnel.get("replace");
            this.with = (GuiVarString)funnel.get("with");
            this.inputs.clear();
            this.inputs.add(this.replace);
            this.inputs.add(this.with);
        }
    }

    public static class Concatenate
    implements IGuiVarMutateExpression<String> {
        private GuiVarString value;
        private List<IGuiVar<String, ?>> inputs = Lists.newArrayList();

        public Concatenate() {
            this.value = new GuiVarString("orbis.gui.value");
            this.inputs.add(this.value);
        }

        @Override
        public String mutate(String input) {
            return input + this.value.getData();
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.concatenate";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
            if (prevInputs.size() >= 1) {
                this.value.setData(prevInputs.get(0).getData());
            }
        }

        @Override
        public void write(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("value", this.value);
        }

        @Override
        public void read(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            this.value = (GuiVarString)funnel.get("value");
            this.inputs.clear();
            this.inputs.add(this.value);
        }
    }

    public static class Set
    implements IGuiVarMutateExpression<String> {
        private GuiVarString value;
        private List<IGuiVar<String, ?>> inputs = Lists.newArrayList();

        public Set() {
            this.value = new GuiVarString("orbis.gui.value");
            this.inputs.add(this.value);
        }

        @Override
        public String mutate(String input) {
            return this.value.getData();
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.set";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
            if (prevInputs.size() >= 1) {
                this.value.setData(prevInputs.get(0).getData());
            }
        }

        @Override
        public void write(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("value", this.value);
        }

        @Override
        public void read(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            this.value = (GuiVarString)funnel.get("value");
            this.inputs.clear();
            this.inputs.add(this.value);
        }
    }

    public static class Contains
    implements IGuiVarCompareExpression<String> {
        private GuiVarString value;
        private List<IGuiVar<String, ?>> inputs = Lists.newArrayList();

        public Contains() {
            this.value = new GuiVarString("orbis.gui.value");
            this.inputs.add(this.value);
        }

        @Override
        public boolean compare(Object input) {
            if (input instanceof String) {
                return ((String)input).contains(this.value.getData());
            }
            return false;
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.contains";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
            if (prevInputs.size() >= 1) {
                this.value.setData(prevInputs.get(0).getData());
            }
        }

        @Override
        public void write(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("value", this.value);
        }

        @Override
        public void read(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            this.value = (GuiVarString)funnel.get("value");
            this.inputs.clear();
            this.inputs.add(this.value);
        }
    }

    public static class DoesntEqual
    implements IGuiVarCompareExpression<String> {
        private GuiVarString value;
        private List<IGuiVar<String, ?>> inputs = Lists.newArrayList();

        public DoesntEqual() {
            this.value = new GuiVarString("orbis.gui.value");
            this.inputs.add(this.value);
        }

        @Override
        public boolean compare(Object input) {
            return !input.equals(this.value.getData());
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.doesnt_equal";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
            if (prevInputs.size() >= 1) {
                this.value.setData(prevInputs.get(0).getData());
            }
        }

        @Override
        public void write(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("value", this.value);
        }

        @Override
        public void read(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            this.value = (GuiVarString)funnel.get("value");
            this.inputs.clear();
            this.inputs.add(this.value);
        }
    }

    public static class Equals
    implements IGuiVarCompareExpression<String> {
        private GuiVarString value;
        private List<IGuiVar<String, ?>> inputs = Lists.newArrayList();

        public Equals() {
            this.value = new GuiVarString("orbis.gui.value");
            this.inputs.add(this.value);
        }

        @Override
        public boolean compare(Object input) {
            return input.equals(this.value.getData());
        }

        @Override
        public String getDisplayString() {
            return "orbis.gui.equals";
        }

        @Override
        public List<IGuiVar<String, ?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void transferData(List<IGuiVar<String, ?>> prevInputs) {
            if (prevInputs.size() >= 1) {
                this.value.setData(prevInputs.get(0).getData());
            }
        }

        @Override
        public void write(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("value", this.value);
        }

        @Override
        public void read(NBTTagCompound tag) {
            NBTFunnel funnel = new NBTFunnel(tag);
            this.value = (GuiVarString)funnel.get("value");
            this.inputs.clear();
            this.inputs.add(this.value);
        }
    }
}

