/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables.conditions;

import com.gildedgames.orbis.lib.client.gui.data.DropdownElementWithData;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.core.tree.NodeTree;
import com.gildedgames.orbis.lib.core.variables.GuiVarBlueprintVariable;
import com.gildedgames.orbis.lib.core.variables.GuiVarDropdown;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.IGuiVarCompareExpression;
import com.gildedgames.orbis.lib.core.variables.conditions.IGuiCondition;
import com.gildedgames.orbis.lib.core.variables.displays.GuiVarDisplay;
import com.gildedgames.orbis.lib.data.IDataUser;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintVariable;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;

public class GuiConditionCheckBlueprintVariable
implements IGuiCondition,
IDataUser<NodeTree<BlueprintVariable, NBT>> {
    private List<IGuiVar> variables = Lists.newArrayList();
    private GuiVarBlueprintVariable guiVarBlueprintVariable;
    private GuiVarDropdown<IGuiVarCompareExpression<?>> compareDropdown;
    private Pos2D guiPos = Pos2D.ORIGIN;
    private GuiVarDisplay parentDisplay;
    private Consumer<IGuiVarCompareExpression<?>> onSetCompareDropdown = e -> {
        this.variables.clear();
        this.variables.add(this.guiVarBlueprintVariable);
        this.variables.add(this.compareDropdown);
        for (IGuiVar var : e.getInputs()) {
            this.variables.add(var);
        }
        this.parentDisplay.refresh();
    };
    private Consumer<BlueprintVariable<?>> onSetBlueprintVariable = b -> {
        if (b == null) {
            this.compareDropdown = null;
            this.variables.clear();
            this.variables.add(this.guiVarBlueprintVariable);
            if (this.parentDisplay != null) {
                this.parentDisplay.refresh();
            }
        } else {
            this.compareDropdown = new GuiVarDropdown("orbis.gui.compare", this.createCompareDropdownStringElements((BlueprintVariable<?>)b), this.createCompareDropdownDataFactory((BlueprintVariable<?>)b));
            this.compareDropdown.setOnSetData(this.onSetCompareDropdown);
            this.variables.clear();
            this.variables.add(this.guiVarBlueprintVariable);
            this.variables.add(this.compareDropdown);
            if (this.parentDisplay != null) {
                this.parentDisplay.refresh();
            }
        }
    };

    public GuiConditionCheckBlueprintVariable() {
        this.guiVarBlueprintVariable = new GuiVarBlueprintVariable("orbis.gui.selected_variable", this.onSetBlueprintVariable);
        this.variables.add(this.guiVarBlueprintVariable);
    }

    private List<String> createCompareDropdownStringElements(BlueprintVariable<?> variable) {
        ArrayList compareElements = Lists.newArrayList();
        for (DropdownElementWithData<Supplier<IGuiVarCompareExpression>> expression : variable.getVar().getCompareExpressions()) {
            compareElements.add(expression.text().func_150261_e());
        }
        return compareElements;
    }

    private Function<String, IGuiVarCompareExpression<?>> createCompareDropdownDataFactory(BlueprintVariable<?> variable) {
        return s -> {
            for (DropdownElementWithData<Supplier<IGuiVarCompareExpression>> expression : variable.getVar().getCompareExpressions()) {
                if (!expression.text().func_150261_e().equals(s)) continue;
                return expression.getData().get();
            }
            return null;
        };
    }

    @Override
    public String getName() {
        return "orbis.gui.check_blueprint_variable";
    }

    @Override
    public List<IGuiVar> getVariables() {
        return this.variables;
    }

    @Override
    public boolean resolve(Random rand) {
        return ((IGuiVarCompareExpression)this.compareDropdown.getData()).compare(((BlueprintVariable)this.guiVarBlueprintVariable.getData().getData()).getVar().getData());
    }

    @Override
    public Pos2D getGuiPos() {
        return this.guiPos;
    }

    @Override
    public void setGuiPos(Pos2D pos) {
        this.guiPos = pos;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("guiVarBlueprintVariable", this.guiVarBlueprintVariable);
        funnel.set("compareDropdown", this.compareDropdown);
        funnel.set("guiPos", this.guiPos, NBTFunnel.POS2D_SETTER);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.guiVarBlueprintVariable = (GuiVarBlueprintVariable)funnel.get("guiVarBlueprintVariable");
        this.compareDropdown = (GuiVarDropdown)funnel.get("compareDropdown");
        this.guiPos = funnel.getWithDefault("guiPos", NBTFunnel.POS2D_GETTER, () -> this.guiPos);
        this.guiVarBlueprintVariable.setOnSetData(this.onSetBlueprintVariable);
        if (this.compareDropdown != null) {
            this.compareDropdown.setOnSetData(this.onSetCompareDropdown);
        }
        this.variables.clear();
        this.variables.add(this.guiVarBlueprintVariable);
        this.variables.add(this.compareDropdown);
    }

    @Override
    public void setParentDisplay(GuiVarDisplay parentDisplay) {
        this.parentDisplay = parentDisplay;
    }

    @Override
    public String getDataIdentifier() {
        return "blueprintVariables";
    }

    @Override
    public void setUsedData(NodeTree<BlueprintVariable, NBT> data) {
        this.guiVarBlueprintVariable.setUsedData(data);
        if (this.guiVarBlueprintVariable.getData() != null) {
            BlueprintVariable b = (BlueprintVariable)this.guiVarBlueprintVariable.getData().getData();
            if (this.compareDropdown != null) {
                this.compareDropdown.setStringElements(this.createCompareDropdownStringElements(b));
                this.compareDropdown.setStringToDataFactory(this.createCompareDropdownDataFactory(b));
                if (this.compareDropdown.getData() != null) {
                    for (IGuiVar var : ((IGuiVarCompareExpression)this.compareDropdown.getData()).getInputs()) {
                        this.variables.add(var);
                    }
                }
            } else {
                this.onSetBlueprintVariable.accept(b);
            }
        }
    }
}

