/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables.displays;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.vanilla.GuiButtonVanilla;
import com.gildedgames.orbis.lib.client.gui.util.vanilla.GuiItemStackRender;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.core.variables.displays.GuiItemStackChooser;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiItemStackChooserScreen
extends GuiViewer {
    private static final ResourceLocation STACK_INVENTORY = OrbisLib.getResource("stack_inventory.png");
    private GuiItemStackChooser chooser;
    private GuiButtonVanilla back;
    private List<ItemStackButton> buttons = Lists.newArrayList();

    public GuiItemStackChooserScreen(GuiViewer viewer, GuiItemStackChooser chooser) {
        super(new GuiElement(Dim2D.flush(), false), viewer);
        this.chooser = chooser;
        this.setDrawDefaultBackground(true);
    }

    @Override
    public void build(IGuiContext context) {
        Pos2D center = InputHelper.getCenter();
        GuiTexture stack_inventory = new GuiTexture(Dim2D.build().center(true).pos(center).width(176.0f).height(86.0f).flush(), STACK_INVENTORY);
        context.addChildren((IGuiElement)stack_inventory);
        int validIndex = 0;
        for (int i = 0; i < this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.get(i);
            if (this.chooser.getVarItemStack().getStackValidator() != null && !this.chooser.getVarItemStack().getStackValidator().apply(stack).booleanValue()) continue;
            ItemStackButton button = new ItemStackButton(Pos2D.flush(7 + validIndex % 9 * 18, 7 + validIndex / 9 * 18), stack);
            stack_inventory.context().addChildren((IGuiElement)button);
            this.buttons.add(button);
            ++validIndex;
        }
        this.back = new GuiButtonVanilla(Dim2D.build().pos(center).center(true).addY(60.0f).width(80.0f).height(20.0f).flush());
        this.back.getInner().field_146126_j = I18n.func_135052_a((String)"orbis.gui.back", (Object[])new Object[0]);
        context.addChildren((IGuiElement)this.back);
        this.back.state().setCanBeTopHoverElement(true);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.back.state().isHoveredAndTopElement() && mouseButton == 0) {
            this.field_146297_k.func_147108_a(this.getPreviousViewer().getActualScreen());
        }
        for (ItemStackButton button : this.buttons) {
            if (!button.state().isHoveredAndTopElement() || mouseButton != 0) continue;
            this.chooser.setChosenStack(button.getStack());
            this.field_146297_k.func_147108_a(this.getPreviousViewer().getActualScreen());
        }
    }

    public class ItemStackButton
    extends GuiElement {
        private ItemStack stack;

        public ItemStackButton(Pos2D pos, ItemStack stack) {
            super(Dim2D.build().width(20.0f).height(20.0f).pos(pos).flush(), false);
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void build() {
            GuiButtonVanilla button = new GuiButtonVanilla(Dim2D.build().width(20.0f).height(20.0f).flush());
            GuiItemStackRender stackRender = new GuiItemStackRender(Dim2D.flush());
            stackRender.setItemStack(this.stack);
            stackRender.dim().mod().width(20.0f).height(20.0f).x(1.0f).y(0.0f).flush();
            this.context().addChildren(button, stackRender);
            this.state().setCanBeTopHoverElement(true);
        }
    }
}

