/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables.displays;

import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.vanilla.GuiButtonVanilla;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.IGuiVarDisplayContents;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiVarDisplay
extends GuiElement {
    private Collection<IGuiVar> variables;
    private IGuiVarDisplayContents contents;
    private String displayTitle;
    private Map<IGuiVar, GuiElement> varToDisplay = Maps.newHashMap();
    private GuiButtonVanilla apply;
    private GuiButtonVanilla reset;
    private int refreshRequests;

    public GuiVarDisplay(Rect rect) {
        super(rect, true);
    }

    public void reset() {
        this.context().clearChildren();
        this.variables = Collections.emptyList();
    }

    public void refresh() {
        ++this.refreshRequests;
    }

    public void display(IGuiVarDisplayContents contents) {
        this.display(contents, null);
    }

    public void display(IGuiVarDisplayContents contents, String displayTitle) {
        if (contents == null) {
            return;
        }
        if (this.contents != null) {
            this.contents.setParentDisplay(null);
        }
        contents.setParentDisplay(this);
        this.contents = contents;
        this.displayTitle = displayTitle;
        this.context().clearChildren();
        this.variables = new CopyOnWriteArrayList<IGuiVar>(contents.getVariables());
        for (IGuiVar var : this.variables) {
            var.setParentDisplay(this);
        }
        int currentY = 0;
        if (this.displayTitle != null) {
            GuiText title = new GuiText(Dim2D.build().y(currentY).x(this.dim().width() / 2.0f).centerX(true).flush(), new Text((ITextComponent)new TextComponentTranslation(this.displayTitle, new Object[0]), 1.0f));
            currentY += 15;
            this.context().addChildren((IGuiElement)title);
        }
        for (IGuiVar var : this.variables) {
            GuiText text = new GuiText(Dim2D.build().y(currentY).flush(), new Text((ITextComponent)new TextComponentTranslation(var.getVariableName(), new Object[0]), 1.0f));
            Object display = var.createDisplay((int)this.dim().width());
            ((GuiElement)display).dim().mod().y(currentY += 13).flush();
            currentY = (int)((float)currentY + (((GuiElement)display).dim().height() + 5.0f));
            this.varToDisplay.put(var, (GuiElement)display);
            this.context().addChildren(new IGuiElement[]{text, display});
        }
        this.apply = new GuiButtonVanilla(Dim2D.build().width(this.dim().width() / 2.0f - 2.0f).x(0.0f).y(currentY += 5).height(20.0f).flush());
        this.reset = new GuiButtonVanilla(Dim2D.build().width(this.dim().width() / 2.0f - 2.0f).x(this.dim().width() / 2.0f + 4.0f).y(currentY).height(20.0f).flush());
        this.apply.getInner().field_146126_j = "Apply";
        this.reset.getInner().field_146126_j = "Reset";
        currentY = (int)((float)currentY + this.apply.dim().height());
        this.dim().mod().height(currentY).flush();
        this.context().addChildren(this.apply, this.reset);
        this.apply.state().setCanBeTopHoverElement(true);
        this.reset.state().setCanBeTopHoverElement(true);
    }

    @Override
    public void onDraw(GuiElement element) {
        if (this.refreshRequests > 0) {
            this.display(this.contents, this.displayTitle);
            --this.refreshRequests;
        }
    }

    @Override
    public void onMouseClicked(GuiElement element, int mouseX, int mouseY, int mouseButton) {
        if (this.variables != null) {
            if (this.apply.state().isHoveredAndTopElement() && mouseButton == 0) {
                this.updateVariableData();
            }
            if (this.reset.state().isHoveredAndTopElement() && mouseButton == 0) {
                this.resetVariableData();
            }
        }
    }

    public void updateVariableData() {
        if (this.variables != null) {
            for (IGuiVar var : this.variables) {
                var.updateDataFromDisplay(this.varToDisplay.get(var));
            }
        }
    }

    public void resetVariableData() {
        if (this.variables != null) {
            for (IGuiVar var : this.variables) {
                var.resetDisplayFromData(this.varToDisplay.get(var));
            }
        }
    }
}

