/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables.post_resolve_actions;

import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.core.baking.BakedEntitySpawn;
import com.gildedgames.orbis.lib.core.baking.IBakedPosAction;
import com.gildedgames.orbis.lib.core.variables.GuiVarBoolean;
import com.gildedgames.orbis.lib.core.variables.GuiVarFloat;
import com.gildedgames.orbis.lib.core.variables.GuiVarItemStack;
import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.displays.GuiVarDisplay;
import com.gildedgames.orbis.lib.core.variables.post_resolve_actions.IPostResolveAction;
import com.gildedgames.orbis.lib.data.IDataUser;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.schedules.IPosActionBaker;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRegion;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class PostResolveActionSpawnEntities
implements IPostResolveAction,
IDataUser<ScheduleRegion>,
IPosActionBaker {
    private static final Function<ItemStack, Boolean> SPAWN_EGG_VALIDATOR = itemStack -> itemStack.func_77973_b() instanceof ItemMonsterPlacer;
    private List<IGuiVar> variables = Lists.newArrayList();
    private GuiVarItemStack itemStackVariable;
    private GuiVarBoolean customRotation;
    private GuiVarFloat rotationDegrees;
    private Pos2D guiPos = Pos2D.ORIGIN;
    private GuiVarDisplay parentDisplay;
    private ScheduleRegion scheduleRegion;

    public PostResolveActionSpawnEntities() {
        this.itemStackVariable = new GuiVarItemStack("orbis.gui.spawn_egg", SPAWN_EGG_VALIDATOR);
        this.customRotation = new GuiVarBoolean("orbis.gui.custom_rotation");
        this.rotationDegrees = new GuiVarFloat("orbis.gui.rotation_degrees");
        this.variables.add(this.itemStackVariable);
        this.variables.add(this.customRotation);
        this.variables.add(this.rotationDegrees);
    }

    @Override
    public String getName() {
        return "orbis.gui.spawn_entities";
    }

    @Override
    public List<IGuiVar> getVariables() {
        return this.variables;
    }

    @Override
    public void resolve(Random rand) {
    }

    @Override
    public Pos2D getGuiPos() {
        return this.guiPos;
    }

    @Override
    public void setGuiPos(Pos2D pos) {
        this.guiPos = pos;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("itemStackVariable", this.itemStackVariable);
        funnel.set("customRotation", this.customRotation);
        funnel.set("rotationDegrees", this.rotationDegrees);
        funnel.set("guiPos", this.guiPos, NBTFunnel.POS2D_SETTER);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.itemStackVariable = funnel.getWithDefault("itemStackVariable", () -> this.itemStackVariable);
        this.customRotation = funnel.getWithDefault("customRotation", () -> this.customRotation);
        this.rotationDegrees = funnel.getWithDefault("rotationDegrees", () -> this.rotationDegrees);
        this.guiPos = funnel.getWithDefault("guiPos", NBTFunnel.POS2D_GETTER, () -> this.guiPos);
        this.itemStackVariable.setStackValidator(SPAWN_EGG_VALIDATOR);
        this.variables.clear();
        this.variables.add(this.itemStackVariable);
        this.variables.add(this.customRotation);
        this.variables.add(this.rotationDegrees);
    }

    @Override
    public void setParentDisplay(GuiVarDisplay parentDisplay) {
        this.parentDisplay = parentDisplay;
    }

    @Override
    public String getDataIdentifier() {
        return "scheduleRegion";
    }

    @Override
    public void setUsedData(ScheduleRegion scheduleRegion) {
        this.scheduleRegion = scheduleRegion;
    }

    @Override
    public List<IBakedPosAction> bakeActions(IRegion bounds, Random rand, Rotation rotation) {
        ArrayList actions = Lists.newArrayList();
        float rotationOffset = (float)rotation.compareTo((Enum)Rotation.NONE) * 90.0f;
        if (this.itemStackVariable.getData().func_77973_b() instanceof ItemMonsterPlacer) {
            for (int i = 0; i < this.itemStackVariable.getData().func_190916_E(); ++i) {
                BlockPos pos = bounds.getMin();
                BakedEntitySpawn placedEntity = new BakedEntitySpawn(this.itemStackVariable.getData(), pos.func_177982_a(rand.nextInt(bounds.getWidth()), 0, rand.nextInt(bounds.getLength())), this.customRotation.getData(), this.rotationDegrees.getData().floatValue() + rotationOffset);
                actions.add(placedEntity);
            }
        }
        return actions;
    }
}

