/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables.var_comparators;

import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberCompareBase;
import com.gildedgames.orbis.lib.util.MathUtil;

public class NumberEquals<NUMBER extends Number>
extends NumberCompareBase<NUMBER> {
    protected NumberEquals() {
    }

    public NumberEquals(IGuiVar<NUMBER, ?> valueVar) {
        super(valueVar);
    }

    @Override
    public boolean compare(Object obj) {
        Object input;
        if (obj instanceof Number) {
            input = (Number)obj;
            if (input instanceof Double && this.value.getData() instanceof Double) {
                return MathUtil.epsilonEquals(((Number)input).doubleValue(), ((Number)this.value.getData()).doubleValue());
            }
            if (input instanceof Float && this.value.getData() instanceof Float) {
                return MathUtil.epsilonEquals(((Number)input).floatValue(), ((Number)this.value.getData()).floatValue());
            }
        }
        if (obj instanceof Comparable) {
            input = (Comparable)obj;
            return input.compareTo(this.value.getData()) == 0;
        }
        return false;
    }

    @Override
    public String getDisplayString() {
        return "orbis.gui.equals";
    }
}

