/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.variables.var_comparators;

import com.gildedgames.orbis.lib.core.variables.IGuiVar;
import com.gildedgames.orbis.lib.core.variables.var_comparators.NumberCompareBase;
import com.gildedgames.orbis.lib.util.MathUtil;

public class NumberLessThanOrEqual<NUMBER extends Number>
extends NumberCompareBase<NUMBER> {
    private NumberLessThanOrEqual() {
    }

    public NumberLessThanOrEqual(IGuiVar<NUMBER, ?> valueVar) {
        super(valueVar);
    }

    @Override
    public boolean compare(Object obj) {
        Object input;
        if (obj instanceof Number) {
            input = (Number)obj;
            if (input instanceof Double && this.value.getData() instanceof Double && MathUtil.epsilonEquals(((Number)input).doubleValue(), ((Number)this.value.getData()).doubleValue())) {
                return true;
            }
            if (input instanceof Float && this.value.getData() instanceof Float && MathUtil.epsilonEquals(((Number)input).floatValue(), ((Number)this.value.getData()).floatValue())) {
                return true;
            }
        }
        if (obj instanceof Comparable) {
            input = (Comparable)obj;
            return input.compareTo(this.value.getData()) <= -1 || input.compareTo(this.value.getData()) == 0;
        }
        return false;
    }

    @Override
    public String getDisplayString() {
        return "orbis.gui.less_than_or_equal";
    }
}

