/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.core.world_objects;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.region.AbstractRegion;
import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IRotateable;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.RotationHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlueprintRegion
extends AbstractRegion
implements IMutableRegion,
IRotateable {
    protected Rotation rotation = Rotation.NONE;
    protected BlueprintData data;
    protected BlockPos min = BlockPos.field_177992_a;
    protected BlockPos max = BlockPos.field_177992_a;

    protected BlueprintRegion() {
    }

    protected BlueprintRegion(World world) {
    }

    public BlueprintRegion(IRegion region) {
        this.data = new BlueprintData(region);
        this.setBounds(region);
    }

    public BlueprintRegion(BlockPos pos, BlueprintData data) {
        this.data = data;
        this.setPos(pos);
    }

    public BlueprintRegion(BlockPos pos, Rotation rotation, BlueprintData data) {
        this.data = data;
        this.rotation = rotation;
        this.setPos(pos);
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }

    public IBlockState getBlock(BlockPos pos) {
        BlockPos transformed = this.transformForBlueprint(pos);
        return this.getBlockDataContainer().getBlockState(transformed);
    }

    public BlockPos transformForBlueprint(BlockPos pos) {
        Rotation transformRot = this.rotation == Rotation.CLOCKWISE_90 ? Rotation.COUNTERCLOCKWISE_90 : (this.rotation == Rotation.COUNTERCLOCKWISE_90 ? Rotation.CLOCKWISE_90 : this.rotation);
        BlockPos rotated = RotationHelp.rotate(pos, (IRegion)this, transformRot);
        IRegion rotatedRegion = RotationHelp.rotate(this, transformRot);
        return new BlockPos(rotated.func_177958_n() - rotatedRegion.getMin().func_177958_n(), rotated.func_177956_o() - rotatedRegion.getMin().func_177956_o(), rotated.func_177952_p() - rotatedRegion.getMin().func_177952_p());
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getLength() {
        return this.data.getLength();
    }

    public BlockPos getPos() {
        return this.min;
    }

    public void setPos(BlockPos pos) {
        this.min = pos;
        int width = this.rotation == Rotation.NONE || this.rotation == Rotation.CLOCKWISE_180 ? this.getWidth() : this.getLength();
        int length = this.rotation == Rotation.NONE || this.rotation == Rotation.CLOCKWISE_180 ? this.getLength() : this.getWidth();
        this.max = RegionHelp.getMax(this.min, width, this.getHeight(), length);
        this.notifyDataChange();
    }

    @Override
    public BlockPos getMin() {
        return this.min;
    }

    @Override
    public BlockPos getMax() {
        return this.max;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setPos("min", this.min);
        tag.func_74778_a("rotation", this.rotation.name());
        funnel.set("state", this.data);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.min = funnel.getPos("min");
        this.rotation = Rotation.valueOf((String)tag.func_74779_i("rotation"));
        this.data = (BlueprintData)funnel.get("state");
        this.max = RegionHelp.getMax(this.min, this.getWidth(), this.getHeight(), this.getLength());
        this.notifyDataChange();
    }

    @Override
    public void setBounds(IRegion region) {
        this.min = region.getMin();
        this.max = region.getMax();
        this.notifyDataChange();
    }

    @Override
    public void setBounds(BlockPos corner1, BlockPos corner2) {
        this.min = RegionHelp.getMin(corner1, corner2);
        this.max = RegionHelp.getMax(corner1, corner2);
        this.notifyDataChange();
    }

    public BlockDataContainer getBlockDataContainer() {
        return this.data.getBlockDataContainer();
    }

    public BlueprintData getData() {
        return this.data;
    }

    @Override
    public Iterator<BlockPos.MutableBlockPos> iterator() {
        return BlockPos.func_177975_b((BlockPos)this.min, (BlockPos)this.max).iterator();
    }
}

