/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.blueprint;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.core.tree.INode;
import com.gildedgames.orbis.lib.core.tree.INodeTreeListener;
import com.gildedgames.orbis.lib.core.tree.LayerLink;
import com.gildedgames.orbis.lib.core.tree.NodeMultiParented;
import com.gildedgames.orbis.lib.core.tree.NodeTree;
import com.gildedgames.orbis.lib.data.IDataHolder;
import com.gildedgames.orbis.lib.data.IDataUser;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintMetadata;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintVariable;
import com.gildedgames.orbis.lib.data.blueprint.IBlueprintDataListener;
import com.gildedgames.orbis.lib.data.blueprint.IBlueprintMetadata;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.data.pathway.IEntrance;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.schedules.IPositionRecordListener;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayer;
import com.gildedgames.orbis.lib.data.schedules.PostGenReplaceLayer;
import com.gildedgames.orbis.lib.data.schedules.ScheduleLayer;
import com.gildedgames.orbis.lib.util.BlueprintHelper;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.IWorldObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlueprintData
implements IDimensions,
IData,
IPositionRecordListener<IBlockState>,
IDataHolder<BlueprintData>,
INodeTreeListener<IScheduleLayer, LayerLink> {
    public static final String EXTENSION = "blueprint";
    private final List<IBlueprintDataListener> listeners = Lists.newArrayList();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private IDataMetadata metadata;
    private BlockDataContainer dataContainer;
    private NodeTree<IScheduleLayer, LayerLink> scheduleLayerTree = new NodeTree();
    private NodeTree<BlueprintVariable, NBT> variableTree = new NodeTree();
    private LinkedHashMap<Integer, PostGenReplaceLayer> postGenReplaceLayers = Maps.newLinkedHashMap();
    private IEntrance entrance;
    private Pos2D scheduleTreeGuiPos;
    private Pos2D variableTreeGuiPos = Pos2D.ORIGIN;
    private IBlueprintMetadata blueprintMetadata = new BlueprintMetadata();

    private BlueprintData() {
        this.metadata = new DataMetadata();
        this.getScheduleLayerTree().listen(this);
        this.getVariableTree().listen(new INodeTreeListener<BlueprintVariable, NBT>(){

            @Override
            public void onSetData(INode<BlueprintVariable, NBT> node, BlueprintVariable variable, int id) {
                node.getData().setDataParent(BlueprintData.this);
            }

            @Override
            public void onPut(INode<BlueprintVariable, NBT> node, int id) {
                node.getData().setDataParent(BlueprintData.this);
            }

            @Override
            public void onRemove(INode<BlueprintVariable, NBT> node, int id) {
                node.getData().setDataParent(null);
            }
        });
    }

    public BlueprintData(IRegion region) {
        this();
        this.dataContainer = new BlockDataContainer(region);
        this.getScheduleLayerTree().add(new NodeMultiParented(new ScheduleLayer("Root Layer", this), false));
    }

    public BlueprintData(BlockDataContainer container) {
        this();
        this.dataContainer = container;
        this.getScheduleLayerTree().add(new NodeMultiParented(new ScheduleLayer("Root Layer", this), false));
    }

    public IBlueprintMetadata getBlueprintMetadata() {
        return this.blueprintMetadata;
    }

    public Pos2D getScheduleTreeGuiPos() {
        return this.scheduleTreeGuiPos;
    }

    public void setScheduleTreeGuiPos(Pos2D treeGuiPos) {
        this.scheduleTreeGuiPos = treeGuiPos;
        this.markDirty();
    }

    public Pos2D getVariableTreeGuiPos() {
        return this.variableTreeGuiPos;
    }

    public void setVariableTreeGuiPos(Pos2D treeGuiPos) {
        this.variableTreeGuiPos = treeGuiPos;
        this.markDirty();
    }

    public void listen(IBlueprintDataListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void setEntrance(IEntrance entrance) {
        Lock w = this.lock.writeLock();
        w.lock();
        try {
            this.clearEntrance();
            entrance.setDataParent(this);
            this.entrance = entrance;
            this.listeners.forEach(o -> o.onAddEntrance(entrance));
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntrance() {
        Lock w = this.lock.writeLock();
        w.lock();
        try {
            boolean avail;
            boolean bl = avail = this.entrance != null;
            if (avail) {
                this.listeners.forEach(o -> o.onRemoveEntrance(this.entrance));
                this.entrance = null;
            }
            boolean bl2 = avail;
            return bl2;
        }
        finally {
            w.unlock();
        }
    }

    public IEntrance getEntrance() {
        return this.entrance;
    }

    public BlockDataContainer getBlockDataContainer() {
        return this.dataContainer;
    }

    public NodeTree<IScheduleLayer, LayerLink> getScheduleLayerTree() {
        return this.scheduleLayerTree;
    }

    public NodeTree<BlueprintVariable, NBT> getVariableTree() {
        return this.variableTree;
    }

    @Override
    public int getWidth() {
        return this.dataContainer.getWidth();
    }

    @Override
    public int getHeight() {
        return this.dataContainer.getHeight();
    }

    @Override
    public int getLength() {
        return this.dataContainer.getLength();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.metadata.getIdentifier());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlueprintData) {
            BlueprintData o = (BlueprintData)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.metadata.getIdentifier(), (Object)o.metadata.getIdentifier());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("dataContainer", this.dataContainer);
        funnel.set("scheduleLayerTree", this.scheduleLayerTree);
        funnel.set("variableTree", this.variableTree);
        funnel.setIntMap("postGenReplaceLayers", this.postGenReplaceLayers);
        funnel.set("entrance", this.entrance);
        funnel.set("scheduleTreeGuiPos", this.scheduleTreeGuiPos, NBTFunnel.POS2D_SETTER);
        funnel.set("variableTreeGuiPos", this.variableTreeGuiPos, NBTFunnel.POS2D_SETTER);
        funnel.set("blueprintMetadata", this.blueprintMetadata);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.dataContainer = (BlockDataContainer)funnel.get("dataContainer");
        this.scheduleLayerTree = funnel.getWithDefault("scheduleLayerTree", () -> this.scheduleLayerTree);
        this.variableTree = funnel.getWithDefault("variableTree", () -> this.variableTree);
        this.postGenReplaceLayers = Maps.newLinkedHashMap(funnel.getIntMap("postGenReplaceLayers"));
        this.scheduleLayerTree.listen(this);
        this.scheduleLayerTree.getNodes().forEach(l -> ((IScheduleLayer)l.getData()).setDimensions(this));
        this.scheduleLayerTree.getNodes().forEach(l -> ((IScheduleLayer)l.getData()).getStateRecord().listen(this));
        this.scheduleLayerTree.getNodes().forEach(l -> ((IScheduleLayer)l.getData()).setNodeParent((INode<IScheduleLayer, LayerLink>)l));
        this.entrance = (IEntrance)funnel.get("entrance");
        this.scheduleTreeGuiPos = funnel.get("scheduleTreeGuiPos", NBTFunnel.POS2D_GETTER);
        this.variableTreeGuiPos = funnel.getWithDefault("variableTreeGuiPos", NBTFunnel.POS2D_GETTER, () -> this.variableTreeGuiPos);
        this.scheduleLayerTree.getNodes().forEach(s -> {
            ((IScheduleLayer)s.getData()).getConditionNodeTree().getNodes().stream().filter(n -> n.getData() instanceof IDataUser).forEach(n -> {
                IDataUser user = (IDataUser)n.getData();
                if (user.getDataIdentifier().equals("blueprintVariables")) {
                    user.setUsedData(this.getVariableTree());
                }
            });
            ((IScheduleLayer)s.getData()).getPostResolveActionNodeTree().getNodes().stream().filter(n -> n.getData() instanceof IDataUser).forEach(n -> {
                IDataUser user = (IDataUser)n.getData();
                if (user.getDataIdentifier().equals("blueprintVariables")) {
                    user.setUsedData(this.getVariableTree());
                }
            });
        });
        if (this.entrance != null) {
            this.entrance.setDataParent(this);
        }
        this.postGenReplaceLayers.values().forEach(l -> l.setDataParent(this));
        this.scheduleLayerTree.setDataParent(this);
        this.variableTree.setDataParent(this);
        this.blueprintMetadata = funnel.getWithDefault("blueprintMetadata", () -> this.blueprintMetadata);
    }

    @Override
    public void preSaveToDisk(IWorldObject object) {
        if (object instanceof IShape) {
            IShape shape = (IShape)((Object)object);
            this.dataContainer = BlueprintHelper.fetchBlocksInside(shape, object.getWorld());
        }
    }

    @Override
    public String getFileExtension() {
        return EXTENSION;
    }

    @Override
    public IDataMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(IDataMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public IData clone() {
        BlueprintData data = new BlueprintData();
        NBTTagCompound tag = new NBTTagCompound();
        this.write(tag);
        data.read(tag);
        return data;
    }

    @Override
    public void onMarkPos(IBlockState state, int x, int y, int z) {
        this.listeners.forEach(IBlueprintDataListener::onDataChanged);
    }

    @Override
    public void onUnmarkPos(int x, int y, int z) {
        this.listeners.forEach(IBlueprintDataListener::onDataChanged);
    }

    public void markDirty() {
        this.listeners.forEach(IBlueprintDataListener::onDataChanged);
    }

    @Override
    public BlueprintData get(World world, Random random) {
        return this;
    }

    @Override
    public int getLargestHeight() {
        return this.getHeight();
    }

    @Override
    public int getLargestWidth() {
        return this.getWidth();
    }

    @Override
    public int getLargestLength() {
        return this.getLength();
    }

    public LinkedHashMap<Integer, PostGenReplaceLayer> getPostGenReplaceLayers() {
        return this.postGenReplaceLayers;
    }

    public void setPostGenReplaceLayer(int index, PostGenReplaceLayer layer) {
        layer.setLayerId(index);
        layer.setDataParent(this);
        this.postGenReplaceLayers.put(index, layer);
    }

    public int findNextAvailablePostGenId() {
        int i = 0;
        while (this.postGenReplaceLayers.containsKey(i)) {
            ++i;
        }
        return i;
    }

    public int addPostGenReplaceLayer(PostGenReplaceLayer layer) {
        int id = this.findNextAvailablePostGenId();
        this.setPostGenReplaceLayer(id, layer);
        return id;
    }

    public boolean removePostGenReplaceLayer(int index) {
        boolean removed = this.postGenReplaceLayers.get(index) != null;
        PostGenReplaceLayer layer = (PostGenReplaceLayer)this.postGenReplaceLayers.remove(index);
        return removed;
    }

    public PostGenReplaceLayer getPostGenReplaceLayer(int id) {
        return this.postGenReplaceLayers.get(id);
    }

    public int getPostGenReplaceLayerId(PostGenReplaceLayer layer) {
        for (Map.Entry<Integer, PostGenReplaceLayer> entry : this.postGenReplaceLayers.entrySet()) {
            int i = entry.getKey();
            PostGenReplaceLayer s = entry.getValue();
            if (!layer.equals(s)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void onSetData(INode<IScheduleLayer, LayerLink> node, IScheduleLayer iScheduleLayer, int id) {
        IScheduleLayer layer = node.getData();
        layer.setDataParent(this);
        layer.setNodeParent(node);
    }

    @Override
    public void onPut(INode<IScheduleLayer, LayerLink> node, int id) {
        IScheduleLayer layer = node.getData();
        layer.setDataParent(this);
        layer.setNodeParent(node);
    }

    @Override
    public void onRemove(INode<IScheduleLayer, LayerLink> node, int id) {
        node.getData().setNodeParent(null);
    }
}

