/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.blueprint;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.data.DataCondition;
import com.gildedgames.orbis.lib.data.IDataHolder;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlueprintDataPalette
implements NBT,
IDataHolder<BlueprintData> {
    private final Map<IDataIdentifier, BlueprintData> data = Maps.newHashMap();
    private LinkedHashMap<IDataIdentifier, DataCondition> idToConditions = Maps.newLinkedHashMap();
    private IDimensions largestDim;
    private int minEntrances;
    private int maxEntrances;

    public Collection<IDataIdentifier> getIDs() {
        return this.idToConditions.keySet();
    }

    public Map<IDataIdentifier, DataCondition> getIDToConditions() {
        return this.idToConditions;
    }

    public BlueprintData fetchRandom(World world, Random rand) {
        float randomValue = rand.nextFloat() * this.totalChance();
        float chanceSum = 0.0f;
        for (Map.Entry<IDataIdentifier, DataCondition> pair : this.idToConditions.entrySet()) {
            DataCondition condition = pair.getValue();
            if (condition.isMet(randomValue, chanceSum, rand, world)) {
                return this.data.get(pair.getKey());
            }
            chanceSum += condition.getWeight();
        }
        return null;
    }

    public float totalChance() {
        float total = 0.0f;
        for (Map.Entry<IDataIdentifier, DataCondition> pair : this.idToConditions.entrySet()) {
            DataCondition condition = pair.getValue();
            total += condition.getWeight();
        }
        return total;
    }

    public Collection<BlueprintData> getData() {
        return this.data.values();
    }

    public IDimensions getLargestDim() {
        return this.largestDim;
    }

    public int getMinimumEntrances() {
        return this.minEntrances;
    }

    public int getMaximumEntrances() {
        return this.maxEntrances;
    }

    private void evaluateEntrances() {
    }

    private void evaluateLargestInArea() {
        int width = Integer.MIN_VALUE;
        int height = Integer.MIN_VALUE;
        int length = Integer.MIN_VALUE;
        for (BlueprintData blueprint : this.data.values()) {
            width = Math.max(width, blueprint.getWidth());
            height = Math.max(height, blueprint.getHeight());
            length = Math.max(length, blueprint.getLength());
        }
        this.largestDim = new Region(BlockPos.field_177992_a, new BlockPos(width - 1, height - 1, length - 1));
    }

    public void add(BlueprintData data, DataCondition condition) {
        this.idToConditions.put(data.getMetadata().getIdentifier(), condition);
        this.data.put(data.getMetadata().getIdentifier(), data);
        this.evaluateLargestInArea();
        this.evaluateEntrances();
    }

    public void remove(BlueprintData data) {
        IDataIdentifier toRemove = null;
        for (Map.Entry<IDataIdentifier, DataCondition> pair : this.idToConditions.entrySet()) {
            if (!pair.getKey().equals(data.getMetadata().getIdentifier())) continue;
            toRemove = pair.getKey();
            break;
        }
        if (toRemove == null) {
            return;
        }
        this.data.remove(toRemove);
        this.idToConditions.remove(toRemove);
        this.evaluateLargestInArea();
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setMap("idToConditions", this.idToConditions);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.idToConditions = Maps.newLinkedHashMap(funnel.getMap("idToConditions"));
        for (Map.Entry<IDataIdentifier, DataCondition> pair : this.idToConditions.entrySet()) {
            IDataIdentifier id = pair.getKey();
            Optional data = OrbisLib.services().getProjectManager().findData(id);
            if (data.isPresent()) {
                this.data.put(id, (BlueprintData)data.get());
                continue;
            }
            OrbisLib.LOGGER.error("Missing in " + this.getClass().getName() + " : ", (Object)id);
        }
        this.evaluateLargestInArea();
        this.evaluateEntrances();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.idToConditions);
        return builder.toHashCode();
    }

    @Override
    public BlueprintData get(World world, Random random) {
        return this.fetchRandom(world, random);
    }

    @Override
    public int getLargestHeight() {
        return this.largestDim.getHeight();
    }

    @Override
    public int getLargestWidth() {
        return this.largestDim.getWidth();
    }

    @Override
    public int getLargestLength() {
        return this.largestDim.getLength();
    }
}

