/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.blueprint;

import com.gildedgames.orbis.lib.data.blueprint.IBlueprintNetworkDataListener;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.world.IWorldObject;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlueprintNetworkData
implements IData {
    public static final String EXTENSION = "blueprintnetwork";
    private final List<IBlueprintNetworkDataListener> listeners = Lists.newArrayList();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private IDataMetadata metadata = new DataMetadata();
    private List<IDataIdentifier> rooms;
    private List<IDataIdentifier> paths;
    private List<IDataIdentifier> start;
    private List<IDataIdentifier> finish;
    private int depth;

    private BlueprintNetworkData() {
    }

    public BlueprintNetworkData(int depth, List<IDataIdentifier> rooms, List<IDataIdentifier> paths, List<IDataIdentifier> start, List<IDataIdentifier> finish) {
        this();
        this.depth = depth;
        this.rooms = rooms;
        this.paths = paths;
        this.start = start;
        this.finish = finish;
    }

    public int getTargetDepth() {
        return this.depth;
    }

    public List<IDataIdentifier> getRooms() {
        return this.rooms;
    }

    public void listen(IBlueprintNetworkDataListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.metadata.getIdentifier());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlueprintNetworkData) {
            BlueprintNetworkData o = (BlueprintNetworkData)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.metadata.getIdentifier(), (Object)o.metadata.getIdentifier());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setList("rooms", this.rooms);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.rooms = funnel.getList("rooms");
    }

    @Override
    public void preSaveToDisk(IWorldObject object) {
    }

    @Override
    public String getFileExtension() {
        return EXTENSION;
    }

    @Override
    public IDataMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(IDataMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public IData clone() {
        BlueprintNetworkData data = new BlueprintNetworkData();
        NBTTagCompound tag = new NBTTagCompound();
        this.write(tag);
        data.read(tag);
        return data;
    }

    public void markDirty() {
        this.listeners.forEach(IBlueprintNetworkDataListener::onDataChanged);
    }
}

