/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.blueprint;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.core.tree.INode;
import com.gildedgames.orbis.lib.core.tree.LayerLink;
import com.gildedgames.orbis.lib.data.IDataHolder;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayer;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.BlockUtil;
import com.gildedgames.orbis.lib.world.IWorldObject;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BlueprintStackerData
implements IData,
IDataHolder<BlockDataContainer> {
    public static final String EXTENSION = "blueprintstacker";
    private IDataHolder<BlueprintData> top;
    private IDataHolder<BlueprintData> bottom;
    private IDataHolder<BlueprintData>[] segments;
    private IDataMetadata metadata = new DataMetadata();
    private IDimensions largestDim;

    private BlueprintStackerData() {
    }

    public BlueprintStackerData(IDataHolder<BlueprintData> top, IDataHolder<BlueprintData> bottom, IDataHolder<BlueprintData>[] segments) {
        this();
        this.top = top;
        this.bottom = bottom;
        this.segments = segments;
        this.evaluateLargestDim();
    }

    public IDataHolder<BlueprintData> getBottom() {
        return this.bottom;
    }

    public IDataHolder<BlueprintData> getTop() {
        return this.top;
    }

    public IDataHolder<BlueprintData>[] getSegments() {
        return this.segments;
    }

    private void evaluateLargestDim() {
        int width = Integer.MIN_VALUE;
        int height = 0;
        int length = Integer.MIN_VALUE;
        height += this.top.getLargestHeight();
        height += this.bottom.getLargestHeight();
        for (IDataHolder<BlueprintData> holder : this.segments) {
            width = Math.max(width, holder.getLargestWidth());
            length = Math.max(length, holder.getLargestLength());
        }
        width = Math.max(width, this.top.getLargestWidth());
        length = Math.max(length, this.top.getLargestLength());
        width = Math.max(width, this.bottom.getLargestWidth());
        length = Math.max(length, this.bottom.getLargestLength());
        this.largestDim = new Region(BlockPos.field_177992_a, new BlockPos(width - 1, height - 1, length - 1));
    }

    @Override
    public void preSaveToDisk(IWorldObject object) {
    }

    @Override
    public IData clone() {
        return new BlueprintStackerData(this.top, this.bottom, this.segments);
    }

    @Override
    public String getFileExtension() {
        return EXTENSION;
    }

    @Override
    public IDataMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(IDataMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("top", this.top);
        funnel.set("bottom", this.bottom);
        funnel.setArray("segments", this.segments);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.top = (IDataHolder)funnel.get("top");
        this.bottom = (IDataHolder)funnel.get("bottom");
        this.segments = (IDataHolder[])funnel.getArray("segments", IDataHolder.class);
        this.evaluateLargestDim();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.metadata.getIdentifier());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlueprintStackerData) {
            BlueprintStackerData o = (BlueprintStackerData)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.metadata.getIdentifier(), (Object)o.metadata.getIdentifier());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public BlockDataContainer get(World world, Random random) {
        return this.get(world, random, random.nextInt(this.segments.length + 1));
    }

    /*
     * WARNING - void declaration
     */
    public BlockDataContainer get(World world, Random random, int segmentIndexHeight) {
        void var11_16;
        BlueprintData chosenTop = this.top.get(world, random);
        BlueprintData chosenBottom = this.bottom.get(world, random);
        int height = 0;
        height += chosenTop.getHeight();
        height += chosenBottom.getHeight();
        BlueprintData[] chosenSegments = new BlueprintData[segmentIndexHeight];
        int j = 0;
        for (int i = this.segments.length - 1; i >= this.segments.length - segmentIndexHeight; --i) {
            IDataHolder<BlueprintData> holder = this.segments[i];
            BlueprintData blueprintData = holder.get(world, random);
            height += blueprintData.getHeight();
            chosenSegments[j++] = blueprintData;
        }
        BlockDataContainer chosenBottomBlocks = chosenBottom.getBlockDataContainer().clone();
        for (INode iNode : chosenBottom.getScheduleLayerTree().getNodes()) {
            BlueprintData[] layer = (BlueprintData[])iNode.getData();
            if (layer.getStateRecord().getData().length == 0) continue;
            for (BlockPos.MutableBlockPos pos : layer.getStateRecord().getRegion()) {
                IBlockState layerState = layer.getStateRecord().get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                for (IBlockState predicate : layer.getStateRecord().getData()) {
                    if (predicate != layerState || !layer.getOptions().getReplacesSolidBlocksVar().getData().booleanValue() && BlockUtil.isSolid(chosenBottomBlocks.getBlockState((BlockPos)pos))) continue;
                    chosenBottomBlocks.setBlockState(predicate, (BlockPos)pos);
                }
            }
        }
        BlockDataContainer result = new BlockDataContainer(this.getLargestWidth(), height, this.getLargestLength());
        this.funnelInto(result, chosenBottomBlocks, (this.getLargestWidth() - chosenBottom.getWidth()) / 2, 0, (this.getLargestLength() - chosenBottom.getLength()) / 2);
        int n = chosenBottom.getHeight();
        for (BlueprintData segment : chosenSegments) {
            BlockDataContainer blocks = segment.getBlockDataContainer().clone();
            for (INode<IScheduleLayer, LayerLink> node : segment.getScheduleLayerTree().getNodes()) {
                IScheduleLayer layer = node.getData();
                if (layer.getStateRecord().getData().length == 0) continue;
                for (BlockPos.MutableBlockPos pos : layer.getStateRecord().getRegion()) {
                    IBlockState layerState = layer.getStateRecord().get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    for (IBlockState predicate : layer.getStateRecord().getData()) {
                        if (predicate != layerState || !layer.getOptions().getReplacesSolidBlocksVar().getData().booleanValue() && BlockUtil.isSolid(blocks.getBlockState((BlockPos)pos))) continue;
                        blocks.setBlockState(predicate, (BlockPos)pos);
                    }
                }
            }
            this.funnelInto(result, blocks, (this.getLargestWidth() - segment.getWidth()) / 2, (int)var11_16, (this.getLargestLength() - segment.getLength()) / 2);
            var11_16 += segment.getHeight();
        }
        BlockDataContainer chosenTopBlocks = chosenTop.getBlockDataContainer().clone();
        for (INode<IScheduleLayer, LayerLink> node : chosenTop.getScheduleLayerTree().getNodes()) {
            IScheduleLayer layer = node.getData();
            if (layer.getStateRecord().getData().length == 0) continue;
            for (BlockPos.MutableBlockPos pos : layer.getStateRecord().getRegion()) {
                IBlockState layerState = layer.getStateRecord().get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                for (IBlockState predicate : layer.getStateRecord().getData()) {
                    if (predicate != layerState || !layer.getOptions().getReplacesSolidBlocksVar().getData().booleanValue() && BlockUtil.isSolid(chosenTopBlocks.getBlockState((BlockPos)pos))) continue;
                    chosenTopBlocks.setBlockState(predicate, (BlockPos)pos);
                }
            }
        }
        this.funnelInto(result, chosenTopBlocks, (this.getLargestWidth() - chosenTop.getWidth()) / 2, (int)var11_16, (this.getLargestLength() - chosenTop.getLength()) / 2);
        return result;
    }

    private void funnelInto(BlockDataContainer into, BlockDataContainer from, int xOffset, int yOffset, int zOffset) {
        for (int x = 0; x < from.getWidth(); ++x) {
            for (int y = 0; y < from.getHeight(); ++y) {
                for (int z = 0; z < from.getLength(); ++z) {
                    IBlockState block = from.getBlockState(x, y, z);
                    into.setBlockState(block, x + xOffset, y + yOffset, z + zOffset);
                }
            }
        }
    }

    @Override
    public int getLargestHeight() {
        return this.largestDim.getHeight();
    }

    @Override
    public int getLargestWidth() {
        return this.largestDim.getWidth();
    }

    @Override
    public int getLargestLength() {
        return this.largestDim.getLength();
    }
}

