/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.core.world_objects.BlueprintRegion;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.framework.FrameworkData;
import com.gildedgames.orbis.lib.data.framework.FrameworkEdge;
import com.gildedgames.orbis.lib.data.framework.FrameworkNode;
import com.gildedgames.orbis.lib.data.framework.FrameworkType;
import com.gildedgames.orbis.lib.data.framework.GeneratedFramework;
import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDEdge;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDNode;
import com.gildedgames.orbis.lib.data.framework.generation.FDGenUtil;
import com.gildedgames.orbis.lib.data.framework.generation.FailedToGenerateException;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.FruchtermanReingold;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.IGDAlgorithm;
import com.gildedgames.orbis.lib.data.framework.generation.searching.PathwayNode;
import com.gildedgames.orbis.lib.data.framework.generation.searching.PathwayProblem;
import com.gildedgames.orbis.lib.data.framework.generation.searching.StepAStar;
import com.gildedgames.orbis.lib.data.framework_new.IFramework;
import com.gildedgames.orbis.lib.data.framework_new.IFrameworkAlgorithm;
import com.gildedgames.orbis.lib.data.pathway.PathwayData;
import com.gildedgames.orbis.lib.data.region.Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FrameworkAlgorithm
implements IFrameworkAlgorithm {
    private static final float spiderwebGrowth = 0.5f;
    private static final float graphDestroy = 0.3f;
    private static final float addEdgeDistanceRatio = 0.4f;
    public static float heuristicWeight = 1.2f;
    private final FrameworkData framework;
    public Map<FrameworkNode, FDGDNode> _nodeMap;
    private Graph<FDGDNode, FDGDEdge> fdgdGraph;
    private IFrameworkAlgorithm.Phase phase = IFrameworkAlgorithm.Phase.CSP;
    private boolean escapePhase;
    private int fdgdIterations = 0;
    private World world;
    private StepAStar<PathwayNode> pathfindingSolver;
    private Iterator<FDGDEdge> edgeIterator;
    private Random random;
    private IGDAlgorithm gdAlgorithm = new FruchtermanReingold();
    private List<BlueprintRegion> fragments;

    public FrameworkAlgorithm(FrameworkData data, World world) {
        this.framework = data;
        this.world = world;
        this.random = world == null ? new Random() : world.field_73012_v;
    }

    public GeneratedFramework computeFully() throws FailedToGenerateException {
        while (!this.step()) {
        }
        return this.getResult();
    }

    public GeneratedFramework getResult() {
        return null;
    }

    @Override
    public boolean step() throws FailedToGenerateException {
        if (this.phase == IFrameworkAlgorithm.Phase.CSP) {
            this.initialGraph();
            this.phase = IFrameworkAlgorithm.Phase.FDGD;
            this.gdAlgorithm.initialize(this.fdgdGraph, this.framework.getType(), this.random);
            return false;
        }
        if (this.phase == IFrameworkAlgorithm.Phase.FDGD) {
            this.gdAlgorithm.step(this.fdgdGraph, this.framework.getType(), this.random, this.fdgdIterations);
            ++this.fdgdIterations;
            this.phase = this.gdAlgorithm.inEquilibrium(this.fdgdGraph, this.framework.getType(), this.fdgdIterations);
            if (this.phase == IFrameworkAlgorithm.Phase.PATHWAYS && !FDGenUtil.hasCollision(this.fdgdGraph)) {
                if (this.framework.getType() == FrameworkType.CUBES || !FDGenUtil.hasEdgeIntersections(this.fdgdGraph)) {
                    for (FDGDNode node : this.fdgdGraph.vertexSet()) {
                        node.assignConnectionsFixRot(this.fdgdGraph.edgesOf(node));
                    }
                    this.phase = IFrameworkAlgorithm.Phase.PATHWAYS;
                    this.fragments = new ArrayList<BlueprintRegion>(this.fdgdGraph.vertexSet().size());
                    this.fragments.addAll(this.fdgdGraph.vertexSet().stream().map(FDGDNode::getRegionForBlueprint).collect(Collectors.toList()));
                    this.edgeIterator = this.fdgdGraph.edgeSet().iterator();
                    FDGDEdge edge = this.edgeIterator.next();
                    PathwayProblem problem = new PathwayProblem(this.world, edge.entrance1(), edge.node1(), edge.entrance2(), edge.pathway().pieces(), this.fragments);
                    this.pathfindingSolver = new StepAStar<PathwayNode>(problem, heuristicWeight);
                    this.pathfindingSolver.step();
                    return true;
                }
                this.phase = IFrameworkAlgorithm.Phase.REBUILD1;
            }
            return false;
        }
        if (this.phase == IFrameworkAlgorithm.Phase.REBUILD1) {
            this.assignConnections();
            this.phase = IFrameworkAlgorithm.Phase.REBUILD2;
            return false;
        }
        if (this.phase == IFrameworkAlgorithm.Phase.REBUILD2) {
            this.doSpiderWeb();
            this.gdAlgorithm.resetOnSpiderweb(this.fdgdGraph, this.framework.getType(), this.fdgdIterations);
            this.phase = IFrameworkAlgorithm.Phase.REBUILD3;
            return false;
        }
        if (this.phase == IFrameworkAlgorithm.Phase.REBUILD3) {
            this.assignConnections();
            this.phase = IFrameworkAlgorithm.Phase.FDGD;
            return false;
        }
        if (this.pathfindingSolver.isTerminated()) {
            if (this.edgeIterator.hasNext()) {
                if (this.pathfindingSolver.currentState() != null) {
                    for (PathwayNode node : this.pathfindingSolver.currentState().fullPath()) {
                        if (node == null) continue;
                        this.fragments.add(node);
                    }
                }
                FDGDEdge edge = this.edgeIterator.next();
                PathwayProblem problem = new PathwayProblem(this.world, edge.entrance1(), edge.node1(), edge.entrance2(), edge.pathway().pieces(), this.fragments);
                this.pathfindingSolver = new StepAStar<PathwayNode>(problem, heuristicWeight);
            } else {
                return true;
            }
        }
        this.pathfindingSolver.step();
        return false;
    }

    @Override
    @Nullable
    public IFramework getCompletedFramework() {
        return null;
    }

    private void initialGraph() throws FailedToGenerateException {
        this.fdgdGraph = new Graph();
        HashMap<FrameworkNode, FDGDNode> nodeLookup = new HashMap<FrameworkNode, FDGDNode>(this.framework.graph.vertexSet().size());
        this._nodeMap = nodeLookup;
        for (FrameworkNode node : this.framework.graph.vertexSet()) {
            BlueprintData data = node.getBlueprintData();
            if (data == null) continue;
            FDGDNode newNode = new FDGDNode(data, BlockPos.field_177992_a, 0);
            this.fdgdGraph.addVertex(newNode);
            nodeLookup.put(node, newNode);
        }
        for (FrameworkEdge edge : this.framework.graph.edgeSet()) {
            PathwayData pathway = null;
            for (PathwayData p1 : edge.node1().pathways()) {
                for (PathwayData p2 : edge.node2().pathways()) {
                    if (p1 != p2) continue;
                    pathway = p1;
                }
            }
            if (pathway == null) continue;
            FDGDNode node1 = (FDGDNode)nodeLookup.get(edge.node1());
            FDGDNode node2 = (FDGDNode)nodeLookup.get(edge.node2());
            FDGDEdge newEdge = new FDGDEdge(node1, node2, pathway);
            this.fdgdGraph.addEdge(node1, node2, newEdge);
        }
    }

    private void assignConnections() {
        for (FDGDNode node : this.fdgdGraph.vertexSet()) {
            node.assignConnections(this.fdgdGraph.edgesOf(node));
            for (FDGDEdge edge : this.fdgdGraph.edgesOf(node)) {
                BlockPos min1 = node.getMin();
                BlockPos max1 = node.getMax();
                if (edge.xOf(node) == (float)min1.func_177958_n() || edge.zOf(node) == (float)min1.func_177952_p() || edge.xOf(node) == (float)max1.func_177958_n() || edge.zOf(node) != (float)max1.func_177952_p()) {
                    // empty if block
                }
                if (!(edge.xOf(node) < (float)min1.func_177958_n() || edge.zOf(node) < (float)min1.func_177952_p() || edge.xOf(node) > (float)max1.func_177958_n()) && !(edge.zOf(node) > (float)max1.func_177952_p())) continue;
            }
        }
    }

    private void clearUselessIntersections(List<FDGDEdge> edges) {
        for (int p = 0; p < edges.size(); ++p) {
            FDGDEdge edge = edges.get(p);
            FDGDNode n1 = edge.node1();
            FDGDNode n2 = edge.node2();
            if (!n1.isIntersection() && !n2.isIntersection()) continue;
            this.fdgdGraph.removeEdge(edge);
            FDGDNode start = n1.isIntersection() ? n1 : n2;
            FDGDNode end = edge.getOpposite(start);
            if (!this.fdgdGraph.canReach(end, start, FDGDNode::isIntersection)) {
                this.fdgdGraph.addEdge(n1, n2, edge);
                continue;
            }
            edges.remove(p);
            --p;
        }
        ArrayList nodes = new ArrayList(this.fdgdGraph.vertices);
        for (int p = 0; p < nodes.size(); ++p) {
            FDGDNode n = (FDGDNode)nodes.get(p);
            Set<FDGDEdge> edgesOut = this.fdgdGraph.edgesOf(n);
            if (!n.isIntersection() || edgesOut.size() >= 3) continue;
            ArrayList<FDGDEdge> edgesOutL = new ArrayList<FDGDEdge>(edgesOut);
            if (edgesOut.size() == 2) {
                FDGDEdge e1 = (FDGDEdge)edgesOutL.get(0);
                FDGDEdge e2 = (FDGDEdge)edgesOutL.get(1);
                FDGDNode n1 = e1.getOpposite(n);
                FDGDNode n2 = e2.getOpposite(n);
                FDGDEdge eNew = new FDGDEdge(n1, n2, e1.pathway());
                this.fdgdGraph.addEdge(n1, n2, eNew);
            }
            for (FDGDEdge e : edgesOutL) {
                this.fdgdGraph.removeEdge(e);
                edges.remove(e);
            }
            this.fdgdGraph.removeVertice(n);
            nodes.remove(p);
            --p;
        }
    }

    private boolean doSpiderWeb() {
        boolean sFinished = true;
        ArrayList<FDGDEdge> edges = new ArrayList<FDGDEdge>(this.fdgdGraph.edgeSet());
        Collections.shuffle(edges);
        int maxAmount = (int)Math.pow(edges.size(), 0.5);
        OrbisLib.LOGGER.info((Object)maxAmount);
        this.clearUselessIntersections(edges);
        int i = 0;
        block0: while (i < maxAmount) {
            sFinished = true;
            block1: for (int p = 0; p < edges.size(); ++p) {
                for (int q = 0; q < edges.size(); ++q) {
                    BlockPos temp;
                    FDGDEdge edge1 = (FDGDEdge)edges.get(p);
                    FDGDEdge edge2 = (FDGDEdge)edges.get(q);
                    FDGDNode e1S = edge1.node1();
                    FDGDNode e1T = edge1.node2();
                    FDGDNode e2S = edge2.node1();
                    FDGDNode e2T = edge2.node2();
                    if (e1T == e2T || e1T == e2S || e1S == e2T || e1S == e2S || !FDGenUtil.isIntersecting(edge1, edge2)) continue;
                    sFinished = false;
                    BlockPos connE1S = edge1.node1().centerAsBP();
                    BlockPos connE1T = edge1.node2().centerAsBP();
                    BlockPos connE2S = edge2.node1().centerAsBP();
                    BlockPos connE2T = edge2.node2().centerAsBP();
                    if (connE1S.func_177958_n() > connE1T.func_177958_n()) {
                        temp = connE1S;
                        connE1S = connE1T;
                        connE1T = temp;
                    }
                    if (connE2S.func_177958_n() > connE2T.func_177958_n()) {
                        temp = connE2S;
                        connE2S = connE2T;
                        connE2T = temp;
                    }
                    long x1 = connE1S.func_177958_n();
                    long z1 = connE1S.func_177952_p();
                    long x2 = connE1T.func_177958_n();
                    long z2 = connE1T.func_177952_p();
                    long x3 = connE2S.func_177958_n();
                    long z3 = connE2S.func_177952_p();
                    long x4 = connE2T.func_177958_n();
                    long z4 = connE2T.func_177952_p();
                    long product1 = x1 * z2 - z1 * x2;
                    long product2 = x3 * z4 - z3 * x4;
                    float denominator = (x1 - x2) * (z3 - z4) - (z1 - z2) * (x3 - x4);
                    long nominX = product1 * (x3 - x4) - (x1 - x2) * product2;
                    long nominZ = product1 * (z3 - z4) - (z1 - z2) * product2;
                    float x = (float)nominX / denominator;
                    float y = (float)(connE1S.func_177956_o() + connE1T.func_177956_o() + connE2S.func_177956_o() + connE2T.func_177956_o()) / 4.0f;
                    float z = (float)nominZ / denominator;
                    BlueprintData intersectionTFD = this.framework.getIntersection(edge1.pathway(), edge2.pathway());
                    edges.remove(edge1);
                    edges.remove(edge2);
                    this.fdgdGraph.removeEdge(edge1);
                    this.fdgdGraph.removeEdge(edge2);
                    FDGDNode node = new FDGDNode(intersectionTFD, new BlockPos((double)x, (double)y, (double)z), edge1, edge2, 0);
                    this.fdgdGraph.addVertex(node);
                    FDGDEdge nEdge1 = new FDGDEdge(node, edge1.node1(), edge1.pathway());
                    this.fdgdGraph.addEdge(node, edge1.node1(), nEdge1);
                    FDGDEdge nEdge2 = new FDGDEdge(node, edge1.node2(), edge1.pathway());
                    this.fdgdGraph.addEdge(node, edge1.node2(), nEdge2);
                    FDGDEdge nEdge3 = new FDGDEdge(node, edge2.node1(), edge2.pathway());
                    this.fdgdGraph.addEdge(node, edge2.node1(), nEdge3);
                    FDGDEdge nEdge4 = new FDGDEdge(node, edge2.node2(), edge2.pathway());
                    this.fdgdGraph.addEdge(node, edge2.node2(), nEdge4);
                    --p;
                    if (++i < maxAmount) continue block1;
                    break block0;
                }
            }
            if (!sFinished) continue;
        }
        this.clearUselessIntersections(edges);
        return sFinished;
    }

    private void doEdgeDestroy() {
        int i;
        ArrayList<FDGDEdge> edges = new ArrayList<FDGDEdge>(this.fdgdGraph.edgeSet());
        int maxAmount = (int)Math.pow(edges.size(), 0.3f);
        OrbisLib.LOGGER.info((Object)maxAmount);
        FDGDEdge removed = null;
        block0: for (i = 0; i < maxAmount; ++i) {
            if (removed != null) {
                edges.remove(removed);
            }
            for (FDGDEdge edge1 : edges) {
                for (FDGDEdge edge2 : edges) {
                    FDGDNode e1S = edge1.node1();
                    FDGDNode e1T = edge1.node2();
                    FDGDNode e2S = edge2.node1();
                    FDGDNode e2T = edge2.node2();
                    if (e1T == e2T || e1T == e2S || e1S == e2T || e1S == e2S || !FDGenUtil.isIntersecting(edge1, edge2)) continue;
                    FDGDEdge toRemove = this.random.nextBoolean() ? edge1 : edge2;
                    this.fdgdGraph.removeEdge(toRemove);
                    if (this.fdgdGraph.canReach(toRemove.node1(), toRemove.node2())) {
                        removed = toRemove;
                        continue block0;
                    }
                    this.fdgdGraph.addEdge(toRemove.node1(), toRemove.node2(), toRemove);
                }
            }
        }
        Region bbx = FDGenUtil.boundingBox(this.fdgdGraph);
        float diagonal = FDGenUtil.euclidian(bbx.getMin(), bbx.getMax());
        block3: for (int j = 0; j < i; ++j) {
            ArrayList vertices = new ArrayList(this.fdgdGraph.vertices);
            Collections.shuffle(vertices);
            for (FDGDNode n : vertices) {
                for (FDGDNode n2 : vertices) {
                    float dist;
                    if (this.fdgdGraph.edgesOf(n).size() >= 3 || this.fdgdGraph.edgesOf(n2).size() >= 3 || n == n2 || this.fdgdGraph.getEdge(n, n2) != null || !((dist = (float)FDGenUtil.euclidian(n.centerAsBP(), n2.centerAsBP())) < diagonal * 0.4f)) continue;
                    PathwayData p = n.getData().getEntrance().toConnectTo();
                    FDGDEdge e = new FDGDEdge(n, n2, p);
                    boolean isIntersectingOthers = false;
                    for (FDGDEdge e2 : this.fdgdGraph.edgeSet()) {
                        if (!FDGenUtil.isIntersecting(e, e2)) continue;
                        isIntersectingOthers = true;
                        break;
                    }
                    if (isIntersectingOthers) continue;
                    OrbisLib.LOGGER.info("Adding edge");
                    this.fdgdGraph.addEdge(n, n2, e);
                    continue block3;
                }
            }
        }
    }

    public Graph<FDGDNode, FDGDEdge> getFDGDDebug() {
        return this.fdgdGraph;
    }

    public List<BlueprintRegion> getFragments() {
        return this.fragments;
    }

    public Iterable<PathwayNode> getPathfindingDebug() {
        PathwayNode currentState = this.pathfindingSolver.currentState();
        if (currentState == null) {
            OrbisLib.LOGGER.info("No more states to expand. This is not supposed to happen");
            return () -> new ArrayList().iterator();
        }
        return currentState.fullPath();
    }

    @Override
    public IFrameworkAlgorithm.Phase getPhase() {
        return this.phase;
    }
}

