/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework;

import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.framework.FrameworkAlgorithm;
import com.gildedgames.orbis.lib.data.framework.FrameworkEdge;
import com.gildedgames.orbis.lib.data.framework.FrameworkNode;
import com.gildedgames.orbis.lib.data.framework.FrameworkType;
import com.gildedgames.orbis.lib.data.framework.GeneratedFramework;
import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.IFrameworkDataListener;
import com.gildedgames.orbis.lib.data.framework.interfaces.IFrameworkNode;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.data.pathway.PathwayData;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.IWorldObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class FrameworkData
implements IFrameworkNode,
IData,
IDimensions {
    public static final String EXTENSION = "framework";
    private static final Object stub = "aweoigh";
    protected final Graph<FrameworkNode, FrameworkEdge> graph = new Graph();
    private final Map<Pair<PathwayData, PathwayData>, BlueprintData> intersections = new HashMap<Pair<PathwayData, PathwayData>, BlueprintData>();
    private final List<IFrameworkDataListener> listeners = Lists.newArrayList();
    private Map<Pair<Integer, IFrameworkNode>, BlockPos> nodeToPos = Maps.newHashMap();
    private IDataMetadata metadata;
    private FrameworkType type = FrameworkType.RECTANGLES;
    private int width;
    private int height;
    private int length;
    private int nextId;

    private FrameworkData() {
        this.metadata = new DataMetadata();
    }

    public FrameworkData(int width, int height, int length) {
        this();
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public void listen(IFrameworkDataListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean unlisten(IFrameworkDataListener listener) {
        return this.listeners.remove(listener);
    }

    public Map<Pair<Integer, IFrameworkNode>, BlockPos> getNodeToPosMap() {
        return this.nodeToPos;
    }

    public GeneratedFramework prepare(World world, BlockPos pos) {
        FrameworkAlgorithm algorithm = new FrameworkAlgorithm(this, world);
        return algorithm.computeFully();
    }

    public FrameworkEdge edgeBetween(FrameworkNode node1, FrameworkNode node2) {
        return this.graph.getEdge(node1, node2);
    }

    public BlockPos getRelativePos(IFrameworkNode node) {
        return this.nodeToPos.get(node);
    }

    public int getNodeId(IFrameworkNode node) {
        for (Pair<Integer, IFrameworkNode> pair : this.nodeToPos.keySet()) {
            int id = (Integer)pair.getKey();
            IFrameworkNode n = (IFrameworkNode)pair.getValue();
            if (node != n) continue;
            return id;
        }
        return -1;
    }

    public boolean removeNode(int nodeId) {
        Pair<Integer, IFrameworkNode> toRemove = null;
        for (Pair<Integer, IFrameworkNode> pair : this.nodeToPos.keySet()) {
            int id = (Integer)pair.getKey();
            if (id != nodeId) continue;
            toRemove = pair;
            break;
        }
        if (toRemove != null) {
            IFrameworkNode node = (IFrameworkNode)toRemove.getValue();
            if (node instanceof FrameworkNode) {
                this.graph.removeVertice((FrameworkNode)node);
            }
            this.nodeToPos.remove(toRemove);
            this.listeners.forEach(l -> l.onRemoveNode(node));
            return true;
        }
        return false;
    }

    public Pair<Integer, FrameworkNode> addNode(IFrameworkNode data, IWorldObject parentWorldObject) {
        if (this.nodeToPos.values().contains(data.getBounds().getMin())) {
            return null;
        }
        IRegion bb = parentWorldObject.getShape().getBoundingBox();
        BlockPos min = data.getBounds().getMin().func_177971_a((Vec3i)bb.getMin());
        BlockPos max = data.getBounds().getMax().func_177971_a((Vec3i)bb.getMin());
        if (max.func_177958_n() > bb.getMax().func_177958_n() || max.func_177956_o() > bb.getMax().func_177956_o() || max.func_177952_p() > bb.getMax().func_177952_p() || min.func_177958_n() < bb.getMin().func_177958_n() || min.func_177956_o() < bb.getMin().func_177956_o() || min.func_177952_p() < bb.getMin().func_177952_p()) {
            return null;
        }
        for (Pair<Integer, IFrameworkNode> pair : this.nodeToPos.keySet()) {
            IFrameworkNode n = (IFrameworkNode)pair.getValue();
            if (!RegionHelp.intersects3D(n.getBounds(), data.getBounds())) continue;
            return null;
        }
        FrameworkNode newNode = new FrameworkNode(data);
        newNode.setDataParent(this);
        this.graph.addVertex(newNode);
        int id = this.nextId++;
        this.nodeToPos.put((Pair<Integer, IFrameworkNode>)Pair.of((Object)id, (Object)newNode), data.getBounds().getMin());
        this.listeners.forEach(l -> l.onAddNode(newNode));
        return Pair.of((Object)id, (Object)newNode);
    }

    public boolean addEdge(FrameworkNode node1, FrameworkNode node2) {
        if (!this.graph.containsVertex(node1) || !this.graph.containsVertex(node2)) {
            return false;
        }
        if (this.graph.edgesOf(node1).size() >= node1.schedule().getMaxEdges() || this.graph.edgesOf(node2).size() >= node2.schedule().getMaxEdges()) {
            return false;
        }
        FrameworkEdge edge = new FrameworkEdge(node1, node2);
        this.graph.addEdge(node1, node2, edge);
        this.listeners.forEach(l -> l.onAddEdge(node1, node2));
        return true;
    }

    public FrameworkEdge edgeAt(FrameworkNode n1, FrameworkNode n2) {
        return this.graph.getEdge(n1, n2);
    }

    public void addIntersection(PathwayData pathway1, PathwayData pathway2, BlueprintData blueprint) {
        this.intersections.put((Pair<PathwayData, PathwayData>)Pair.of((Object)pathway1, (Object)pathway2), blueprint);
        this.listeners.forEach(l -> l.onAddIntersection(pathway1, pathway2, blueprint));
    }

    public FrameworkType getType() {
        return this.type;
    }

    @Override
    public BlueprintData getBlueprintData() {
        return null;
    }

    @Override
    public int getMaxEdges() {
        return 100;
    }

    public BlueprintData getIntersection(PathwayData pathway1, PathwayData pathway2) {
        for (Pair<PathwayData, PathwayData> t : this.intersections.keySet()) {
            if ((t.getLeft() != pathway1 || t.getRight() != pathway2) && (t.getLeft() != pathway2 || t.getRight() != pathway1)) continue;
            return this.intersections.get(t);
        }
        return null;
    }

    @Override
    public IMutableRegion getBounds() {
        return null;
    }

    @Override
    public Collection<PathwayData> pathways() {
        HashSet<PathwayData> schedules = new HashSet<PathwayData>();
        for (FrameworkNode node : this.graph.vertexSet()) {
            schedules.addAll(node.pathways());
        }
        return schedules;
    }

    @Override
    public void preSaveToDisk(IWorldObject object) {
    }

    @Override
    public IData clone() {
        FrameworkData data = new FrameworkData();
        NBTTagCompound tag = new NBTTagCompound();
        this.write(tag);
        data.read(tag);
        return data;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.metadata.getIdentifier());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FrameworkData) {
            FrameworkData o = (FrameworkData)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.metadata.getIdentifier(), (Object)o.metadata.getIdentifier());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public String getFileExtension() {
        return EXTENSION;
    }

    @Override
    public IDataMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(IDataMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74768_a("type", this.type.ordinal());
        tag.func_74768_a("width", this.width);
        tag.func_74768_a("height", this.height);
        tag.func_74768_a("length", this.length);
        funnel.setMap("nodeToPos", this.nodeToPos, p -> {
            NBTFunnel f = new NBTFunnel(new NBTTagCompound());
            f.getTag().func_74768_a("id", ((Integer)p.getKey()).intValue());
            f.set("node", (NBT)p.getValue());
            return f.getTag();
        }, NBTFunnel.POS_SETTER);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.type = FrameworkType.values()[tag.func_74762_e("type")];
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
        this.length = tag.func_74762_e("length");
        this.nodeToPos = funnel.getMap("nodeToPos", t -> {
            NBTFunnel f = new NBTFunnel((NBTTagCompound)t);
            int id = f.getTag().func_74762_e("id");
            IFrameworkNode node = (IFrameworkNode)f.get("node");
            return Pair.of((Object)id, (Object)node);
        }, NBTFunnel.POS_GETTER);
        this.nodeToPos.keySet().forEach(p -> {
            if (p.getValue() instanceof FrameworkNode) {
                this.graph.addVertex((FrameworkNode)p.getValue());
            }
        });
        this.nodeToPos.keySet().forEach(p -> ((IFrameworkNode)p.getValue()).setDataParent(this));
    }

    public Graph<FrameworkNode, FrameworkEdge> getGraph() {
        return this.graph;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Class<? extends FrameworkData> getDataClass() {
        return FrameworkData.class;
    }

    @Override
    public FrameworkData getDataParent() {
        return this;
    }

    @Override
    public void setDataParent(FrameworkData frameworkData) {
    }
}

