/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;

public class Graph<NODE, EDGE> {
    Set<NODE> vertices = new HashSet<NODE>();
    Set<EDGE> edges = new HashSet<EDGE>();
    Map<NODE, Set<EDGE>> connections = new HashMap<NODE, Set<EDGE>>();
    Map<EDGE, Tuple<NODE, NODE>> edge_conn = new HashMap<EDGE, Tuple<NODE, NODE>>();

    public Set<NODE> vertexSet() {
        return this.vertices;
    }

    public Set<EDGE> edgesOf(NODE n) {
        return this.connections.get(n);
    }

    public Set<EDGE> edgeSet() {
        return this.edges;
    }

    public void removeEdge(EDGE edge1) {
        this.edges.remove(edge1);
        Tuple<NODE, NODE> nodes = this.edge_conn.get(edge1);
        this.connections.get(nodes.func_76341_a()).remove(edge1);
        this.connections.get(nodes.func_76340_b()).remove(edge1);
        this.edge_conn.remove(edge1);
    }

    public void addVertex(NODE n) {
        if (this.vertices.contains(n)) {
            return;
        }
        this.vertices.add(n);
        this.connections.put(n, new HashSet());
    }

    public void addEdge(NODE node, NODE fdgdNode, EDGE nEdge1) {
        this.addVertex(node);
        this.connections.get(node).add(nEdge1);
        this.addVertex(fdgdNode);
        this.connections.get(fdgdNode).add(nEdge1);
        this.edges.add(nEdge1);
        this.edge_conn.put(nEdge1, new Tuple(node, fdgdNode));
    }

    public NODE getOpposite(NODE node, EDGE edge) {
        Tuple<NODE, NODE> nodes = this.edge_conn.get(edge);
        if (nodes.func_76341_a() == node) {
            return (NODE)nodes.func_76340_b();
        }
        if (nodes.func_76340_b() == node) {
            return (NODE)nodes.func_76341_a();
        }
        return null;
    }

    public boolean canReach(NODE n1, NODE n2, Predicate<NODE> predicate) {
        HashSet visitedNodes = new HashSet();
        Stack<Object> unvisitedNodes = new Stack<Object>();
        unvisitedNodes.add(n2);
        while (unvisitedNodes.size() > 0) {
            Object activeNode = unvisitedNodes.pop();
            for (EDGE e : this.edgesOf(activeNode)) {
                Object n = this.getOpposite(activeNode, e);
                if (n == n1) {
                    return true;
                }
                if (visitedNodes.contains(n) || !predicate.test(n)) continue;
                unvisitedNodes.add(n);
            }
            visitedNodes.add(activeNode);
        }
        return false;
    }

    public boolean canReach(NODE n1, NODE n2) {
        return this.canReach(n1, n2, n -> true);
    }

    public boolean containsVertex(NODE node1) {
        return this.vertices.contains(node1);
    }

    public EDGE getEdge(NODE node1, NODE node2) {
        for (EDGE e1 : this.connections.get(node1)) {
            for (EDGE e2 : this.connections.get(node2)) {
                if (e1 != e2) continue;
                return e1;
            }
        }
        return null;
    }

    public void removeVertice(NODE n) {
        if (this.connections.get(n).size() != 0) {
            throw new IllegalArgumentException("Cannot remove vertice with active edges.");
        }
        this.connections.remove(n);
        this.vertices.remove(n);
    }
}

