/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation;

import com.gildedgames.orbis.lib.data.framework.generation.FDGDNode;
import com.gildedgames.orbis.lib.data.pathway.IEntrance;
import com.gildedgames.orbis.lib.data.pathway.PathwayData;
import net.minecraft.util.math.BlockPos;

public class FDGDEdge {
    private final FDGDNode node1;
    private final FDGDNode node2;
    private final PathwayData pathway;
    private IEntrance connection1;
    private IEntrance connection2;
    private float ent1X;
    private float ent1Y;
    private float ent1Z;
    private float ent2X;
    private float ent2Y;
    private float ent2Z;

    public FDGDEdge(FDGDNode node1, FDGDNode node2, PathwayData pathway) {
        this.node1 = node1;
        this.node2 = node2;
        this.pathway = pathway;
    }

    public IEntrance getConnection(FDGDNode node) {
        if (node.equals(this.node1)) {
            return this.connection1;
        }
        if (node.equals(this.node2)) {
            return this.connection2;
        }
        throw new IllegalArgumentException();
    }

    public void setConnection(FDGDNode node, IEntrance connection) {
        if (node.equals(this.node1)) {
            this.connection1 = connection;
            BlockPos pos = connection.getBounds().getMin();
            this.ent1X = pos.func_177958_n();
            this.ent1Y = pos.func_177956_o();
            this.ent1Z = pos.func_177952_p();
        } else if (node.equals(this.node2)) {
            this.connection2 = connection;
            BlockPos pos = connection.getBounds().getMin();
            this.ent2X = pos.func_177958_n();
            this.ent2Y = pos.func_177956_o();
            this.ent2Z = pos.func_177952_p();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public FDGDNode getOpposite(FDGDNode node) {
        return node.equals(this.node1) ? this.node2 : (node.equals(this.node2) ? this.node1 : null);
    }

    public PathwayData pathway() {
        return this.pathway;
    }

    public FDGDNode node1() {
        return this.node1;
    }

    public FDGDNode node2() {
        return this.node2;
    }

    public IEntrance connectionOf1() {
        return this.connection1;
    }

    public IEntrance connectionOf2() {
        return this.connection2;
    }

    public float entrance1X() {
        return this.ent1X;
    }

    public float entrance1Y() {
        return this.ent1Y;
    }

    public float entrance1Z() {
        return this.ent1Z;
    }

    public float entrance2X() {
        return this.ent2X;
    }

    public float entrance2Y() {
        return this.ent2Y;
    }

    public float entrance2Z() {
        return this.ent2Z;
    }

    public BlockPos entrance1() {
        return new BlockPos((double)this.entrance1X(), (double)this.entrance1Y(), (double)this.entrance1Z());
    }

    public BlockPos entrance2() {
        return new BlockPos((double)this.entrance2X(), (double)this.entrance2Y(), (double)this.entrance2Z());
    }

    public float xOf(FDGDNode node) {
        if (node == this.node1) {
            return this.ent1X;
        }
        return this.ent2X;
    }

    public float yOf(FDGDNode node) {
        if (node == this.node1) {
            return this.ent1Y;
        }
        return this.ent2Y;
    }

    public float zOf(FDGDNode node) {
        if (node == this.node1) {
            return this.ent1Z;
        }
        return this.ent2Z;
    }

    public void applyForce() {
        this.ent1X += this.node1.getForceX();
        this.ent1Y += this.node1.getForceY();
        this.ent1Z += this.node1.getForceZ();
        this.ent2X += this.node2.getForceX();
        this.ent2Y += this.node2.getForceY();
        this.ent2Z += this.node2.getForceZ();
    }
}

