/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.core.world_objects.BlueprintRegion;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDEdge;
import com.gildedgames.orbis.lib.data.framework.generation.FDGenUtil;
import com.gildedgames.orbis.lib.data.pathway.IEntrance;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.util.RotationHelp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class FDGDNode
extends BlueprintRegion {
    private final int toleranceDist;
    private float posX;
    private float posY;
    private float posZ;
    private float prevX;
    private float prevY;
    private float prevZ;
    private float forceX;
    private float forceY;
    private float forceZ;
    private boolean isIntersection = false;
    private FDGDEdge oldEdge1;
    private FDGDEdge oldEdge2;

    public FDGDNode(BlueprintData data, BlockPos pos, int toleranceDist) {
        super(pos, data);
        this.data = data;
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.computeMinMax();
        this.toleranceDist = data.getEntrance().toConnectTo().getToleranceDist();
    }

    public FDGDNode(BlueprintData intersection, BlockPos pos, FDGDEdge oldEdge1, FDGDEdge oldEdge2, int toleranceDist) {
        this(intersection, pos, toleranceDist);
        this.isIntersection = true;
        this.oldEdge1 = oldEdge1;
        this.oldEdge2 = oldEdge2;
    }

    private void computeMinMax() {
        BlueprintRegion region = this.getRegionForBlueprint();
        this.min = region.getMin().func_177973_b(new Vec3i(this.toleranceDist, this.toleranceDist, this.toleranceDist));
        this.max = region.getMax().func_177971_a(new Vec3i(this.toleranceDist, this.toleranceDist, this.toleranceDist));
    }

    public float getX() {
        return this.posX;
    }

    public float getY() {
        return this.posY;
    }

    public float getZ() {
        return this.posZ;
    }

    public float getPrevX() {
        return this.prevX;
    }

    public float getPrevY() {
        return this.prevY;
    }

    public float getPrevZ() {
        return this.prevZ;
    }

    public float getForceX() {
        return this.forceX;
    }

    public float getForceY() {
        return this.forceY;
    }

    public float getForceZ() {
        return this.forceZ;
    }

    public void setPosition(float x, float y, float z) {
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.computeMinMax();
    }

    public void setForce(float x, float y, float z) {
        this.forceX = x;
        this.forceY = y;
        this.forceZ = z;
    }

    public void addForce(float x, float y, float z) {
        this.forceX += x;
        this.forceY += y;
        this.forceZ += z;
    }

    public void subtrForce(float x, float y, float z) {
        this.forceX -= x;
        this.forceY -= y;
        this.forceZ -= z;
    }

    public void applyForce() {
        this.setPosition(this.posX + this.forceX, this.posY + this.forceY, this.posZ + this.forceZ);
    }

    public void assignConnections(Collection<FDGDEdge> edges) {
        int best = Integer.MAX_VALUE;
        Map bestResult = null;
        Rotation bestRotation = Rotation.NONE;
        ArrayList<FDGDEdge> edgesL = new ArrayList<FDGDEdge>(edges);
        for (Rotation rotation : Rotation.values()) {
            List<IEntrance> entrances = this.getEntrances(rotation);
            if (entrances.size() < edges.size()) {
                throw new IllegalStateException();
            }
            Tuple<Map<FDGDEdge, IEntrance>, Integer> result = this.bestEntrances(edgesL, entrances, 0, 0, best);
            if (result == null) continue;
            bestResult = (Map)result.func_76341_a();
            best = (Integer)result.func_76340_b();
            bestRotation = rotation;
        }
        if (bestResult == null) {
            OrbisLib.LOGGER.info("Was unable to find a valid assignment of entrances to edges. This should not happen.");
            OrbisLib.LOGGER.info((Object)best);
        } else {
            for (Map.Entry entry : bestResult.entrySet()) {
                ((FDGDEdge)entry.getKey()).setConnection(this, (IEntrance)entry.getValue());
            }
            this.rotation = bestRotation;
            this.computeMinMax();
        }
    }

    public void assignConnectionsFixRot(Collection<FDGDEdge> edges) {
        List<IEntrance> entrances = this.getEntrances(this.rotation);
        ArrayList<FDGDEdge> edgesL = new ArrayList<FDGDEdge>(edges);
        if (entrances.size() < edges.size()) {
            throw new IllegalStateException();
        }
        Tuple<Map<FDGDEdge, IEntrance>, Integer> result = this.bestEntrances(edgesL, entrances, 0, 0, Integer.MAX_VALUE);
        if (result == null) {
            OrbisLib.LOGGER.info("Was unable to find a valid assignment of entrances to edges. This should not happen.");
        } else {
            for (Map.Entry edge : ((Map)result.func_76341_a()).entrySet()) {
                ((FDGDEdge)edge.getKey()).setConnection(this, (IEntrance)edge.getValue());
            }
        }
    }

    private boolean isValidConnectionAssignment(Tuple<Map<FDGDEdge, IEntrance>, Integer> solution) {
        Map assignment = (Map)solution.func_76341_a();
        for (FDGDEdge edge : assignment.keySet()) {
            FDGDNode n = edge.getOpposite(this);
            IEntrance e = (IEntrance)assignment.get(edge);
            for (IEntrance e1 : assignment.values()) {
                for (IEntrance e2 : assignment.values()) {
                    if (e == e1 || e2 == e || e1 == e2) continue;
                    float e1X = e1.getBounds().getMin().func_177958_n();
                    float e1Z = e1.getBounds().getMin().func_177952_p();
                    float e2X = e2.getBounds().getMin().func_177958_n();
                    float e2Z = e2.getBounds().getMin().func_177952_p();
                    float dx1 = e1X - this.getX();
                    float dz1 = e1Z - this.getZ();
                    float length1 = (float)Math.sqrt(dx1 * dx1 + dz1 * dz1);
                    e1X = (float)((double)e1X - (double)dx1 * 0.01 / (double)length1);
                    e1Z = (float)((double)e1Z - (double)dz1 * 0.01 / (double)length1);
                    float dx2 = e2X - this.getX();
                    float dz2 = e2Z - this.getZ();
                    float length2 = (float)Math.sqrt(dx2 * dx2 + dz2 * dz2);
                    e2X = (float)((double)e2X - (double)dx2 * 0.01 / (double)length2);
                    e2Z = (float)((double)e2Z - (double)dz2 * 0.01 / (double)length2);
                    if (!FDGenUtil.isIntersecting(n.getX(), n.getZ(), e.getBounds().getMin().func_177958_n(), e.getBounds().getMin().func_177952_p(), e1X, e1Z, e2X, e2Z, false)) continue;
                    return false;
                }
            }
            for (FDGDEdge edge2 : assignment.keySet()) {
                IEntrance e2;
                FDGDNode n2 = edge2.getOpposite(this);
                e2 = (IEntrance)assignment.get(edge2);
                if (edge == edge2 || !FDGenUtil.isIntersecting(n.getX(), n.getZ(), e.getBounds().getMin().func_177958_n(), e.getBounds().getMin().func_177952_p(), n2.getX(), n2.getZ(), e2.getBounds().getMin().func_177958_n(), e2.getBounds().getMin().func_177952_p(), false)) continue;
                return false;
            }
        }
        return true;
    }

    private Tuple<Map<FDGDEdge, IEntrance>, Integer> bestEntrances(List<FDGDEdge> edges, List<IEntrance> entrancesLeft, int edgeIndex, int cost, int best) {
        if (edgeIndex >= edges.size()) {
            return new Tuple(new HashMap(edges.size()), (Object)cost);
        }
        FDGDEdge edge = edges.get(edgeIndex);
        Tuple<Map<FDGDEdge, IEntrance>, Integer> bestInDepth = null;
        FDGDNode opposite = edge.getOpposite(this);
        HashMap<IEntrance, Integer> costMap = new HashMap<IEntrance, Integer>(entrancesLeft.size());
        for (IEntrance entrance : entrancesLeft) {
            costMap.put(entrance, cost + FDGenUtil.euclidian(entrance.getBounds().getMin(), (int)opposite.getX(), (int)opposite.getY(), (int)opposite.getZ()));
        }
        entrancesLeft.sort(Comparator.comparing(costMap::get));
        for (IEntrance entrance : entrancesLeft) {
            int newCost;
            if (!edge.pathway().equals(entrance.toConnectTo()) || (newCost = ((Integer)costMap.get(entrance)).intValue()) >= best) continue;
            ArrayList<IEntrance> copy = new ArrayList<IEntrance>(entrancesLeft);
            copy.remove(entrance);
            Tuple<Map<FDGDEdge, IEntrance>, Integer> result = this.bestEntrances(edges, copy, edgeIndex + 1, newCost, best);
            if (result == null) continue;
            ((Map)result.func_76341_a()).put(edge, entrance);
            if (this.isValidConnectionAssignment(result)) {
                bestInDepth = result;
                best = (Integer)result.func_76340_b();
                continue;
            }
            ((Map)result.func_76341_a()).remove(edge);
        }
        return bestInDepth;
    }

    public List<IEntrance> getEntrances(Rotation rotation) {
        return RotationHelp.getEntrances(this.getData(), rotation, this.centerAsBP());
    }

    public BlockPos centerAsBP() {
        return new BlockPos((int)this.posX, (int)this.posY, (int)this.posZ);
    }

    public boolean isIntersection() {
        return this.isIntersection;
    }

    public BlueprintRegion getRegionForBlueprint() {
        IRegion r = RotationHelp.regionFromCenter((int)this.posX, (int)this.posY, (int)this.posZ, this.data, this.rotation);
        return new BlueprintRegion(r.getMin(), this.rotation, this.data);
    }
}

