/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation;

import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDEdge;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDNode;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.RegionHelp;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class FDGenUtil {
    private static float ESCAPE_DIST = 5.0f;

    public static Region boundingBox(Graph<FDGDNode, FDGDEdge> graph) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (FDGDNode n : graph.vertexSet()) {
            BlockPos min = n.getMin();
            BlockPos max = n.getMax();
            minX = Math.min(minX, min.func_177958_n());
            minY = Math.min(minY, min.func_177956_o());
            minZ = Math.min(minZ, min.func_177952_p());
            maxX = Math.max(maxX, max.func_177958_n());
            maxY = Math.max(maxY, max.func_177956_o());
            maxZ = Math.max(maxZ, max.func_177952_p());
        }
        return new Region(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
    }

    public static boolean hasCollision(Graph<FDGDNode, FDGDEdge> graph) {
        for (FDGDNode node1 : graph.vertexSet()) {
            for (FDGDNode node2 : graph.vertexSet()) {
                if (node1 == node2 || !RegionHelp.intersects2D(node1, node2)) continue;
                return true;
            }
        }
        return false;
    }

    public static float[] pointOfForce(FDGDNode v, FDGDNode u) {
        float vPosX = v.getX();
        float vPosZ = v.getZ();
        float uPosX = 0.0f;
        float uPosZ = 0.0f;
        if (RegionHelp.contains(u, vPosX, 0.0f, vPosZ)) {
            float dx = vPosX - u.getX();
            float dz = vPosZ - u.getZ();
            float length = (float)Math.sqrt(dx * dx + dz * dz);
            dx = dx / length * ESCAPE_DIST;
            dz = dz / length * ESCAPE_DIST;
            uPosX = vPosX - dx;
            uPosZ = vPosZ - dz;
        } else if (RegionHelp.intersects2D(v, u)) {
            float edgeClampX = MathHelper.func_76131_a((float)vPosX, (float)u.getMin().func_177958_n(), (float)u.getMax().func_177958_n());
            float edgeClampZ = MathHelper.func_76131_a((float)vPosZ, (float)u.getMin().func_177952_p(), (float)u.getMax().func_177952_p());
            float dx = vPosX - edgeClampX;
            float dz = vPosZ - edgeClampZ;
            float length = (float)Math.sqrt(dx * dx + dz * dz);
            dx = dx / length * ESCAPE_DIST;
            dz = dz / length * ESCAPE_DIST;
            uPosX = vPosX - dx;
            uPosZ = vPosZ - dz;
        } else {
            float edgeClampUX = MathHelper.func_76131_a((float)vPosX, (float)u.getMin().func_177958_n(), (float)u.getMax().func_177958_n());
            float edgeClampUZ = MathHelper.func_76131_a((float)vPosZ, (float)u.getMin().func_177952_p(), (float)u.getMax().func_177952_p());
            float edgeClampVX = MathHelper.func_76131_a((float)edgeClampUX, (float)v.getMin().func_177958_n(), (float)v.getMax().func_177958_n());
            float edgeClampVZ = MathHelper.func_76131_a((float)edgeClampUZ, (float)v.getMin().func_177952_p(), (float)v.getMax().func_177952_p());
            float dx = vPosX - edgeClampUX;
            float dz = vPosZ - edgeClampUZ;
            float dxClamp = edgeClampVX - edgeClampUX;
            float dzClamp = edgeClampVZ - edgeClampUZ;
            float targetLength = (float)Math.sqrt(dxClamp * dxClamp + dzClamp * dzClamp);
            float length = (float)Math.sqrt(dx * dx + dz * dz);
            dx = dx / length * targetLength;
            dz = dz / length * targetLength;
            uPosX = vPosX - dx;
            uPosZ = vPosZ - dz;
        }
        return new float[]{uPosX, 0.0f, uPosZ};
    }

    public static boolean hasEdgeIntersections(Graph<FDGDNode, FDGDEdge> graph) {
        ArrayList<FDGDEdge> edges = new ArrayList<FDGDEdge>(graph.edgeSet());
        for (int i = 0; i < edges.size(); ++i) {
            for (int x = i + 1; x < edges.size(); ++x) {
                FDGDEdge edge1 = (FDGDEdge)edges.get(i);
                FDGDEdge edge2 = (FDGDEdge)edges.get(x);
                FDGDNode e1S = edge1.node1();
                FDGDNode e1T = edge1.node2();
                FDGDNode e2S = edge2.node1();
                FDGDNode e2T = edge2.node2();
                if (e1T == e2T || e1T == e2S || e1S == e2T || e1S == e2S || !FDGenUtil.isIntersecting(edge1, edge2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEdgeIntersections(Graph<FDGDNode, FDGDEdge> graph, FDGDEdge edge) {
        for (FDGDEdge e : graph.edgeSet()) {
            if (!FDGenUtil.isIntersecting(edge, e)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntersecting(float edge1n1X, float edge1n1Z, float edge1n2X, float edge1n2Z, float edge2n1X, float edge2n1Z, float edge2n2X, float edge2n2Z) {
        return FDGenUtil.isIntersecting(edge1n1X, edge1n1Z, edge1n2X, edge1n2Z, edge2n1X, edge2n1Z, edge2n2X, edge2n2Z, false);
    }

    public static boolean isIntersecting(float edge1n1X, float edge1n1Z, float edge1n2X, float edge1n2Z, float edge2n1X, float edge2n1Z, float edge2n2X, float edge2n2Z, boolean exact) {
        float line1X = edge1n2X - edge1n1X;
        float line1Z = edge1n2Z - edge1n1Z;
        float line2X = edge2n2X - edge2n1X;
        float line2Z = edge2n2Z - edge2n1Z;
        float diffX = edge1n1X - edge2n1X;
        float diffZ = edge1n1Z - edge2n1Z;
        float denom = line1X * line2Z - line2X * line1Z;
        float s = (line1X * diffZ - line1Z * diffX) / denom;
        float t = (line2X * diffZ - line2Z * diffX) / denom;
        if (exact) {
            return s >= 0.0f && s <= 1.0f && t >= 0.0f && t <= 1.0f;
        }
        return s > 0.0f && s < 1.0f && t > 0.0f && t < 1.0f;
    }

    public static boolean isIntersecting(FDGDEdge edge1, FDGDEdge edge2) {
        return FDGenUtil.isIntersecting(edge1.node1().getX(), edge1.node1().getZ(), edge1.node2().getX(), edge1.node2().getZ(), edge2.node1().getX(), edge2.node1().getZ(), edge2.node2().getX(), edge2.node2().getZ());
    }

    public static int euclidian(BlockPos from, BlockPos to) {
        return FDGenUtil.euclidian(from, to.func_177958_n(), to.func_177956_o(), to.func_177952_p());
    }

    public static int euclidian(BlockPos from, int toX, int toY, int toZ) {
        return FDGenUtil.euclidian(from.func_177958_n(), from.func_177956_o(), from.func_177952_p(), toX, toY, toZ);
    }

    public static int euclidian(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return Math.abs(fromX - toX) + Math.abs(fromY - toY) + Math.abs(fromZ - toZ);
    }

    public static float euclidian(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        return Math.abs(fromX - toX) + Math.abs(fromY - toY) + Math.abs(fromZ - toZ);
    }
}

