/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.csp;

import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.generation.csp.IConstraint;
import com.gildedgames.orbis.lib.data.framework.generation.csp.IConstraintProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CSPSolver {
    public static <VAR> Map<VAR, Object> solve(IConstraintProblem<VAR> problem) {
        Collection<IConstraint<VAR>> constraints = problem.constraints();
        HashMap<VAR, ArrayList<Object>> domains = new HashMap<VAR, ArrayList<Object>>(problem.variables().size());
        Graph<VAR, IConstraint<VAR>> graph = new Graph<VAR, IConstraint<VAR>>();
        problem.variables().forEach(graph::addVertex);
        HashSet<IConstraint<VAR>> addedConstraints = new HashSet<IConstraint<VAR>>();
        for (VAR var : problem.variables()) {
            ArrayList<Object> domain = new ArrayList<Object>(problem.domain(var));
            domains.put(var, domain);
            for (IConstraint<VAR> constraint : constraints) {
                List<VAR> scope = constraint.scope();
                if (!scope.contains(var)) continue;
                if (scope.size() == 1 && !CSPSolver.reduceDomain(constraint, domain, new Object[1], 0)) {
                    return null;
                }
                if (scope.size() != 2 || addedConstraints.contains(constraint)) continue;
                addedConstraints.add(constraint);
                Object other = null;
                for (Object it : scope) {
                    if (it.equals(var)) continue;
                    other = it;
                }
                graph.addEdge(var, other, constraint);
            }
        }
        return CSPSolver.backtrack(problem, domains, graph, null);
    }

    private static boolean reduceDomain(IConstraint<?> constraint, List<Object> domain, Object[] params, int index) {
        Iterator<Object> iterator = domain.iterator();
        while (iterator.hasNext()) {
            Object next;
            params[index] = next = iterator.next();
            if (constraint.constraint(next)) continue;
            iterator.remove();
        }
        return !domain.isEmpty();
    }

    private static <VAR> Map<VAR, Object> backtrack(IConstraintProblem<VAR> problem, Map<VAR, List<Object>> domains, Graph<VAR, IConstraint<VAR>> graph, VAR lastAssigned) {
        Collection<Object> vars = problem.variables();
        ArrayList<Iterator<Object>> assigned = new ArrayList<Iterator<Object>>();
        ArrayList<Iterator<Object>> unassigned = new ArrayList<Iterator<Object>>();
        for (Iterator<Object> var : vars) {
            int domainSize = domains.get(var).size();
            if (domainSize == 0) {
                return null;
            }
            if (domainSize == 1) {
                assigned.add(var);
                continue;
            }
            unassigned.add(var);
        }
        if (unassigned.isEmpty()) {
            HashMap<Object, Object> result = new HashMap<Object, Object>(vars.size());
            for (Object var : vars) {
                result.put(var, domains.get(var).get(0));
            }
            return result;
        }
        Object var = null;
        var = lastAssigned == null ? problem.firstVar(domains) : problem.selectNextVar(unassigned, domains, lastAssigned);
        ArrayList<IConstraint<Object>> toCheck = new ArrayList<IConstraint<Object>>();
        for (IConstraint<Object> constraint : problem.constraints()) {
            boolean hasAllVars = true;
            for (Object object : constraint.scope()) {
                if (object.equals(var) || assigned.contains(object)) continue;
                hasAllVars = false;
                break;
            }
            if (!hasAllVars) continue;
            toCheck.add(constraint);
        }
        for (Object value : problem.sortValues(domains.get(var))) {
            Map<Object, Object> map;
            boolean bl;
            boolean consistent = true;
            for (IConstraint iConstraint : toCheck) {
                Object[] objectArray = new Object[iConstraint.scope().size()];
                for (int i = 0; i < iConstraint.scope().size(); ++i) {
                    Object param = iConstraint.scope().get(i);
                    objectArray[i] = param.equals(var) ? value : domains.get(param).get(0);
                }
                if (iConstraint.constraint(objectArray)) continue;
                consistent = false;
                break;
            }
            if (!consistent) continue;
            HashMap newDomains = new HashMap(domains.size());
            for (Map.Entry<Object, List<Object>> entry : domains.entrySet()) {
                newDomains.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            ((List)newDomains.get(var)).removeIf(o -> o != value);
            boolean bl2 = true;
            for (IConstraint<Object> neighbour : graph.edgesOf(var)) {
                List<Object> scope;
                int otherIndex = (scope = neighbour.scope()).get(0).equals(var) ? 1 : 0;
                Object other = scope.get(otherIndex);
                if (assigned.contains(other)) continue;
                List newDomain = (List)newDomains.get(other);
                Object[] params = new Object[2];
                params[otherIndex == 0 ? 1 : 0] = value;
                if (CSPSolver.reduceDomain(neighbour, newDomain, params, otherIndex)) continue;
                bl = false;
                break;
            }
            if (!bl || !problem.allowedAssign(var, value, newDomains) || (map = CSPSolver.backtrack(problem, newDomains, graph, var)) == null) continue;
            return map;
        }
        return null;
    }
}

