/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.csp;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Multigraph<NODE, EDGE> {
    Set<NODE> vertices = new HashSet<NODE>();
    Set<EDGE> edges = new HashSet<EDGE>();
    Map<NODE, Set<EDGE>> connections = new HashMap<NODE, Set<EDGE>>();
    Map<EDGE, Set<NODE>> edge_conn = new HashMap<EDGE, Set<NODE>>();

    public Set<NODE> vertexSet() {
        return this.vertices;
    }

    public Set<EDGE> edgesOf(NODE n) {
        return this.connections.get(n);
    }

    public Set<EDGE> edgeSet() {
        return this.edges;
    }

    public void removeEdge(EDGE edge1) {
        this.edges.remove(edge1);
        Set<NODE> nodes = this.edge_conn.get(edge1);
        for (NODE n : nodes) {
            this.connections.get(n).remove(edge1);
        }
        this.edge_conn.remove(edge1);
    }

    public void addVertex(NODE n) {
        this.vertices.add(n);
        this.connections.put(n, new HashSet());
    }

    public void addEdge(Collection<NODE> nodes, EDGE nEdge1) {
        for (NODE n : nodes) {
            this.addVertex(n);
            this.connections.get(n).add(nEdge1);
        }
        this.edges.add(nEdge1);
        this.edge_conn.put(nEdge1, new HashSet<NODE>(nodes));
    }

    public boolean containsVertex(NODE node1) {
        return this.vertices.contains(node1);
    }

    public Set<EDGE> getEdges(NODE node1, NODE node2) {
        HashSet<EDGE> edges = new HashSet<EDGE>();
        for (EDGE e1 : this.connections.get(node1)) {
            for (EDGE e2 : this.connections.get(node2)) {
                if (e1 != e2) continue;
                edges.add(e1);
            }
        }
        return edges;
    }
}

