/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms;

import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.framework.FrameworkType;
import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDEdge;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDNode;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.FrameworkParams;
import com.gildedgames.orbis.lib.data.pathway.PathwayData;
import java.util.ArrayList;

public class ComputedParamFac {
    public static final int minVertexSize = 4;
    public static final int maxVertexSize = 50;
    public static final float maxEdgeDensity = 2.8f;
    public static final int minPathwayLength = 3;
    public static final int maxPathwayLength = 340;
    public static float verticesRepulsion = 0.2f;
    public static float edgesRepulsion = 0.2f;
    public static float areaRepulsion = 0.6f;
    public static float verticesStiff = 0.0f;
    public static float edgesStiff = 0.667f;
    public static float areaStiff = 0.333f;
    public static float verticesEscape = 0.0f;
    public static float edgesEscape = 0.0f;
    public static float areaEscape = 1.0f;
    public static float verticesNL = 0.0f;
    public static float edgesNL = 0.0f;
    public static float areaNL = 1.0f;
    public static float verticesC = 0.4f;
    public static float edgesC = 0.4f;
    public static float areaC = 0.2f;
    public static float relNodeDistance = 1.5f;
    public static int fdgdMaxIterations = 2500;
    public static int escapeIterations = 1500;
    public static float toEscapeEquilibrium = 0.45f;
    public static float acceptEquilibrium = 0.7f;
    public static float acceptEquilibriumEsc = 0.8f;
    public static float graphGrowth = 0.5f;
    public static float heuristicWeight = 3.0f;
    public static int pathwaysBoundingBox = 8;
    public float minRepulsion = 0.7f;
    public float maxRepulsion = 0.8f;
    public float minRepulsionMagnitude = 5.8f;
    public float maxRepulsionMagnitude = 7.3f;
    public float minStiffness = 0.06f;
    public float maxStiffness = 0.82f;
    public float minEscape = 1.3f;
    public float maxEscape = 4.0f;
    public float minNaturalLength = 5.0f;
    public float maxNaturalLength = 450.0f;
    public float minC = 0.08f;
    public float maxC = 0.12f;

    public FrameworkParams createParams(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type) {
        float normalizedVertices = this.normalizedVertices(graph);
        float normalizedEdges = this.normalizedEdges(graph);
        float averageLength = this.computeAverageLength(graph, type);
        FrameworkParams params = new FrameworkParams();
        params.repulsion = this.repulsion(normalizedVertices, normalizedEdges, averageLength);
        params.stiffness = this.stiffness(normalizedVertices, normalizedEdges, averageLength);
        params.collisionEscape = this.escape(normalizedVertices, normalizedEdges, averageLength);
        params.naturalLength = this.naturalLength(normalizedVertices, normalizedEdges, averageLength);
        params.c = this.c(normalizedVertices, normalizedEdges, averageLength);
        params.nodeDistance = (int)this.nodeDistance(graph, type);
        params.fdgdMaxIterations = fdgdMaxIterations;
        params.iterationsToEscape = escapeIterations;
        params.toEscapeEquilibrium = toEscapeEquilibrium;
        params.acceptEquilibrium = acceptEquilibrium;
        params.acceptEquilibriumEsc = acceptEquilibriumEsc;
        params.graphGrowth = graphGrowth;
        params.heuristcWeight = heuristicWeight;
        params.pathwaysBoundingBox = pathwaysBoundingBox;
        return params;
    }

    private float normalizedVertices(Graph<FDGDNode, FDGDEdge> graph) {
        return this.normalize(4.0f, 50.0f, graph.vertexSet().size());
    }

    private float normalizedEdges(Graph<FDGDNode, FDGDEdge> graph) {
        int vertexCount = graph.vertexSet().size();
        float edgesAmount = (float)graph.edgeSet().size() / (float)vertexCount;
        return this.normalize(((float)vertexCount - 1.0f) / (float)vertexCount, 2.8f, edgesAmount);
    }

    private float computeAverageLength(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type) {
        int total = 0;
        for (FDGDNode node : graph.vertexSet()) {
            if (type == FrameworkType.CUBES) {
                total += node.getWidth() * node.getHeight() * node.getLength();
                continue;
            }
            total += node.getWidth() * node.getLength();
        }
        float average = (float)total / (float)graph.vertexSet().size();
        float averageEdgeLength = (float)(type == FrameworkType.CUBES ? Math.pow(average, 0.0) : Math.sqrt(average));
        return this.normalize(3.0f, 340.0f, averageEdgeLength);
    }

    private float repulsion(float vertices, float edges, float area) {
        float normed = vertices * verticesRepulsion + edges * edgesRepulsion + area * areaRepulsion;
        return this.valuelize(this.minRepulsion, this.maxRepulsion, normed) * (float)Math.pow(10.0, this.valuelize(this.minRepulsionMagnitude, this.maxRepulsionMagnitude, normed));
    }

    private float stiffness(float vertices, float edges, float area) {
        return this.inverseValuelize(this.minStiffness, this.maxStiffness, vertices * verticesStiff + edges * edgesStiff + area * areaStiff);
    }

    private float naturalLength(float vertices, float edges, float area) {
        return this.valuelize(this.minNaturalLength, this.maxNaturalLength, vertices * verticesNL + edges * edgesNL + area * areaNL);
    }

    private float escape(float vertices, float edges, float area) {
        return this.valuelize(this.minEscape, this.maxEscape, vertices * verticesNL + edges * edgesEscape + area * areaEscape);
    }

    private float c(float vertices, float edges, float area) {
        return this.inverseValuelize(this.minC, this.maxC, vertices * verticesC + edges * edgesC + area * areaC);
    }

    private float nodeDistance(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type) {
        float max = 0.0f;
        ArrayList<PathwayData> checkedPathways = new ArrayList<PathwayData>();
        for (FDGDEdge edge : graph.edgeSet()) {
            PathwayData data = edge.pathway();
            if (checkedPathways.contains(data)) continue;
            checkedPathways.add(data);
            for (BlueprintData blueprint : data.pieces()) {
                max = Math.max(max, (float)blueprint.getWidth());
                max = Math.max(max, (float)blueprint.getLength());
                if (type != FrameworkType.CUBES) continue;
                max = Math.max(max, (float)blueprint.getHeight());
            }
        }
        return relNodeDistance * max;
    }

    private float normalize(float minimum, float maximum, float value) {
        if (value < minimum) {
            return 0.0f;
        }
        if (value > maximum) {
            return 1.0f;
        }
        return (value - minimum) / (maximum - minimum);
    }

    float valuelize(float minimum, float maximum, float normal) {
        if (normal < 0.0f) {
            return minimum;
        }
        if (normal > 1.0f) {
            return maximum;
        }
        return minimum + normal * (maximum - minimum);
    }

    float inverseValuelize(float minimum, float maximum, float normal) {
        if (normal < 0.0f) {
            return maximum;
        }
        if (normal > 1.0f) {
            return minimum;
        }
        return maximum - normal * (maximum - minimum);
    }
}

