/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.data.framework.FrameworkType;
import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDEdge;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDNode;
import com.gildedgames.orbis.lib.data.framework.generation.FDGenUtil;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.ComputedParamFac;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.FrameworkParams;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.IGDAlgorithm;
import com.gildedgames.orbis.lib.data.framework_new.IFrameworkAlgorithm;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.util.RegionHelp;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.MathHelper;

public class DeprecatedFDGD
implements IGDAlgorithm {
    private FrameworkParams params;
    private ComputedParamFac paramFac = new ComputedParamFac();
    private boolean escapePhase = false;

    @Override
    public void initialize(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, Random random) {
        this.params = this.paramFac.createParams(graph, type);
        OrbisLib.LOGGER.info((Object)this.params);
    }

    @Override
    public void step(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, Random random, int iterations) {
        float repulsion = this.params.repulsion();
        float stiffness = this.params.stiffness();
        float naturalLength = this.params.naturalLength();
        int nodeDistance = this.params.nodeDistance();
        float collisionEsc = this.params.collisionEscape();
        float maxForce = 1000.0f;
        float c = this.params.C();
        for (FDGDNode v : graph.vertexSet()) {
            float forceX = 0.0f;
            float forceY = 0.0f;
            float forceZ = 0.0f;
            if (!this.escapePhase) {
                Set<FDGDEdge> adjacentEdges = graph.edgesOf(v);
                for (FDGDEdge edge : adjacentEdges) {
                    float stiffModifier;
                    FDGDNode u = edge.getOpposite(v);
                    float dx = edge.xOf(u) - edge.xOf(v);
                    float dz = edge.zOf(u) - edge.zOf(v);
                    if (type == FrameworkType.RECTANGLES) {
                        float duv = Math.abs(dx) + Math.abs(dz);
                        if (duv == 0.0f) {
                            duv = random.nextBoolean() ? 100.0f : -100.0f;
                        }
                        stiffModifier = stiffness * (duv - naturalLength) / duv;
                    } else {
                        float dy = edge.yOf(u) - edge.yOf(v);
                        float duv = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
                        if (duv == 0.0f) {
                            duv = random.nextBoolean() ? 100.0f : -100.0f;
                        }
                        stiffModifier = stiffness * (duv - naturalLength) / duv;
                        forceY += stiffModifier * dy;
                    }
                    forceX += stiffModifier * dx;
                    forceZ += stiffModifier * dz;
                }
            }
            IRegion rect1 = RegionHelp.expand(v, nodeDistance);
            for (FDGDNode u : graph.vertexSet()) {
                if (u.equals(v)) continue;
                float dx = u.getX() - v.getX();
                float dz = u.getZ() - v.getZ();
                if (type == FrameworkType.RECTANGLES) {
                    float duv = Math.abs(dx) + Math.abs(dz);
                    float trepulsion = repulsion / (float)Math.pow(duv, 3.0);
                    if (this.escapePhase && RegionHelp.intersects2D(rect1, RegionHelp.expand(u, nodeDistance))) continue;
                    if (this.escapePhase) {
                        trepulsion *= collisionEsc;
                    }
                    forceX -= MathHelper.func_76131_a((float)(trepulsion * dx), (float)-1000.0f, (float)1000.0f);
                    forceZ -= MathHelper.func_76131_a((float)(trepulsion * dz), (float)-1000.0f, (float)1000.0f);
                    continue;
                }
                float dy = u.getY() - v.getY();
                float duv = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
                float trepulsion = repulsion / (float)Math.pow(duv, 3.0);
                if (this.escapePhase && RegionHelp.intersects2D(rect1, RegionHelp.expand(u, nodeDistance))) continue;
                if (this.escapePhase) {
                    trepulsion *= collisionEsc;
                }
                forceX -= MathHelper.func_76131_a((float)(trepulsion * dx), (float)-1000.0f, (float)1000.0f);
                forceY -= MathHelper.func_76131_a((float)(trepulsion * dy), (float)-1000.0f, (float)1000.0f);
                forceZ -= MathHelper.func_76131_a((float)(trepulsion * dz), (float)-1000.0f, (float)1000.0f);
            }
            if (Float.isNaN(forceX) || Float.isNaN(forceY) || Float.isNaN(forceZ) || Float.isInfinite(forceX) || Float.isInfinite(forceY) || Float.isInfinite(forceZ)) {
                forceX = 0.0f;
                forceY = 0.0f;
                forceZ = 0.0f;
            }
            v.setForce(forceX * c, forceY * c, forceZ * c);
        }
        graph.vertexSet().forEach(FDGDNode::applyForce);
        graph.edgeSet().forEach(FDGDEdge::applyForce);
    }

    @Override
    public IFrameworkAlgorithm.Phase inEquilibrium(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, int fdgdIterations) {
        if (fdgdIterations < this.params.fdgdMaxIterations()) {
            float equilibriumState = 0.0f;
            for (FDGDNode node : graph.vertexSet()) {
                equilibriumState = Math.max(equilibriumState, FDGenUtil.euclidian(node.getPrevX(), node.getPrevY(), node.getPrevZ(), node.getX(), node.getY(), node.getZ()));
            }
            boolean inEquilibrium = this.escapePhase && equilibriumState < this.params.acceptEquilibriumEsc() || equilibriumState < this.params.acceptEquilibrium();
            this.escapePhase = this.escapePhase || equilibriumState < this.params.toEscapeEquilibrium() || fdgdIterations > this.params.iterationsToEscape();
            return inEquilibrium ? IFrameworkAlgorithm.Phase.PATHWAYS : IFrameworkAlgorithm.Phase.FDGD;
        }
        return IFrameworkAlgorithm.Phase.REBUILD1;
    }

    @Override
    public void resetOnSpiderweb(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, int fdgdIterations) {
    }
}

