/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.core.world_objects.BlueprintRegion;
import com.gildedgames.orbis.lib.data.framework.FrameworkType;
import com.gildedgames.orbis.lib.data.framework.Graph;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDEdge;
import com.gildedgames.orbis.lib.data.framework.generation.FDGDNode;
import com.gildedgames.orbis.lib.data.framework.generation.FDGenUtil;
import com.gildedgames.orbis.lib.data.framework.generation.fdgd_algorithms.IGDAlgorithm;
import com.gildedgames.orbis.lib.data.framework_new.IFrameworkAlgorithm;
import java.util.Random;

public class FruchtermanReingold
implements IGDAlgorithm {
    private static int UN_MAX_ITERATIONS = 70;
    private static int UP_MAX_ITERATIONS = 1500;
    private static int UN_SPIDER_MAX_ITERATIONS = 35;
    private static int UP_SPIDER_MAX_ITERATIONS = 170;
    private static float END_SPEED = 22.0f;
    private static float MIN_START_SPEED = 32.0f;
    private static float MAX_START_SPEED = 805.0f;
    private static float END_SPEED_SPIDER = 20.0f;
    private static float MIN_START_SPEED_SPIDER = 34.0f;
    private static float MAX_START_SPEED_SPIDER = 120.0f;
    private static float ESCAPE_MODIFIER = 1.002f;
    private static float AREA_MODIFIER = 1.2f;
    private static float C = 0.06f;
    private static float BOUNCE_MOD = 1.0f;
    private float cooling;
    private int max_iterations;
    private float area;
    private float k;
    private float s;
    private float W;
    private float L;

    private float fr(float x) {
        return this.k * this.k / x;
    }

    private float fa(float x) {
        return x * x / this.k;
    }

    private float euclid(float dx, float dy, float dz) {
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private void initialParams(Graph<FDGDNode, FDGDEdge> graph) {
        this.W = (float)graph.vertexSet().stream().mapToDouble(BlueprintRegion::getWidth).sum();
        this.L = (float)graph.vertexSet().stream().mapToDouble(BlueprintRegion::getLength).sum();
        this.area = AREA_MODIFIER * this.W * this.L;
        this.k = C * (float)Math.sqrt(this.area / (float)graph.vertexSet().size());
    }

    @Override
    public void initialize(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, Random random) {
        this.initialParams(graph);
        this.s = MIN_START_SPEED + (float)((int)((MAX_START_SPEED - MIN_START_SPEED) / 100.0f * (float)Math.min(100, graph.vertexSet().size())));
        this.max_iterations = UN_MAX_ITERATIONS + (int)((float)(UP_MAX_ITERATIONS - UN_MAX_ITERATIONS) / 150.0f * (float)Math.min(150, graph.vertexSet().size()));
        this.cooling = (float)Math.pow(END_SPEED / this.s, 1.0 / (double)this.max_iterations);
        OrbisLib.LOGGER.info((Object)Float.valueOf(this.cooling));
        OrbisLib.LOGGER.info((Object)this.max_iterations);
        for (FDGDNode u : graph.vertexSet()) {
            u.setPosition(random.nextFloat() * this.W - this.W / 2.0f, 0.0f, random.nextFloat() * this.L - this.L / 2.0f);
        }
    }

    @Override
    public void step(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, Random random, int fdgdIterations) {
        for (FDGDNode v : graph.vertexSet()) {
            v.setForce(0.0f, 0.0f, 0.0f);
            for (FDGDNode u : graph.vertexSet()) {
                float dz;
                if (u == v) continue;
                float[] uPos = FDGenUtil.pointOfForce(v, u);
                float dx = v.getX() - uPos[0];
                float dist = this.euclid(dx, 0.0f, dz = v.getZ() - uPos[2]);
                if (!((double)dist > 0.01)) continue;
                float repr = this.fr(dist) / dist;
                v.addForce(dx * repr, 0.0f, dz * repr);
            }
        }
        for (FDGDEdge e : graph.edgeSet()) {
            float dz;
            float dx = e.node1().getX() - e.node2().getX();
            float dist = this.euclid(dx, 0.0f, dz = e.node1().getZ() - e.node2().getZ());
            if (!((double)dist > 0.01)) continue;
            float atr = this.fa(dist) / dist;
            float fx = dx * atr;
            float fz = dz * atr;
            e.node1().subtrForce(fx, 0.0f, fz);
            e.node2().addForce(fx, 0.0f, fz);
        }
        for (FDGDNode v : graph.vertexSet()) {
            float str_f = this.euclid(v.getForceX(), 0.0f, v.getForceZ());
            if (!(str_f > 0.0f)) continue;
            float prop_f = Math.min(str_f, this.s) / str_f;
            float newX = v.getX() + v.getForceX() * prop_f;
            float newZ = v.getZ() + v.getForceZ() * prop_f;
            float random_border = random.nextFloat() * 0.01f;
            newX = Math.min(this.W / 2.0f + random_border, Math.max(-this.W / 2.0f - random_border, newX));
            newZ = Math.min(this.L / 2.0f + random_border, Math.max(-this.L / 2.0f - random_border, newZ));
            v.setPosition(newX, v.getY(), newZ);
        }
        if (fdgdIterations < this.max_iterations) {
            this.s *= this.cooling;
        }
    }

    @Override
    public IFrameworkAlgorithm.Phase inEquilibrium(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, int fdgdIterations) {
        if (fdgdIterations > this.max_iterations) {
            if (FDGenUtil.hasCollision(graph)) {
                this.k *= ESCAPE_MODIFIER;
            } else {
                OrbisLib.LOGGER.info((Object)Float.valueOf(this.k));
                OrbisLib.LOGGER.info("END OF FDGD");
                return IFrameworkAlgorithm.Phase.PATHWAYS;
            }
        }
        return IFrameworkAlgorithm.Phase.FDGD;
    }

    @Override
    public void resetOnSpiderweb(Graph<FDGDNode, FDGDEdge> graph, FrameworkType type, int fdgdIterations) {
        this.initialParams(graph);
        this.s = MIN_START_SPEED_SPIDER + (float)((int)((MAX_START_SPEED_SPIDER - MIN_START_SPEED_SPIDER) / 100.0f * (float)Math.min(100, graph.vertexSet().size())));
        int addedIterations = UN_SPIDER_MAX_ITERATIONS + (int)((float)(UP_SPIDER_MAX_ITERATIONS - UN_SPIDER_MAX_ITERATIONS) / 150.0f * (float)Math.min(150, graph.vertexSet().size()));
        this.max_iterations = fdgdIterations + addedIterations;
        this.cooling = (float)Math.pow(END_SPEED_SPIDER / this.s, 1.0 / (double)addedIterations);
        OrbisLib.LOGGER.info((Object)Float.valueOf(this.cooling));
        OrbisLib.LOGGER.info((Object)this.max_iterations);
    }
}

