/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.searching;

import com.gildedgames.orbis.lib.core.world_objects.BlueprintRegion;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.framework.generation.searching.ISearchProblem;
import com.gildedgames.orbis.lib.data.framework.generation.searching.PathwayNode;
import com.gildedgames.orbis.lib.data.framework.generation.searching.PathwayUtil;
import com.gildedgames.orbis.lib.data.framework.interfaces.EnumFacingMultiple;
import com.gildedgames.orbis.lib.data.pathway.IEntrance;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PathwayProblem
implements ISearchProblem<PathwayNode> {
    private static final float pathwaysBoundingBox = 8.0f;
    protected final BlockPos start;
    protected final BlockPos end;
    protected final List<BlueprintData> pieces;
    private final Collection<BlueprintRegion> fragments;
    private final IRegion boundingBox;
    private final BlueprintRegion startFragment;
    private double maxLength;
    private boolean hasVerticalEntrances;
    private boolean checkedForVertical;
    private World world;

    public PathwayProblem(World world, BlockPos start, BlueprintRegion startFragment, BlockPos end, List<BlueprintData> pieces, Collection<BlueprintRegion> fragments) {
        this.world = world;
        this.start = start;
        this.end = end;
        this.pieces = pieces;
        for (BlueprintData b : pieces) {
            this.maxLength = Math.max(this.maxLength, (double)(b.getWidth() * b.getWidth() + b.getHeight() + b.getLength() * b.getLength()));
        }
        this.maxLength = Math.sqrt(this.maxLength);
        this.fragments = fragments;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlueprintRegion fragment : fragments) {
            minX = Math.min(minX, fragment.getMin().func_177958_n());
            minY = Math.min(minY, fragment.getMin().func_177956_o());
            minZ = Math.min(minZ, fragment.getMin().func_177952_p());
            maxX = Math.max(maxX, fragment.getMax().func_177958_n());
            maxY = Math.max(maxY, fragment.getMax().func_177956_o());
            maxZ = Math.max(maxZ, fragment.getMax().func_177952_p());
        }
        if (fragments.size() <= 0) {
            minX = Math.min(minX, start.func_177958_n());
            minY = Math.min(minY, start.func_177956_o());
            minZ = Math.min(minZ, start.func_177952_p());
            maxX = Math.max(maxX, end.func_177958_n());
            maxY = Math.max(maxY, end.func_177956_o());
            maxZ = Math.max(maxZ, end.func_177952_p());
        }
        this.startFragment = new BlueprintRegion(startFragment.getMin(), startFragment.getRotation(), startFragment.getData());
        this.boundingBox = RegionHelp.expand(new Region(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ)), (int)(this.maxLength * 8.0));
    }

    public IRegion getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public List<PathwayNode> successors(PathwayNode parentState) {
        ArrayList<PathwayNode> successors = new ArrayList<PathwayNode>();
        IRegion end = parentState.endConnection;
        EnumFacingMultiple lastSide = parentState.sideOfConnection();
        EnumFacingMultiple toConnect = lastSide.getOpposite();
        IRegion adjacentEntrance = PathwayUtil.adjacent(end, lastSide);
        IEntrance lastEntrance = parentState.getNonRotatedEntrance();
        for (BlueprintData blueprint : this.pieces) {
            Region region = new Region(new BlockPos(0, 0, 0), new BlockPos(blueprint.getWidth() - 1, blueprint.getHeight() - 1, blueprint.getLength() - 1));
        }
        return successors;
    }

    @Override
    public List<PathwayNode> viableStarts() {
        ArrayList viable = Lists.newArrayList();
        BlueprintData d = this.startFragment.getData();
        return viable;
    }

    protected boolean isSuccessor(PathwayNode node, PathwayNode parent) {
        if (this.isGoal(node)) {
            return true;
        }
        for (BlockPos.MutableBlockPos pos : node.getShapeData()) {
            if (this.world.func_175623_d((BlockPos)pos)) continue;
            return false;
        }
        return true;
    }

    private boolean hasVerticalEntrances() {
        if (!this.checkedForVertical) {
            this.hasVerticalEntrances = false;
            boolean hasDown = false;
            boolean hasUp = false;
            for (BlueprintData blueprintData : this.pieces) {
            }
            this.checkedForVertical = true;
        }
        return this.hasVerticalEntrances;
    }

    @Override
    public double heuristic(PathwayNode state) {
        if (this.isGoal(state)) {
            // empty if block
        }
        IRegion exit = state.endConnection;
        double h = Math.abs(exit.getMin().func_177958_n() - this.end.func_177958_n()) + Math.abs(exit.getMin().func_177956_o() - this.end.func_177956_o()) + Math.abs(exit.getMin().func_177952_p() - this.end.func_177952_p());
        double ax = exit.getMin().func_177958_n() - this.end.func_177958_n();
        double az = exit.getMin().func_177952_p() - this.end.func_177952_p();
        double bx = this.start.func_177958_n() - this.end.func_177958_n();
        double bz = this.start.func_177952_p() - this.end.func_177952_p();
        double cross = Math.abs(ax * bz - bx * az);
        if (this.hasVerticalEntrances()) {
            double ay = exit.getMin().func_177956_o() - this.end.func_177956_o();
            double d = this.start.func_177956_o() - this.end.func_177956_o();
        }
        return h += cross * 0.001;
    }

    @Override
    public double costBetween(PathwayNode parent, PathwayNode child) {
        IRegion exit = child.endConnection;
        IRegion entrance = parent.endConnection;
        double dx = entrance.getMin().func_177958_n() - exit.getMin().func_177958_n();
        double dz = entrance.getMin().func_177952_p() - exit.getMin().func_177952_p();
        double g = Math.abs(dx) + Math.abs(dz);
        if (this.hasVerticalEntrances()) {
            double dy = entrance.getMin().func_177956_o() - exit.getMin().func_177956_o();
            g += Math.abs(dy);
        }
        return g;
    }

    @Override
    public boolean shouldTerminate(PathwayNode currentState) {
        return !RegionHelp.intersects3D(currentState, this.boundingBox);
    }

    @Override
    public boolean contains(Collection<PathwayNode> visitedStates, PathwayNode currentState) {
        for (PathwayNode visitedState : visitedStates) {
            if (visitedState.parent == currentState.parent || !visitedState.endConnection.equals(currentState.endConnection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGoal(PathwayNode state) {
        if (!this.hasVerticalEntrances()) {
            return RegionHelp.containsIgnoreY(state, this.end);
        }
        return RegionHelp.contains((IRegion)state, this.end);
    }
}

