/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.searching;

import com.gildedgames.orbis.lib.data.framework.interfaces.EnumFacingMultiple;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.RotationHelp;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class PathwayUtil {
    public static EnumFacingMultiple getRotated(EnumFacingMultiple face, Rotation rotation) {
        int rotAmount = RotationHelp.getRotationAmount(rotation, Rotation.NONE);
        boolean goClockwise = RotationHelp.getGoClockwise(rotation, Rotation.NONE);
        if (face == EnumFacingMultiple.DOWN || face == EnumFacingMultiple.UP) {
            return face;
        }
        for (int j = 0; j < rotAmount; ++j) {
            face = goClockwise ? face.rotateY() : face.rotateYCCW();
        }
        return face;
    }

    public static EnumFacingMultiple[] getRotated(EnumFacingMultiple[] faces, Rotation rotation) {
        EnumFacingMultiple[] newFaces = new EnumFacingMultiple[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            newFaces[i] = PathwayUtil.getRotated(faces[i], rotation);
        }
        return newFaces;
    }

    public static EnumFacingMultiple[] getOpposites(EnumFacingMultiple[] faces) {
        EnumFacingMultiple[] opposites = new EnumFacingMultiple[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            opposites[i] = faces[i].getOpposite();
        }
        return opposites;
    }

    public static BlockPos adjacent(BlockPos pos, EnumFacingMultiple facing) {
        return new BlockPos(pos.func_177958_n() + facing.getDirectionVec().func_177958_n(), pos.func_177956_o() + facing.getDirectionVec().func_177956_o(), pos.func_177952_p() + facing.getDirectionVec().func_177952_p());
    }

    public static IRegion adjacent(IRegion region, EnumFacingMultiple facing) {
        BlockPos min = new BlockPos(region.getMin().func_177958_n() + region.getWidth() * facing.getDirectionVec().func_177958_n(), region.getMin().func_177956_o() + region.getHeight() * facing.getDirectionVec().func_177956_o(), region.getMin().func_177952_p() + region.getLength() * facing.getDirectionVec().func_177952_p());
        BlockPos max = min.func_177982_a(region.getWidth() - 1, region.getHeight() - 1, region.getLength() - 1);
        return new Region(min, max);
    }
}

