/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.framework.generation.searching;

import com.gildedgames.orbis.lib.data.framework.generation.searching.AStarNode;
import com.gildedgames.orbis.lib.data.framework.generation.searching.ISearchProblem;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;

public class Searching {
    public static <T extends AStarNode> T aStar(ISearchProblem<T> problem) {
        return Searching.weightedAStar(problem, 1.0);
    }

    public static <T extends AStarNode> T weightedAStar(ISearchProblem<T> problem, double weight) {
        List<T> potentialStarts = problem.viableStarts();
        potentialStarts.sort(Comparator.comparingDouble(problem::heuristic).reversed());
        block0: for (AStarNode initialState : potentialStarts) {
            PriorityQueue<AStarNode> priorityQueue = new PriorityQueue<AStarNode>();
            HashSet<AStarNode> visitedStates = new HashSet<AStarNode>();
            priorityQueue.add(initialState);
            while (!priorityQueue.isEmpty()) {
                AStarNode state = (AStarNode)priorityQueue.poll();
                if (problem.isGoal(state)) {
                    return (T)state;
                }
                if (problem.shouldTerminate(state)) continue block0;
                if (problem.contains(visitedStates, state)) continue;
                visitedStates.add(state);
                for (AStarNode newState : problem.successors(state)) {
                    newState.setG(problem.costBetween(state, newState) + state.getG());
                    newState.setH(weight * problem.heuristic(newState));
                    priorityQueue.add(newState);
                }
            }
        }
        return null;
    }
}

