/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management;

import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IDataLoader;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.IMetadataLoader;
import com.gildedgames.orbis.lib.data.management.IProject;
import com.gildedgames.orbis.lib.data.management.IProjectIdentifier;
import com.gildedgames.orbis.lib.data.management.IProjectManagerListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface IProjectManager {
    public <T extends IProject> Optional<IMetadataLoader<T>> getMetadataLoaderForExtension(String var1);

    public <T extends IProject> Optional<IDataLoader<T>> getDataLoaderForExtension(String var1);

    public Collection<String> getAcceptedExtensions();

    public List<File> getExtraProjectSourceFolders();

    public Supplier<IProject> getProjectFactory();

    public void listen(IProjectManagerListener var1);

    public boolean unlisten(IProjectManagerListener var1);

    public void cacheProject(String var1, IProject var2);

    public File getLocation();

    public void flushProjects();

    public void refreshCache();

    public void scanAndCacheProjects();

    public Collection<IProject> getCachedProjects();

    public boolean projectExists(IProjectIdentifier var1);

    public <T extends IProject> Optional<T> findProject(String var1);

    public <T extends IProject> Optional<T> findProject(IProjectIdentifier var1);

    public <T extends IData> Optional<T> findData(IProject var1, File var2);

    public <T extends IData> Optional<T> findData(IDataIdentifier var1);

    public <T extends IDataMetadata> Optional<T> findMetadata(IDataIdentifier var1);

    public <T extends IProject> T createAndSaveProject(String var1, IProjectIdentifier var2);

    @Nullable
    public <T extends IProject> T saveProjectIfDoesntExist(String var1, IProject var2);

    public boolean projectNameExists(String var1);
}

