/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataCache;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.DataIdentifier;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class DataCache
implements IDataCache {
    private String cacheId;
    private Map<UUID, IData> idToData = Maps.newHashMap();
    private Map<UUID, IDataMetadata> idToMetadata = Maps.newHashMap();
    private int nextId;

    private DataCache() {
    }

    public DataCache(String cacheId) {
        this.cacheId = cacheId;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74778_a("cacheId", this.cacheId);
        tag.func_74768_a("nextId", this.nextId);
        funnel.setMap("idToData", this.idToData, NBTFunnel.UUID_SETTER, NBTFunnel.setter());
        funnel.setMap("idToMetadata", this.idToMetadata, NBTFunnel.UUID_SETTER, NBTFunnel.setter());
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.cacheId = tag.func_74779_i("cacheId");
        this.nextId = tag.func_74762_e("nextId");
        this.idToData = funnel.getMap("idToData", NBTFunnel.UUID_GETTER, NBTFunnel.getter());
        this.idToMetadata = funnel.getMap("idToMetadata", NBTFunnel.UUID_GETTER, NBTFunnel.getter());
        this.idToMetadata.forEach((uuid, metadata) -> {
            IData data = this.idToData.get(uuid);
            if (data != null) {
                data.setMetadata((IDataMetadata)metadata);
            }
        });
    }

    @Override
    public boolean hasData(UUID dataId) {
        return this.idToData.containsKey(dataId);
    }

    @Override
    public Collection<IData> getAllData() {
        return this.idToData.values();
    }

    @Override
    public void clear() {
        this.idToData.clear();
    }

    @Override
    @Nullable
    public <T extends IData> Optional<T> getData(UUID dataId) {
        IData data = this.idToData.get(dataId);
        return Optional.ofNullable(data);
    }

    @Override
    public void removeData(UUID dataId) {
        this.idToData.remove(dataId);
    }

    @Override
    public UUID addData(IData data) {
        UUID id = UUID.randomUUID();
        while (this.idToData.containsKey(id)) {
            id = UUID.randomUUID();
        }
        if (data.getMetadata().getIdentifier() == null) {
            data.getMetadata().setIdentifier(new DataIdentifier(null, id));
        }
        this.setData(id, data);
        return id;
    }

    @Override
    public void setData(UUID dataId, IData data) {
        this.idToData.put(dataId, data);
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }
}

