/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.data.management.IDataCache;
import com.gildedgames.orbis.lib.data.management.IDataCachePool;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FilenameUtils;

public class DataCachePool
implements IDataCachePool {
    public static final String EXTENSION = "cache";
    private final File location;
    private Map<String, IDataCache> idToCache = Maps.newHashMap();

    public DataCachePool(File location) {
        if (!location.exists() && !location.mkdirs()) {
            throw new RuntimeException("Directory for DataCachePool cannot be created!");
        }
        if (!location.isDirectory()) {
            throw new IllegalArgumentException("File passed into DataCachePool is not a directory!");
        }
        this.location = location;
    }

    private void readCacheFromDisk(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)in);
            NBTFunnel funnel = new NBTFunnel(tag);
            IDataCache cache = (IDataCache)funnel.get(EXTENSION);
            this.registerCache(cache);
        }
        catch (IOException e) {
            OrbisLib.LOGGER.catching((Throwable)e);
        }
    }

    private void saveCacheToDisk(IDataCache cache) {
        File cacheFile = new File(this.location, cache.getCacheId() + "." + EXTENSION);
        try (FileOutputStream out = new FileOutputStream(cacheFile);){
            NBTTagCompound tag = new NBTTagCompound();
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set(EXTENSION, cache);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)out);
        }
        catch (IOException e) {
            OrbisLib.LOGGER.error("Failed to save IDataCache to disk", (Throwable)e);
        }
    }

    @Override
    public void flushToDisk() {
        this.idToCache.values().forEach(this::saveCacheToDisk);
    }

    @Override
    public void readFromDisk() {
        try (Stream<Path> paths = Files.walk(Paths.get(this.location.getPath(), new String[0]), new FileVisitOption[0]);){
            paths.forEach(p -> {
                File file = p.toFile();
                String extension = FilenameUtils.getExtension((String)file.getName());
                if (!extension.equals(EXTENSION)) {
                    return;
                }
                this.readCacheFromDisk(file);
            });
        }
        catch (IOException e) {
            OrbisLib.LOGGER.error((Object)e);
        }
    }

    @Override
    public void registerCache(IDataCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("The cache you're trying to register to this DataCachePool is null.");
        }
        this.idToCache.put(cache.getCacheId(), cache);
    }

    @Override
    @Nullable
    public <T extends IDataCache> Optional<T> findCache(String cacheID) {
        IDataCache cache = this.idToCache.get(cacheID);
        if (cache == null) {
            OrbisLib.LOGGER.warn("The cache you attempted to find (" + cacheID + ") could not be found. Something might be wrong.");
            return Optional.empty();
        }
        return Optional.of(cache);
    }

    @Override
    public NBTTagCompound writeCacheData() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setStringMap("idToCache", this.idToCache);
        return tag;
    }

    @Override
    public void readCacheData(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.idToCache = funnel.getStringMap("idToCache");
    }
}

