/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IProjectIdentifier;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DataIdentifier
implements IDataIdentifier {
    @SerializedName(value="dataId")
    private UUID dataId;
    @SerializedName(value="projectIdentifier")
    private IProjectIdentifier projectIdentifier;

    private DataIdentifier() {
    }

    private DataIdentifier(UUID dataId) {
        this.dataId = dataId;
    }

    public DataIdentifier(IProjectIdentifier identifier, UUID dataId) {
        this.projectIdentifier = identifier;
        this.dataId = dataId;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        if (this.dataId != null) {
            tag.func_186854_a("dataId", this.dataId);
        }
        funnel.set("projectIdentifier", this.projectIdentifier);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.dataId = tag.func_186855_b("dataId") ? tag.func_186857_a("dataId") : null;
        this.projectIdentifier = (IProjectIdentifier)funnel.get("projectIdentifier");
    }

    @Override
    public UUID getDataId() {
        return this.dataId;
    }

    @Override
    public IProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IDataIdentifier) {
            IDataIdentifier id = (IDataIdentifier)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getDataId(), (Object)id.getDataId());
            builder.append((Object)this.getProjectIdentifier(), (Object)id.getProjectIdentifier());
            return builder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(3, 7);
        builder.append((Object)this.getDataId());
        builder.append((Object)this.getProjectIdentifier());
        return builder.toHashCode();
    }

    public String toString() {
        return this.dataId + (this.projectIdentifier != null ? ":" + this.projectIdentifier.toString() : "");
    }
}

