/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IProject;
import com.gildedgames.orbis.lib.data.management.impl.OrbisLootTableLoader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrbisLootTableCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new OrbisLootTableLoader.LootPoolSerializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new OrbisLootTableLoader.LootEntrySerializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final LoadingCache<IDataIdentifier, LootTable> registeredLootTables = CacheBuilder.newBuilder().build((CacheLoader)new Loader());

    public OrbisLootTableCache() {
        this.reloadLootTables();
    }

    public LootTable getLootTableFromLocation(IDataIdentifier id) {
        return (LootTable)this.registeredLootTables.getUnchecked((Object)id);
    }

    public void reloadLootTables() {
        this.registeredLootTables.invalidateAll();
    }

    @SideOnly(value=Side.CLIENT)
    public void attachReloadListener() {
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        if (resManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resManager).func_110542_a((IResourceManagerReloadListener)new ReloadListener(this));
        }
    }

    class Loader
    extends CacheLoader<IDataIdentifier, LootTable> {
        private Loader() {
        }

        public LootTable load(IDataIdentifier id) {
            LootTable loottable = this.loadLootTable(id);
            if (loottable == null) {
                loottable = LootTable.field_186464_a;
                LOGGER.warn("Couldn't find resource table {}", (Object)id);
            }
            return loottable;
        }

        @Nullable
        private LootTable loadLootTable(IDataIdentifier id) {
            Optional projectOp = OrbisLib.services().getProjectManager().findProject(id.getProjectIdentifier());
            if (!projectOp.isPresent()) {
                LOGGER.warn("Couldn't load loot table {} from {}", (Object)id);
                return LootTable.field_186464_a;
            }
            IProject project = (IProject)projectOp.get();
            File file = project.getFileForId(id);
            if (file != null) {
                if (file.exists()) {
                    if (file.isFile()) {
                        String s;
                        try {
                            s = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                        }
                        catch (IOException ioexception) {
                            LOGGER.warn("Couldn't load loot table {} from {}", (Object)id, (Object)file, (Object)ioexception);
                            return LootTable.field_186464_a;
                        }
                        try {
                            return OrbisLootTableLoader.loadLootTable(GSON_INSTANCE, id, s, true);
                        }
                        catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                            LOGGER.error("Couldn't load loot table {} from {}", (Object)id, (Object)file, (Object)jsonparseexception);
                            return LootTable.field_186464_a;
                        }
                    }
                    LOGGER.warn("Expected to find loot table {} at {} but it was a folder.", (Object)id, (Object)file);
                    return LootTable.field_186464_a;
                }
            } else {
                String resourceLocation = project.getResourceLocationForId(id);
                if (resourceLocation != null) {
                    String s;
                    URL url = MinecraftServer.class.getResource(resourceLocation);
                    try {
                        s = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException ioexception) {
                        LOGGER.warn("Couldn't load loot table {} from {}", (Object)id, (Object)url, (Object)ioexception);
                        return LootTable.field_186464_a;
                    }
                    try {
                        return OrbisLootTableLoader.loadLootTable(GSON_INSTANCE, id, s, false);
                    }
                    catch (JsonParseException jsonparseexception) {
                        LOGGER.error("Couldn't load loot table {} from {}", (Object)id, (Object)url, (Object)jsonparseexception);
                        return LootTable.field_186464_a;
                    }
                }
            }
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ReloadListener
    implements IResourceManagerReloadListener {
        private final OrbisLootTableCache cache;

        public ReloadListener(OrbisLootTableCache cache) {
            this.cache = cache;
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.cache.reloadLootTables();
        }
    }
}

