/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.ReflectionOrbis;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class OrbisLootTableLoader {
    private static ThreadLocal<Deque<LootTableContext>> lootContext = new ThreadLocal();

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could not grab json context!");
        }
        return ctx;
    }

    @Nullable
    public static LootTable loadLootTable(Gson gson, IDataIdentifier id, String data, boolean custom) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        LootTable ret = null;
        try {
            que.push(new LootTableContext(id, custom));
            ret = (LootTable)gson.fromJson(data, LootTable.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = OrbisLootTableLoader.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("id")) {
            return JsonUtils.func_151200_h((JsonObject)json, (String)"id");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        throw new JsonParseException("Loot Table \"" + ctx.id.toString() + "\" Missing `id` entry for pool #" + (ctx.poolCount - 1));
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = OrbisLootTableLoader.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(JsonUtils.func_151200_h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = JsonUtils.func_151200_h((JsonObject)json, (String)"id");
        } else if ("loot_table".equals(type)) {
            name = JsonUtils.func_151200_h((JsonObject)json, (String)"id");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static LootEntryItem deserializeItem(JsonObject object, JsonDeserializationContext deserializationContext, int weightIn, int qualityIn, LootCondition[] conditionsIn) {
        String name = OrbisLootTableLoader.readLootEntryName(object, "item");
        Item item = JsonUtils.func_188180_i((JsonObject)object, (String)"name");
        LootFunction[] alootfunction = object.has("functions") ? (LootFunction[])JsonUtils.func_188174_a((JsonObject)object, (String)"functions", (JsonDeserializationContext)deserializationContext, LootFunction[].class) : new LootFunction[]{};
        return new LootEntryItem(item, weightIn, qualityIn, alootfunction, conditionsIn, name);
    }

    public static LootEntryTable deserializeTable(JsonObject object, JsonDeserializationContext deserializationContext, int weightIn, int qualityIn, LootCondition[] conditionsIn) {
        String name = OrbisLootTableLoader.readLootEntryName(object, "loot_table");
        ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)object, (String)"name"));
        return new LootEntryTable(resourcelocation, weightIn, qualityIn, conditionsIn, name);
    }

    public static LootEntryEmpty deserializeEmpty(JsonObject object, JsonDeserializationContext deserializationContext, int weightIn, int qualityIn, LootCondition[] conditionsIn) {
        return new LootEntryEmpty(weightIn, qualityIn, conditionsIn, OrbisLootTableLoader.readLootEntryName(object, "empty"));
    }

    public static class LootEntrySerializer
    implements JsonDeserializer<LootEntry>,
    JsonSerializer<LootEntry> {
        public LootEntry deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            LootCondition[] alootcondition;
            int j;
            int i;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"loot item");
            String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
            LootEntry ret = ForgeHooks.deserializeJsonLootEntry((String)s, (JsonObject)jsonobject, (int)(i = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"weight", (int)1)), (int)(j = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"quality", (int)0)), (LootCondition[])(alootcondition = jsonobject.has("conditions") ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"conditions", (JsonDeserializationContext)context, LootCondition[].class) : new LootCondition[]{}));
            if (ret != null) {
                return ret;
            }
            if ("item".equals(s)) {
                return OrbisLootTableLoader.deserializeItem(jsonobject, context, i, j, alootcondition);
            }
            if ("loot_table".equals(s)) {
                return OrbisLootTableLoader.deserializeTable(jsonobject, context, i, j, alootcondition);
            }
            if ("empty".equals(s)) {
                return OrbisLootTableLoader.deserializeEmpty(jsonobject, context, i, j, alootcondition);
            }
            throw new JsonSyntaxException("Unknown loot entry type '" + s + "'");
        }

        public JsonElement serialize(LootEntry entry, Type reflectType, JsonSerializationContext context) {
            String type;
            String entryName = (String)ObfuscationReflectionHelper.getPrivateValue(LootEntry.class, (Object)entry, (String[])ReflectionOrbis.ENTRY_NAME.getMappings());
            int weight = (Integer)ObfuscationReflectionHelper.getPrivateValue(LootEntry.class, (Object)entry, (String[])ReflectionOrbis.WEIGHT.getMappings());
            int quality = (Integer)ObfuscationReflectionHelper.getPrivateValue(LootEntry.class, (Object)entry, (String[])ReflectionOrbis.QUALITY.getMappings());
            LootCondition[] conditions = (LootCondition[])ObfuscationReflectionHelper.getPrivateValue(LootEntry.class, (Object)entry, (String[])ReflectionOrbis.CONDITIONS.getMappings());
            JsonObject jsonobject = new JsonObject();
            if (entryName != null && !entryName.startsWith("custom#")) {
                jsonobject.addProperty("entryName", entryName);
            }
            jsonobject.addProperty("weight", (Number)weight);
            jsonobject.addProperty("quality", (Number)quality);
            if (conditions.length > 0) {
                jsonobject.add("conditions", context.serialize((Object)conditions));
            }
            if ((type = ForgeHooks.getLootEntryType((LootEntry)entry)) != null) {
                jsonobject.addProperty("type", type);
            } else if (entry instanceof LootEntryItem) {
                jsonobject.addProperty("type", "item");
            } else if (entry instanceof LootEntryTable) {
                jsonobject.addProperty("type", "loot_table");
            } else {
                if (!(entry instanceof LootEntryEmpty)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + entry);
                }
                jsonobject.addProperty("type", "empty");
            }
            ReflectionOrbis.invokeMethod(ReflectionOrbis.SERIALIZE, entry, jsonobject, context);
            return jsonobject;
        }
    }

    public static class LootPoolSerializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"loot pool");
            String name = OrbisLootTableLoader.readPoolName(jsonobject);
            LootEntry[] alootentry = (LootEntry[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)context, LootEntry[].class);
            LootCondition[] alootcondition = (LootCondition[])JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"conditions", (Object)new LootCondition[0], (JsonDeserializationContext)context, LootCondition[].class);
            RandomValueRange randomvaluerange = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"rolls", (JsonDeserializationContext)context, RandomValueRange.class);
            RandomValueRange randomvaluerange1 = (RandomValueRange)JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"bonus_rolls", (Object)new RandomValueRange(0.0f, 0.0f), (JsonDeserializationContext)context, RandomValueRange.class);
            return new LootPool(alootentry, alootcondition, randomvaluerange, randomvaluerange1, name);
        }

        public JsonElement serialize(LootPool pool, Type type, JsonSerializationContext context) {
            List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])ReflectionOrbis.LOOT_ENTRIES.getMappings());
            List poolConditions = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])ReflectionOrbis.POOL_CONDITIONS.getMappings());
            RandomValueRange rolls = (RandomValueRange)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])ReflectionOrbis.ROLLS.getMappings());
            RandomValueRange bonusRolls = (RandomValueRange)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])ReflectionOrbis.BONUS_ROLLS.getMappings());
            String name = (String)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])ReflectionOrbis.NAME.getMappings());
            JsonObject jsonobject = new JsonObject();
            if (name != null && !name.startsWith("custom#")) {
                jsonobject.add("name", context.serialize((Object)name));
            }
            jsonobject.add("entries", context.serialize((Object)lootEntries));
            jsonobject.add("rolls", context.serialize((Object)rolls));
            if (bonusRolls.func_186509_a() != 0.0f && bonusRolls.func_186512_b() != 0.0f) {
                jsonobject.add("bonus_rolls", context.serialize((Object)bonusRolls));
            }
            if (!poolConditions.isEmpty()) {
                jsonobject.add("conditions", context.serialize((Object)poolConditions));
            }
            return jsonobject;
        }
    }

    private static class LootTableContext {
        public final IDataIdentifier id;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(IDataIdentifier id, boolean custom) {
            this.id = id;
            this.custom = custom;
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            throw new JsonParseException("Loot Table \"" + this.id.toString() + "\" Duplicate entry id \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
        }
    }
}

