/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.IProject;
import com.gildedgames.orbis.lib.data.management.IProjectCache;
import com.gildedgames.orbis.lib.data.management.IProjectFilesystem;
import com.gildedgames.orbis.lib.data.management.IProjectListener;
import com.gildedgames.orbis.lib.data.management.impl.DataMetadata;
import com.gildedgames.orbis.lib.data.management.impl.OrbisProjectCache;
import com.gildedgames.orbis.lib.data.management.impl.ProjectFilesystemClasspath;
import com.gildedgames.orbis.lib.data.management.impl.ProjectFilesystemLocal;
import com.gildedgames.orbis.lib.data.management.impl.ProjectInformation;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FilenameUtils;

public class OrbisProject
implements IProject {
    private final List<IProjectListener> listeners = Lists.newArrayList();
    private final Map<IDataIdentifier, String> idToResourceLocation = Maps.newHashMap();
    private final Map<IDataIdentifier, File> idToFile = Maps.newHashMap();
    private IProjectCache cache;
    private URI jarLocation;
    private File locationFile;
    private Object mod;
    private String archiveBaseName;
    private boolean isModProject;
    private ProjectInformation info;
    private IProjectFilesystem filesystem = new ProjectFilesystemClasspath();

    public OrbisProject() {
        this.cache = new OrbisProjectCache(this);
    }

    private OrbisProject(File location) {
        this();
        this.jarLocation = location.toURI();
        this.locationFile = location;
    }

    public OrbisProject(File location, ProjectInformation info) {
        this();
        if (!location.exists() && !location.mkdirs()) {
            throw new RuntimeException("Location for OrbisProject cannot be created!");
        }
        if (!location.isDirectory()) {
            throw new IllegalArgumentException("Location file passed into OrbisProject is not a directory!");
        }
        this.jarLocation = location.toURI();
        this.locationFile = location;
        this.info = info;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("info", this.info);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.info = (ProjectInformation)funnel.get("info");
    }

    @Override
    public String getResourceLocationForId(IDataIdentifier id) {
        return this.idToResourceLocation.get(id);
    }

    @Override
    public File getFileForId(IDataIdentifier id) {
        return this.idToFile.get(id);
    }

    @Override
    public boolean isModProject() {
        return this.isModProject;
    }

    @Override
    public void setIsModProject(boolean flag) {
        this.isModProject = flag;
    }

    @Override
    @Nullable
    public File getLocationAsFile() {
        return this.locationFile;
    }

    @Override
    public void setLocationAsFile(File location) {
        this.locationFile = location;
        if (location != null) {
            this.filesystem = new ProjectFilesystemLocal();
        }
    }

    @Override
    public URI getJarLocation() {
        return this.jarLocation;
    }

    @Override
    public void setJarLocation(URI uri) {
        this.jarLocation = uri;
    }

    @Override
    public void addListener(IProjectListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IProjectListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public ProjectInformation getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(ProjectInformation info) {
        this.info = info;
    }

    @Override
    public IProjectCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(IProjectCache cache) {
        cache.setProject(this);
        this.cache = cache;
    }

    private void writeMetadata(IData data, File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        Optional loader = OrbisLib.services().getProjectManager().getMetadataLoaderForExtension(extension);
        if (loader.isPresent()) {
            File metaFile = new File(FilenameUtils.removeExtension((String)file.getPath()) + ".metadata");
            try (FileOutputStream out = new FileOutputStream(metaFile);){
                loader.get().saveMetadata(this, data, out);
            }
            catch (IOException e) {
                OrbisLib.LOGGER.error("Failed to save data metadata to disk", (Throwable)e);
            }
        }
    }

    @Override
    public void writeData(IData data, File file) {
        String extension = FilenameUtils.getExtension((String)file.getPath());
        this.writeMetadata(data, file);
        Optional dataLoader = OrbisLib.services().getProjectManager().getDataLoaderForExtension(extension);
        if (dataLoader.isPresent()) {
            try (FileOutputStream stream = new FileOutputStream(file);){
                dataLoader.get().saveData(this, data, file, stream);
            }
            catch (IOException e) {
                OrbisLib.LOGGER.error("Failed to write data to project directory", (Object)data, (Object)e);
            }
        }
    }

    @Override
    public void loadData(IData data, File file, String location) {
        boolean shouldSaveAfter;
        IDataIdentifier before = data.getMetadata().getIdentifier();
        this.cache.setData(data, location);
        boolean bl = shouldSaveAfter = !data.getMetadata().getIdentifier().equals(before);
        if (this.isModProject && shouldSaveAfter) {
            OrbisLib.LOGGER.error("WARNING: A mod data file (" + data.getMetadata() + ") has a different identifier assigned after loading (Old identifier: " + before + "). This usually means the original identifier has a null UUID data id or the identifier itself is null. Please reimport this data into your project OUTSIDE of the development workspace and let it assign itself the correct metadata.");
        } else if (this.locationFile != null && shouldSaveAfter) {
            this.writeMetadata(data, file);
        }
    }

    @Override
    public boolean findAndLoadData(IDataIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("Identifier should not be null when trying to find and load data!");
        }
        boolean[] found = new boolean[]{false};
        this.walkDataLoading((input, metadataInput, file, location) -> {
            Optional dataLoader;
            if (!this.cache.getDataId(location).isPresent()) {
                return;
            }
            String extension = FilenameUtils.getExtension((String)location);
            Optional metadataLoader = OrbisLib.services().getProjectManager().getMetadataLoaderForExtension(extension);
            if (!metadataLoader.isPresent()) {
                return;
            }
            InputStream metaInput = (InputStream)metadataInput.get();
            if (metaInput == null) {
                return;
            }
            IDataMetadata metadata = metadataLoader.get().loadMetadata(this, metaInput);
            if (metadata != null && id.equals(metadata.getIdentifier()) && (dataLoader = OrbisLib.services().getProjectManager().getDataLoaderForExtension(extension)).isPresent()) {
                IData data = dataLoader.get().loadData(this, file, input);
                data.setMetadata(metadata);
                found[0] = true;
                this.loadData(data, file, location);
                if (file != null) {
                    this.idToFile.put(data.getMetadata().getIdentifier(), file);
                } else {
                    this.idToResourceLocation.put(data.getMetadata().getIdentifier(), location);
                }
            }
        });
        return found[0];
    }

    @Override
    public void setModAndArchiveLoadingFrom(Object mod, String archiveBaseName) {
        this.mod = mod;
        this.archiveBaseName = archiveBaseName;
    }

    private void walkDataLoading(ProjectDataWalker dataWalker) {
        List fileList;
        Object writer2;
        File classpathFile;
        String locationRoot = this.locationFile != null ? this.locationFile.getAbsolutePath() + File.separator : this.jarLocation.getPath();
        URL classpathURL = this.mod.getClass().getClassLoader().getResource("");
        File classpathDir = null;
        if (classpathURL != null && (classpathFile = new File(classpathURL.getPath(), locationRoot)).isDirectory()) {
            classpathDir = classpathFile;
        }
        if (!this.isModProject && this.locationFile != null) {
            File projectIndex = new File(locationRoot, "project_index.txt");
            if (projectIndex.exists()) {
                projectIndex.delete();
            }
            try {
                FileOutputStream stream = new FileOutputStream(projectIndex);
                Object object = null;
                try {
                    writer2 = new BufferedWriter(new OutputStreamWriter(stream));
                    Throwable throwable = null;
                    try {
                        Files.find(this.locationFile.toPath(), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && !FilenameUtils.getName((String)filePath.toString()).equals("project_data.json") && OrbisLib.services().getProjectManager().getAcceptedExtensions().contains(FilenameUtils.getExtension((String)filePath.toString())), new FileVisitOption[0]).forEach(arg_0 -> OrbisProject.lambda$walkDataLoading$2(locationRoot, (BufferedWriter)writer2, arg_0));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer2 != null) {
                            if (throwable != null) {
                                try {
                                    ((BufferedWriter)writer2).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((BufferedWriter)writer2).close();
                            }
                        }
                    }
                }
                catch (Throwable writer2) {
                    object = writer2;
                    throw writer2;
                }
                finally {
                    if (stream != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)stream).close();
                            }
                            catch (Throwable writer2) {
                                ((Throwable)object).addSuppressed(writer2);
                            }
                        } else {
                            ((OutputStream)stream).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read project file index", e);
            }
        }
        String projectIndex = locationRoot + "project_index.txt";
        try {
            InputStream stream = this.filesystem.getInputStream(projectIndex);
            writer2 = null;
            try {
                if (stream == null) {
                    throw new RuntimeException("Project file index does not exist: " + projectIndex);
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                    fileList = reader.lines().filter(line -> !line.startsWith("#")).collect(Collectors.toList());
                }
            }
            catch (Throwable reader) {
                writer2 = reader;
                throw reader;
            }
            finally {
                if (stream != null) {
                    if (writer2 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable reader) {
                            ((Throwable)writer2).addSuppressed(reader);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read project file index", e);
        }
        for (String filePath2 : fileList) {
            String fullPath = locationRoot + filePath2;
            try {
                InputStream stream = this.filesystem.getInputStream(fullPath);
                Throwable throwable = null;
                try {
                    if (stream == null) {
                        OrbisLib.LOGGER.warn("File in project index does not exist: " + fullPath);
                        continue;
                    }
                    String name = fullPath.replace(locationRoot, "");
                    File file = classpathDir != null ? new File(classpathDir, fullPath) : new File(fullPath);
                    dataWalker.walk(stream, () -> this.filesystem.getInputStream(FilenameUtils.removeExtension((String)fullPath) + ".metadata"), file, name);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to iterate project files", e);
            }
        }
    }

    @Override
    public void loadAndCacheData() {
        this.walkDataLoading((input, metadataInput, file, location) -> {
            String extension = FilenameUtils.getExtension((String)location);
            Optional dataLoader = OrbisLib.services().getProjectManager().getDataLoaderForExtension(extension);
            Optional metadataLoader = OrbisLib.services().getProjectManager().getMetadataLoaderForExtension(extension);
            if (!dataLoader.isPresent() || !metadataLoader.isPresent()) {
                return;
            }
            IData data = dataLoader.get().loadData(this, file, input);
            if (data != null && !this.cache.getDataId(location).isPresent()) {
                InputStream metaInput = (InputStream)metadataInput.get();
                IDataMetadata metadata = null;
                if (metaInput == null) {
                    if (!this.isModProject) {
                        metadata = new DataMetadata();
                        metadata.setName(file.getName().replace("." + extension, ""));
                        metadata.setIdentifier(this.cache.createNextIdentifier());
                        File metaFile = new File(file.getPath().replace("." + extension, ".metadata"));
                        try (FileOutputStream out = new FileOutputStream(metaFile);){
                            metadataLoader.get().saveMetadata(this, data, out);
                        }
                        catch (IOException e) {
                            OrbisLib.LOGGER.error("Failed to save metadata for data file", (Throwable)e);
                        }
                    } else {
                        OrbisLib.LOGGER.error("WARNING: A data file in your mod project (" + this.getInfo().getIdentifier() + ") doesn't have a metadata file, meaning it will not work. This can be auto-generated outside of a dev workspace if you simply load up the project.");
                    }
                } else {
                    metadata = metadataLoader.get().loadMetadata(this, metaInput);
                }
                if (metadata == null) {
                    OrbisLib.LOGGER.error("WARNING: A data file could not load because there was no associate metadata file with it.");
                    return;
                }
                data.setMetadata(metadata);
                this.loadData(data, file, location);
                if (file != null) {
                    this.idToFile.put(data.getMetadata().getIdentifier(), file);
                } else {
                    this.idToResourceLocation.put(data.getMetadata().getIdentifier(), location);
                }
            } else {
                OrbisLib.LOGGER.error("Failed to load back a data file from project.", (Object)location);
            }
        });
    }

    @Override
    public boolean areModDependenciesMet() {
        return true;
    }

    private static /* synthetic */ void lambda$walkDataLoading$2(String locationRoot, BufferedWriter writer, Path path) {
        try {
            String name = path.toAbsolutePath().toString().replace(locationRoot, "");
            writer.write(name);
            writer.newLine();
        }
        catch (IOException e) {
            OrbisLib.LOGGER.info((Object)e);
        }
    }

    private static interface ProjectDataWalker {
        public void walk(InputStream var1, Supplier<InputStream> var2, File var3, String var4) throws IOException;
    }
}

