/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.data.json.JsonData;
import com.gildedgames.orbis.lib.data.management.IData;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.management.IDataLoader;
import com.gildedgames.orbis.lib.data.management.IDataMetadata;
import com.gildedgames.orbis.lib.data.management.IMetadataLoader;
import com.gildedgames.orbis.lib.data.management.IProject;
import com.gildedgames.orbis.lib.data.management.IProjectIdentifier;
import com.gildedgames.orbis.lib.data.management.IProjectManager;
import com.gildedgames.orbis.lib.data.management.IProjectManagerListener;
import com.gildedgames.orbis.lib.data.management.impl.OrbisProject;
import com.gildedgames.orbis.lib.data.management.impl.ProjectInformation;
import com.gildedgames.orbis.lib.data.management.impl.ProjectMetadata;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.FileHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class OrbisProjectManager
implements IProjectManager {
    private final File baseDirectory;
    private final Map<IProjectIdentifier, IProject> idToProject = Maps.newHashMap();
    private final Map<String, IProject> nameToProject = Maps.newHashMap();
    private final Map<String, IDataLoader<OrbisProject>> extensionToDataLoader = Maps.newHashMap();
    private final Map<String, IMetadataLoader<OrbisProject>> extensionToMetadataLoader = Maps.newHashMap();
    private Object mod;
    private String archiveBaseName;
    private Set<IProjectManagerListener> listeners = Sets.newHashSet();
    private Supplier<IProject> projectFactory;
    private List<File> extraProjectSources;

    public OrbisProjectManager(File baseDirectory, List<File> extraProjectSources, Object mod, String archiveBaseName, Supplier<IProject> projectFactory) {
        if (!baseDirectory.exists() && !baseDirectory.mkdirs()) {
            throw new RuntimeException("Base directory for OrbisProjectManager cannot be created!");
        }
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("File passed into OrbisProjectManager is not a directory!");
        }
        this.extraProjectSources = extraProjectSources;
        this.baseDirectory = baseDirectory;
        this.mod = mod;
        this.archiveBaseName = archiveBaseName;
        this.projectFactory = projectFactory;
        IDataLoader<OrbisProject> nbtDataLoader = new IDataLoader<OrbisProject>(){

            @Override
            public void saveData(OrbisProject project, IData data, File file, OutputStream output) {
                try {
                    NBTTagCompound tag = new NBTTagCompound();
                    NBTFunnel funnel = new NBTFunnel(tag);
                    funnel.set("data", data);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)output);
                }
                catch (IOException e) {
                    OrbisLib.LOGGER.error("Failed to save project data to disk", (Throwable)e);
                }
            }

            @Override
            public IData loadData(OrbisProject project, File file, InputStream input) {
                try {
                    NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)input);
                    NBTFunnel funnel = new NBTFunnel(tag);
                    IData data = (IData)funnel.get("data");
                    tag = funnel.getTag().func_74775_l("data").func_74775_l("data");
                    data.read(tag);
                    return data;
                }
                catch (IOException e) {
                    OrbisLib.LOGGER.error("Failed to load project data from disk", (Throwable)e);
                    return null;
                }
            }
        };
        IDataLoader<OrbisProject> jsonDataLoader = new IDataLoader<OrbisProject>(){

            @Override
            public void saveData(OrbisProject project, IData data, File file, OutputStream output) {
            }

            @Override
            public IData loadData(OrbisProject project, File file, InputStream input) {
                return new JsonData();
            }
        };
        this.extensionToDataLoader.put("blueprint", nbtDataLoader);
        this.extensionToDataLoader.put("framework", nbtDataLoader);
        this.extensionToDataLoader.put("blueprintstacker", nbtDataLoader);
        this.extensionToDataLoader.put("json", jsonDataLoader);
        IMetadataLoader<OrbisProject> jsonMetadataLoader = new IMetadataLoader<OrbisProject>(){

            @Override
            public void saveMetadata(OrbisProject project, IData data, OutputStream outputStream) {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                    try {
                        OrbisLib.services().getGson().toJson((Object)data.getMetadata(), (Appendable)writer);
                    }
                    catch (JsonIOException e) {
                        OrbisLib.LOGGER.error("Failed to save data metadata to json file", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    OrbisLib.LOGGER.error("Failed to save data metadata to disk", (Throwable)e);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IDataMetadata loadMetadata(OrbisProject project, InputStream input) {
                try {
                    Throwable throwable = null;
                    try (InputStreamReader reader = new InputStreamReader(input);){
                        IDataMetadata iDataMetadata = (IDataMetadata)OrbisLib.services().getGson().fromJson((Reader)reader, IDataMetadata.class);
                        return iDataMetadata;
                    }
                    catch (JsonIOException | JsonSyntaxException e) {
                        OrbisLib.LOGGER.error("Failed to load data metadata from json file", e);
                        return null;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    OrbisLib.LOGGER.error("Failed to load data metadata from disk", (Throwable)e);
                }
                return null;
            }
        };
        this.extensionToMetadataLoader.put("blueprint", jsonMetadataLoader);
        this.extensionToMetadataLoader.put("framework", jsonMetadataLoader);
        this.extensionToMetadataLoader.put("blueprintstacker", jsonMetadataLoader);
        this.extensionToMetadataLoader.put("json", jsonMetadataLoader);
    }

    public static boolean isProjectDirectory(File file) {
        File[] innerFiles = file.listFiles();
        if (innerFiles != null) {
            for (File innerFile : innerFiles) {
                if (innerFile == null || innerFile.isDirectory() || !innerFile.getName().equals("project_data.json")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends IProject> Optional<IMetadataLoader<T>> getMetadataLoaderForExtension(String extension) {
        return Optional.ofNullable(this.extensionToMetadataLoader.get(extension));
    }

    @Override
    public <T extends IProject> Optional<IDataLoader<T>> getDataLoaderForExtension(String extension) {
        return Optional.ofNullable(this.extensionToDataLoader.get(extension));
    }

    @Override
    public Collection<String> getAcceptedExtensions() {
        return this.extensionToDataLoader.keySet();
    }

    @Override
    public List<File> getExtraProjectSourceFolders() {
        return this.extraProjectSources;
    }

    @Override
    public Supplier<IProject> getProjectFactory() {
        return this.projectFactory;
    }

    @Override
    public void listen(IProjectManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unlisten(IProjectManagerListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void cacheProject(String folderName, IProject project) {
        this.nameToProject.put(folderName, project);
        this.idToProject.put(project.getInfo().getIdentifier(), project);
    }

    @Override
    public File getLocation() {
        return this.baseDirectory;
    }

    @Override
    public void flushProjects() {
        this.idToProject.values().forEach(project -> {
            if (!project.isModProject()) {
                this.saveProjectToDisk((IProject)project);
            }
        });
    }

    private void walkProjects(ProjectWalker walker) {
        ArrayList directories = Lists.newArrayList((Object[])new File[]{this.baseDirectory});
        directories.addAll(this.extraProjectSources);
        for (int i = 0; i < directories.size(); ++i) {
            File directory = (File)directories.get(i);
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                File[] innerFiles;
                if (file == null || !file.isDirectory() || (innerFiles = file.listFiles()) == null) continue;
                for (File innerFile : innerFiles) {
                    if (innerFile == null || innerFile.isDirectory() || !innerFile.getName().equals("project_data.json")) continue;
                    walker.accept(innerFile, file, i > 0);
                }
            }
        }
    }

    @Override
    public void refreshCache() {
        ArrayList foundProjects = Lists.newArrayList();
        this.walkProjects((innerFile, file, isExtraSourceProject) -> {
            try (FileInputStream in = new FileInputStream(innerFile);){
                ProjectInformation info;
                Throwable throwable;
                InputStreamReader reader;
                block37: {
                    block38: {
                        block39: {
                            reader = new InputStreamReader(in);
                            throwable = null;
                            info = (ProjectInformation)OrbisLib.services().getGson().fromJson((Reader)reader, ProjectInformation.class);
                            if (info != null) break block37;
                            OrbisLib.LOGGER.error("Failed to load project info from json file", (Object)innerFile);
                            if (reader == null) break block38;
                            if (throwable == null) break block39;
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block38;
                        }
                        reader.close();
                    }
                    return;
                }
                try {
                    try {
                        foundProjects.add(info.getIdentifier());
                        if (!this.idToProject.keySet().contains(info.getIdentifier())) {
                            IProject project = this.projectFactory.get();
                            project.setInfo(info);
                            project.setModAndArchiveLoadingFrom(this.mod, this.archiveBaseName);
                            project.setLocationAsFile(file);
                            project.loadAndCacheData();
                            this.cacheProject(file.getName(), project);
                        } else if (isExtraSourceProject) {
                            IProject project = this.idToProject.get(info.getIdentifier());
                            project.setLocationAsFile(file);
                        }
                    }
                    catch (JsonIOException | JsonSyntaxException e) {
                        OrbisLib.LOGGER.error("Failed to load project info from json file", e);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                OrbisLib.LOGGER.catching((Throwable)e);
            }
        });
        ArrayList projectsToRemove = Lists.newArrayList();
        this.idToProject.forEach((id, p) -> {
            if (!foundProjects.contains(id) && !p.isModProject()) {
                projectsToRemove.add(id);
            }
        });
        projectsToRemove.forEach(this.idToProject::remove);
    }

    @Override
    public void scanAndCacheProjects() {
        this.walkProjects((innerFile, file, isExtraSourceProject) -> {
            try {
                FileInputStream in = new FileInputStream(innerFile);
                Throwable throwable = null;
                try {
                    ProjectInformation info;
                    Throwable throwable2;
                    InputStreamReader reader;
                    block36: {
                        block37: {
                            block38: {
                                reader = new InputStreamReader(in);
                                throwable2 = null;
                                info = (ProjectInformation)OrbisLib.services().getGson().fromJson((Reader)reader, ProjectInformation.class);
                                if (!this.idToProject.containsKey(info.getIdentifier())) break block36;
                                if (isExtraSourceProject) {
                                    IProject project = this.idToProject.get(info.getIdentifier());
                                    project.setLocationAsFile(file);
                                } else {
                                    OrbisLib.LOGGER.error("WARNING: A project (" + info.getIdentifier() + ") has not been loaded since it has the same id as another existing project.");
                                }
                                if (reader == null) break block37;
                                if (throwable2 == null) break block38;
                                try {
                                    reader.close();
                                }
                                catch (Throwable project) {
                                    throwable2.addSuppressed(project);
                                }
                                break block37;
                            }
                            reader.close();
                        }
                        if (in == null) return;
                        if (throwable != null) {
                            try {
                                in.close();
                                return;
                            }
                            catch (Throwable project) {
                                throwable.addSuppressed(project);
                                return;
                            }
                        }
                        in.close();
                        return;
                    }
                    try {
                        try {
                            try {
                                IProject project = this.projectFactory.get();
                                project.setInfo(info);
                                project.setLocationAsFile(file);
                                this.cacheProject(file.getName(), project);
                                project.setModAndArchiveLoadingFrom(this.mod, this.archiveBaseName);
                                project.loadAndCacheData();
                                return;
                            }
                            catch (JsonIOException | JsonSyntaxException e) {
                                OrbisLib.LOGGER.error("Failed to load project info from json file", e);
                                return;
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                        finally {
                            if (reader != null) {
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        OrbisLib.LOGGER.catching((Throwable)e);
                        return;
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    throw throwable7;
                }
            }
            catch (IOException e) {
                OrbisLib.LOGGER.error("Scanning and caching projects failed:", (Throwable)e);
            }
        });
    }

    @Override
    public Collection<IProject> getCachedProjects() {
        return this.idToProject.values();
    }

    private boolean findAndLoadProject(String folderName) {
        boolean[] flag = new boolean[1];
        this.walkProjects((innerFile, file, isExtraSourceProject) -> {
            try (FileInputStream in = new FileInputStream(innerFile);
                 InputStreamReader reader = new InputStreamReader(in);){
                try {
                    ProjectInformation info = (ProjectInformation)OrbisLib.services().getGson().fromJson((Reader)reader, ProjectInformation.class);
                    IProject project = this.projectFactory.get();
                    project.setInfo(info);
                    if (file.getParent().equals(folderName)) {
                        project.setLocationAsFile(file);
                        this.cacheProject(file.getName(), project);
                        project.setModAndArchiveLoadingFrom(this.mod, this.archiveBaseName);
                        project.loadAndCacheData();
                        flag[0] = true;
                    }
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    OrbisLib.LOGGER.error("Failed to load project info from json file", e);
                }
            }
            catch (IOException e) {
                OrbisLib.LOGGER.catching((Throwable)e);
            }
        });
        return flag[0];
    }

    private boolean findAndLoadProject(IProjectIdentifier identifier) {
        boolean[] flag = new boolean[1];
        this.walkProjects((innerFile, file, isExtraProjectSource) -> {
            try (FileInputStream in = new FileInputStream(innerFile);
                 InputStreamReader reader = new InputStreamReader(in);){
                try {
                    ProjectInformation info = (ProjectInformation)OrbisLib.services().getGson().fromJson((Reader)reader, ProjectInformation.class);
                    if (info.getIdentifier().equals(identifier)) {
                        IProject project = this.projectFactory.get();
                        project.setInfo(info);
                        project.setLocationAsFile(file);
                        this.cacheProject(file.getName(), project);
                        project.setModAndArchiveLoadingFrom(this.mod, this.archiveBaseName);
                        project.loadAndCacheData();
                        flag[0] = true;
                    }
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    OrbisLib.LOGGER.error("Failed to load project info from json file", e);
                }
            }
            catch (IOException e) {
                OrbisLib.LOGGER.catching((Throwable)e);
            }
        });
        return flag[0];
    }

    @Override
    public <T extends IProject> Optional<T> findProject(String folderName) {
        IProject project = this.nameToProject.get(folderName);
        if (project == null) {
            if (this.findAndLoadProject(folderName)) {
                return Optional.of(this.nameToProject.get(folderName));
            }
            return Optional.empty();
        }
        return Optional.of(project);
    }

    @Override
    public <T extends IProject> Optional<T> findProject(IProjectIdentifier identifier) {
        IProject project = this.idToProject.get(identifier);
        if (project == null) {
            if (this.findAndLoadProject(identifier)) {
                return Optional.of(this.idToProject.get(identifier));
            }
            return Optional.empty();
        }
        return Optional.of(project);
    }

    @Override
    public <T extends IData> Optional<T> findData(IProject project, File file) {
        try {
            boolean isInProject = file.getCanonicalPath().startsWith(project.getLocationAsFile().getCanonicalPath() + File.separator);
            if (isInProject) {
                String dataLocation = file.getCanonicalPath().replace(project.getLocationAsFile().getCanonicalPath() + File.separator, "");
                Optional<UUID> dataId = project.getCache().getDataId(dataLocation);
                if (dataId.isPresent()) {
                    return project.getCache().getData(dataId.get());
                }
            }
        }
        catch (IOException e) {
            OrbisLib.LOGGER.error((Object)e);
        }
        return Optional.empty();
    }

    @Override
    public <T extends IData> Optional<T> findData(IDataIdentifier identifier) {
        Optional<T> projectOp = this.findProject(identifier.getProjectIdentifier());
        if (!projectOp.isPresent()) {
            return Optional.empty();
        }
        IProject project = (IProject)projectOp.get();
        Optional data = project.getCache().getData(identifier.getDataId());
        if (!data.isPresent()) {
            if (project.findAndLoadData(identifier)) {
                return project.getCache().getData(identifier.getDataId());
            }
            return Optional.empty();
        }
        return data;
    }

    @Override
    public <T extends IDataMetadata> Optional<T> findMetadata(IDataIdentifier identifier) {
        Optional<T> projectOp = this.findProject(identifier.getProjectIdentifier());
        if (!projectOp.isPresent()) {
            return Optional.empty();
        }
        IProject project = (IProject)projectOp.get();
        Optional<IDataMetadata> metadata = project.getCache().getMetadata(identifier.getDataId());
        if (!metadata.isPresent()) {
            return Optional.empty();
        }
        return metadata;
    }

    @Override
    public <T extends IProject> T createAndSaveProject(String name, IProjectIdentifier identifier) {
        File file = new File(this.baseDirectory, name);
        OrbisProject project = new OrbisProject(file, new ProjectInformation(identifier, new ProjectMetadata()));
        this.saveProjectToDisk(project);
        this.cacheProject(name, project);
        return (T)project;
    }

    @Override
    public <T extends IProject> T saveProjectIfDoesntExist(String name, IProject project) {
        File location = new File(this.baseDirectory, name);
        IProject existing = this.idToProject.get(project.getInfo().getIdentifier());
        if (existing != null && existing.getLocationAsFile().exists() && existing.getInfo().getMetadata().getLastChanged().equals(project.getInfo().getMetadata().getLastChanged())) {
            if (!(existing.getLocationAsFile().equals(location) || location.exists() && !location.delete())) {
                if (existing.getLocationAsFile().renameTo(location)) {
                    this.nameToProject.remove(existing.getLocationAsFile().getName());
                    if (existing.getLocationAsFile().delete()) {
                        existing.setLocationAsFile(location);
                        this.nameToProject.put(name, existing);
                    }
                } else {
                    throw new RuntimeException("Could not rename project folder. Abort!");
                }
            }
            return (T)existing;
        }
        if (!location.exists() && !location.mkdirs()) {
            throw new RuntimeException("Location for Project cannot be created!");
        }
        project.setLocationAsFile(location);
        this.saveProjectToDisk(project);
        this.cacheProject(name, project);
        return (T)existing;
    }

    @Override
    public boolean projectNameExists(String name) {
        return this.nameToProject.containsKey(name);
    }

    @Override
    public boolean projectExists(IProjectIdentifier id) {
        return this.idToProject.containsKey(id);
    }

    private void saveProjectToDisk(IProject project) {
        File projectFile = new File(project.getLocationAsFile(), "project_data.json");
        try {
            boolean hiddenProjectFile;
            boolean bl = hiddenProjectFile = projectFile.exists() && Files.getAttribute(Paths.get(projectFile.getPath(), new String[0]), "dos:hidden", new LinkOption[0]) == Boolean.TRUE;
            if (hiddenProjectFile) {
                FileHelper.unhide(projectFile);
            }
            try (FileOutputStream out = new FileOutputStream(projectFile);
                 OutputStreamWriter writer = new OutputStreamWriter(out);){
                try {
                    OrbisLib.services().getGson().toJson((Object)project.getInfo(), (Appendable)writer);
                }
                catch (JsonIOException e) {
                    OrbisLib.LOGGER.error("Failed to save Project info to json file", (Throwable)e);
                }
            }
            catch (IOException e) {
                OrbisLib.LOGGER.error("Failed to save Project to disk", (Throwable)e);
            }
            if (hiddenProjectFile) {
                FileHelper.hide(projectFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static interface ProjectWalker {
        public void accept(File var1, File var2, boolean var3);
    }
}

