/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.management.impl;

import com.gildedgames.orbis.lib.data.management.IProjectMetadata;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.IText;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class ProjectMetadata
implements IProjectMetadata {
    private LocalDateTime lastChanged = LocalDateTime.now();
    private List<IText> display;
    private boolean downloaded;
    private boolean downloading;

    public ProjectMetadata() {
        this.display = Lists.newArrayList();
    }

    private ProjectMetadata(LocalDateTime lastChanged, List<IText> display, boolean downloaded, boolean downloading) {
        this.lastChanged = lastChanged;
        this.display = display;
        this.downloaded = downloaded;
        this.downloading = downloading;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setList("display", this.display);
        tag.func_74757_a("downloaded", this.downloaded);
        tag.func_74757_a("downloading", this.downloading);
        funnel.setDate("lastChanged", this.lastChanged);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.display = funnel.getList("display");
        this.downloaded = tag.func_74767_n("downloaded");
        this.downloading = tag.func_74767_n("downloading");
        this.lastChanged = funnel.getDate("lastChanged");
    }

    @Override
    public List<IText> getMetadataDisplay() {
        return this.display;
    }

    @Override
    public boolean isDownloaded() {
        return this.downloaded;
    }

    @Override
    public void setDownloaded(boolean downloaded) {
        this.downloaded = downloaded;
    }

    @Override
    public boolean isDownloading() {
        return this.downloading;
    }

    @Override
    public void setDownloading(boolean downloading) {
        this.downloading = downloading;
    }

    @Override
    public LocalDateTime getLastChanged() {
        return this.lastChanged;
    }

    @Override
    public void setLastChanged(LocalDateTime lastChanged) {
        this.lastChanged = lastChanged;
    }
}

