/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.region;

import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.RotationHelp;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractRegion
implements IRegion {
    private Iterable<BlockPos.MutableBlockPos> data;
    private boolean dataChanged;

    @Override
    public IRegion getBoundingBox() {
        return this;
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> createShapeData() {
        return BlockPos.func_177975_b((BlockPos)this.getMin(), (BlockPos)this.getMax());
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null || this.dataChanged) {
            this.data = this.createShapeData();
        }
        return this.data;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return RegionHelp.contains(this, (float)x, (float)y, (float)z);
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public IShape translate(int x, int y, int z) {
        return new Region(this.getMin().func_177982_a(x, y, z), this.getMax().func_177982_a(x, y, z));
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion in) {
        return RotationHelp.rotate(this, in, rotation);
    }

    public final void notifyDataChange() {
        this.dataChanged = true;
    }

    public String toString() {
        return "Min: " + this.getMin().toString() + " Max: " + this.getMax().toString();
    }
}

