/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.region;

import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.RotationHelp;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class Region
implements IMutableRegion {
    public static final IRegion ORIGIN = new Region(new BlockPos(0, 0, 0));
    private BlockPos min;
    private BlockPos max;
    private Iterable<BlockPos.MutableBlockPos> data;
    private boolean dataChanged;

    protected Region() {
    }

    public Region(IRegion region) {
        this.min = region.getMin();
        this.max = region.getMax();
    }

    public Region(BlockPos pos) {
        if (pos == null) {
            throw new NullPointerException("Tried to make a Region of an empty position");
        }
        this.min = pos;
        this.max = pos;
    }

    public Region(BlockPos corner1, BlockPos corner2) {
        this.setBounds(corner1, corner2);
    }

    public Region(IDimensions dimensions) {
        this.setBounds(BlockPos.field_177992_a, new BlockPos(dimensions.getWidth() - 1, dimensions.getHeight() - 1, dimensions.getLength() - 1));
    }

    @Override
    public void setBounds(BlockPos corner1, BlockPos corner2) {
        this.min = RegionHelp.getMin(corner1, corner2);
        this.max = RegionHelp.getMax(corner1, corner2);
        this.dataChanged = true;
    }

    @Override
    public void setBounds(IRegion resized) {
        this.min = resized.getMin();
        this.max = resized.getMax();
        this.dataChanged = true;
    }

    public boolean equals(Object o) {
        boolean flag = super.equals(o);
        if (flag) {
            return true;
        }
        if (!(o instanceof IRegion)) {
            return false;
        }
        IRegion region = (IRegion)o;
        BlockPos rMin = region.getMin();
        BlockPos rMax = region.getMax();
        return this.min.func_177958_n() == rMin.func_177958_n() && this.max.func_177958_n() == rMax.func_177958_n() && this.min.func_177956_o() == rMin.func_177956_o() && this.max.func_177956_o() == rMax.func_177956_o() && this.min.func_177952_p() == rMin.func_177952_p() && this.max.func_177952_p() == rMax.func_177952_p();
    }

    public String toString() {
        return "(" + this.min.func_177958_n() + ", " + this.min.func_177956_o() + ", " + this.min.func_177952_p() + "; " + this.max.func_177958_n() + ", " + this.max.func_177956_o() + ", " + this.max.func_177952_p() + ")";
    }

    public boolean intersectsWith(IRegion region) {
        return RegionHelp.intersects3D(this, region);
    }

    public boolean contains(Region region) {
        return RegionHelp.contains((IRegion)region, this);
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return RegionHelp.contains(this, (float)x, (float)y, (float)z);
    }

    public void relocate(BlockPos pos) {
        RegionHelp.relocate(this, pos);
        this.dataChanged = true;
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public IShape translate(int x, int y, int z) {
        Region region = new Region(this);
        region.add(x, y, z);
        return region;
    }

    public void add(int x, int y, int z) {
        RegionHelp.translate(this, x, y, z);
        this.dataChanged = true;
    }

    public void add(BlockPos pos) {
        this.add(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void subtract(int x, int y, int z) {
        RegionHelp.translate(this, -x, -y, -z);
        this.dataChanged = true;
    }

    public Iterable<BlockPos.MutableBlockPos> getMutableBlockPosInRegion() {
        return BlockPos.func_177975_b((BlockPos)this.min, (BlockPos)this.max);
    }

    public int getXSize() {
        return this.max.func_177958_n() - this.min.func_177958_n() + 1;
    }

    public int getYSize() {
        return this.max.func_177956_o() - this.min.func_177956_o() + 1;
    }

    public int getZSize() {
        return this.max.func_177952_p() - this.min.func_177952_p() + 1;
    }

    public BlockPos getBottomCenter() {
        return new BlockPos(this.getCenterX(), this.min.func_177956_o(), this.getCenterZ());
    }

    public BlockPos getCenter() {
        return new BlockPos(this.getCenterX(), this.getCenterY(), this.getCenterZ());
    }

    public int getCenterX() {
        return this.min.func_177958_n() + (this.max.func_177958_n() - this.min.func_177958_n() + 1) / 2;
    }

    public int getCenterY() {
        return this.min.func_177956_o() + (this.max.func_177956_o() - this.min.func_177956_o() + 1) / 2;
    }

    public int getCenterZ() {
        return this.min.func_177952_p() + (this.max.func_177952_p() - this.min.func_177952_p() + 1) / 2;
    }

    public double getCenterXD() {
        return (double)this.min.func_177958_n() + (double)(this.max.func_177958_n() - this.min.func_177958_n() + 1) / 2.0;
    }

    public double getCenterZD() {
        return (double)this.min.func_177952_p() + (double)(this.max.func_177952_p() - this.min.func_177952_p() + 1) / 2.0;
    }

    public Region fromIntersection(IRegion other) {
        return new Region(new BlockPos(Math.max(this.getMin().func_177958_n(), other.getMin().func_177958_n()), Math.max(this.getMin().func_177956_o(), other.getMin().func_177956_o()), Math.max(this.getMin().func_177952_p(), other.getMin().func_177952_p())), new BlockPos(Math.min(this.getMax().func_177958_n(), other.getMax().func_177958_n()), Math.min(this.getMax().func_177956_o(), other.getMax().func_177956_o()), Math.min(this.getMax().func_177952_p(), other.getMax().func_177952_p())));
    }

    @Override
    public int getLength() {
        return this.getZSize();
    }

    @Override
    public int getWidth() {
        return this.getXSize();
    }

    @Override
    public int getHeight() {
        return this.getYSize();
    }

    public int getVolume() {
        return this.getLength() * this.getWidth() * this.getHeight();
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74782_a("min", NBTHelper.writeBlockPos(this.min));
        tag.func_74782_a("max", NBTHelper.writeBlockPos(this.max));
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.min = NBTHelper.readBlockPos(tag.func_74775_l("min"));
        this.max = NBTHelper.readBlockPos(tag.func_74775_l("max"));
    }

    public boolean isACorner(BlockPos pos) {
        return RegionHelp.isACorner(pos, this);
    }

    public void rotate90(boolean clockwise) {
        int width = this.getWidth();
        int length = this.getLength();
        this.min = new BlockPos(this.min.func_177958_n() + width / 2 - length / 2, this.min.func_177956_o(), this.min.func_177952_p() + length / 2 - width / 2);
        this.max = new BlockPos(this.min.func_177958_n() + length - 1, this.max.func_177956_o(), this.min.func_177952_p() + width - 1);
        this.dataChanged = true;
    }

    @Override
    public BlockPos getMin() {
        return this.min;
    }

    @Override
    public BlockPos getMax() {
        return this.max;
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> createShapeData() {
        return BlockPos.func_177975_b((BlockPos)this.min, (BlockPos)this.max);
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion regionIn) {
        IRegion rotated = RotationHelp.rotate(this, regionIn, rotation);
        return rotated;
    }

    @Override
    public IRegion getBoundingBox() {
        return this;
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null || this.dataChanged) {
            this.data = this.createShapeData();
        }
        return this.data;
    }

    @Override
    public Iterator<BlockPos.MutableBlockPos> iterator() {
        return BlockPos.func_177975_b((BlockPos)this.min, (BlockPos)this.max).iterator();
    }
}

