/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.schedules;

import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.schedules.IPositionRecord;
import com.gildedgames.orbis.lib.data.schedules.IPositionRecordListener;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class BlockStateRecord
implements IPositionRecord<IBlockState> {
    private final List<IPositionRecordListener<IBlockState>> listeners = Lists.newArrayList();
    private IBlockState[] states;
    private int[] markedPositions;
    private int width;
    private int height;
    private int length;
    private int volume;
    private IRegion boundingBox;
    private Iterable<BlockPos.MutableBlockPos> data;

    private BlockStateRecord() {
    }

    public BlockStateRecord(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.boundingBox = new Region(BlockPos.field_177992_a, new BlockPos(this.width - 1, this.height - 1, this.length - 1));
        this.createMarkedPositions();
    }

    private int getInternalStateId(IBlockState state) {
        int id = -1;
        for (int i = 0; i < this.states.length; ++i) {
            IBlockState f = this.states[i];
            if (f == null || state != f) continue;
            id = i;
            break;
        }
        return id;
    }

    private void checkForFilterAndAdd(IBlockState state) {
        if (this.states == null) {
            this.states = new IBlockState[0];
        }
        boolean hasState = false;
        for (IBlockState s : this.states) {
            if (s == null || state != s) continue;
            hasState = true;
            break;
        }
        if (!hasState) {
            this.states = Arrays.copyOf(this.states, this.states.length + 1);
            this.states[this.states.length - 1] = state;
        }
    }

    private void createMarkedPositions() {
        this.volume = this.width * this.height * this.length;
        this.markedPositions = new int[this.getVolume()];
        Arrays.fill(this.markedPositions, -1);
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    private int getIndex(int x, int y, int z, boolean throwException) {
        int index = z + y * this.length + x * this.height * this.length;
        if (index < this.getVolume() && index >= 0) {
            return index;
        }
        if (throwException) {
            throw new ArrayIndexOutOfBoundsException("Tried to access position that's not in this FilterRecord: " + x + ", " + y + ", " + z);
        }
        return -1;
    }

    public int getZ(int index) {
        return index / (this.width * this.length);
    }

    public int getY(int index) {
        int z = this.getZ(index);
        return (index -= z * this.width * this.length) / this.width;
    }

    public int getX(int index) {
        int z = this.getZ(index);
        return (index -= z * this.width * this.length) % this.width;
    }

    @Override
    public void listen(IPositionRecordListener<IBlockState> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean unlisten(IPositionRecordListener<IBlockState> listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean contains(int index) {
        return this.markedPositions[index] != -1;
    }

    public IBlockState[] getData() {
        if (this.states == null) {
            this.states = new IBlockState[0];
        }
        return this.states;
    }

    @Override
    public IBlockState get(int index) {
        int id = this.markedPositions[index];
        if (id == -1) {
            return null;
        }
        return this.states[id];
    }

    @Override
    public IBlockState get(int x, int y, int z) {
        int index = this.getIndex(x, y, z, true);
        return this.get(index);
    }

    @Override
    public void markPos(IBlockState state, int x, int y, int z) {
        this.checkForFilterAndAdd(state);
        int index = this.getIndex(x, y, z, true);
        this.markedPositions[index] = this.getInternalStateId(state);
        this.listeners.forEach(l -> l.onMarkPos(state, x, y, z));
    }

    @Override
    public void unmarkPos(int x, int y, int z) {
        int index = this.getIndex(x, y, z, true);
        this.markedPositions[index] = -1;
        this.listeners.forEach(l -> l.onUnmarkPos(x, y, z));
    }

    @Override
    public IRegion getRegion() {
        return this.boundingBox;
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> createShapeData() {
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                final Iterator<BlockPos.MutableBlockPos> iter = BlockStateRecord.this.getBoundingBox().createShapeData().iterator();
                return new AbstractIterator<BlockPos.MutableBlockPos>(){

                    protected BlockPos.MutableBlockPos computeNext() {
                        while (iter.hasNext()) {
                            BlockPos.MutableBlockPos next = (BlockPos.MutableBlockPos)iter.next();
                            if (!BlockStateRecord.this.contains(next.func_177958_n(), next.func_177956_o(), next.func_177952_p())) continue;
                            return next;
                        }
                        return (BlockPos.MutableBlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null) {
            this.data = this.createShapeData();
        }
        return this.data;
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion in) {
        return this;
    }

    @Override
    public IShape translate(int x, int y, int z) {
        return new BlockStateRecord(this.width, this.height, this.length);
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public IRegion getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        int index = this.getIndex(x, y, z, false);
        if (index == -1) {
            return false;
        }
        return this.markedPositions[index] != -1;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74768_a("width", this.width);
        tag.func_74768_a("height", this.height);
        tag.func_74768_a("length", this.length);
        tag.func_74768_a("volume", this.volume);
        funnel.set("boundingBox", this.boundingBox);
        funnel.setArray("states", this.states, NBTFunnel.BLOCKSTATE_SETTER);
        funnel.setIntArray("markedPositions", this.markedPositions);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
        this.length = tag.func_74762_e("length");
        this.volume = tag.func_74762_e("volume");
        this.boundingBox = (IRegion)funnel.get("boundingBox");
        this.states = funnel.getArray("states", IBlockState.class, NBTFunnel.BLOCKSTATE_GETTER);
        this.markedPositions = funnel.getIntArray("markedPositions");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }
}

