/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.schedules;

import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.core.tree.ConditionLink;
import com.gildedgames.orbis.lib.core.tree.INode;
import com.gildedgames.orbis.lib.core.tree.INodeTreeListener;
import com.gildedgames.orbis.lib.core.tree.LayerLink;
import com.gildedgames.orbis.lib.core.tree.NodeTree;
import com.gildedgames.orbis.lib.core.variables.conditions.IGuiCondition;
import com.gildedgames.orbis.lib.core.variables.post_resolve_actions.IPostResolveAction;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.schedules.BlockStateRecord;
import com.gildedgames.orbis.lib.data.schedules.IPositionRecord;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayer;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayerListener;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayerOptions;
import com.gildedgames.orbis.lib.data.schedules.IScheduleRecord;
import com.gildedgames.orbis.lib.data.schedules.ScheduleLayerOptions;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRecord;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;

public class ScheduleLayer
implements IScheduleLayer,
INodeTreeListener<IGuiCondition, ConditionLink> {
    private IDimensions dimensions;
    private IPositionRecord<IBlockState> stateRecord;
    private IScheduleRecord scheduleRecord = new ScheduleRecord();
    private BlueprintData dataParent;
    private NodeTree<IGuiCondition, ConditionLink> conditionNodeTree = new NodeTree();
    private NodeTree<IPostResolveAction, NBT> postResolveActionNodeTree = new NodeTree();
    private Pos2D guiPos = Pos2D.ORIGIN;
    private Pos2D conditionGuiPos = Pos2D.ORIGIN;
    private Pos2D postResolveActionGuiPos = Pos2D.ORIGIN;
    private INode<IScheduleLayer, LayerLink> nodeParent;
    private boolean visible = true;
    private List<IScheduleLayerListener> listeners = Lists.newArrayList();
    private IScheduleLayerOptions options;
    private INodeTreeListener<IPostResolveAction, NBT> postResolveListener = new INodeTreeListener<IPostResolveAction, NBT>(){

        @Override
        public void onSetData(INode<IPostResolveAction, NBT> node, IPostResolveAction iPostResolveAction, int id) {
            if (ScheduleLayer.this.dataParent != null) {
                ScheduleLayer.this.dataParent.markDirty();
            }
        }

        @Override
        public void onPut(INode<IPostResolveAction, NBT> node, int id) {
            if (ScheduleLayer.this.dataParent != null) {
                ScheduleLayer.this.dataParent.markDirty();
            }
        }

        @Override
        public void onRemove(INode<IPostResolveAction, NBT> node, int id) {
            if (ScheduleLayer.this.dataParent != null) {
                ScheduleLayer.this.dataParent.markDirty();
            }
        }
    };

    private ScheduleLayer() {
        this.scheduleRecord.setParent(this);
        this.options = new ScheduleLayerOptions();
    }

    public ScheduleLayer(String displayName, IDimensions dimensions) {
        this();
        this.options.getDisplayNameVar().setData(displayName);
        this.dimensions = dimensions;
        this.stateRecord = new BlockStateRecord(this.dimensions.getWidth(), this.dimensions.getHeight(), this.dimensions.getLength());
        this.conditionNodeTree.listen(this);
        this.postResolveActionNodeTree.listen(this.postResolveListener);
    }

    @Override
    public void listen(IScheduleLayerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean unlisten(IScheduleLayerListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.dataParent != null) {
            this.dataParent.markDirty();
        }
        this.listeners.forEach(l -> l.onSetVisible(visible));
    }

    @Override
    public INode<IScheduleLayer, LayerLink> getNodeParent() {
        return this.nodeParent;
    }

    @Override
    public void setNodeParent(INode<IScheduleLayer, LayerLink> nodeParent) {
        this.nodeParent = nodeParent;
    }

    @Override
    public IPositionRecord<IBlockState> getStateRecord() {
        return this.stateRecord;
    }

    @Override
    public IScheduleRecord getScheduleRecord() {
        return this.scheduleRecord;
    }

    @Override
    public IScheduleLayerOptions getOptions() {
        return this.options;
    }

    @Override
    public void setDimensions(IDimensions dimensions) {
        this.dimensions = dimensions;
        if (this.stateRecord == null) {
            this.stateRecord = new BlockStateRecord(this.dimensions.getWidth(), this.dimensions.getHeight(), this.dimensions.getLength());
        }
    }

    @Override
    @Nonnull
    public NodeTree<IPostResolveAction, NBT> getPostResolveActionNodeTree() {
        return this.postResolveActionNodeTree;
    }

    @Override
    public void setPostResolveActionNodeTree(NodeTree<IPostResolveAction, NBT> tree) {
        this.postResolveActionNodeTree = tree;
    }

    @Override
    public NodeTree<IGuiCondition, ConditionLink> getConditionNodeTree() {
        return this.conditionNodeTree;
    }

    @Override
    public void setConditionNodeTree(NodeTree<IGuiCondition, ConditionLink> tree) {
        this.conditionNodeTree = tree;
    }

    @Override
    public Pos2D getGuiPos() {
        return this.guiPos;
    }

    @Override
    public void setGuiPos(Pos2D pos) {
        this.guiPos = pos;
    }

    @Override
    public Pos2D getConditionGuiPos() {
        return this.conditionGuiPos;
    }

    @Override
    public void setConditionGuiPos(Pos2D pos) {
        this.conditionGuiPos = pos;
    }

    @Override
    public Pos2D getPostResolveActionGuiPos() {
        return this.postResolveActionGuiPos;
    }

    @Override
    public void setPostResolveActionGuiPos(Pos2D pos) {
        this.postResolveActionGuiPos = pos;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.set("stateRecord", this.stateRecord);
        funnel.set("scheduleRecord", this.scheduleRecord);
        funnel.set("guiPos", this.guiPos, NBTFunnel.POS2D_SETTER);
        funnel.set("conditionGuiPos", this.conditionGuiPos, NBTFunnel.POS2D_SETTER);
        funnel.set("postResolveActionGuiPos", this.postResolveActionGuiPos, NBTFunnel.POS2D_SETTER);
        funnel.set("conditionNodeTree", this.conditionNodeTree);
        funnel.set("postResolveActionNodeTree", this.postResolveActionNodeTree);
        tag.func_74757_a("visible", this.visible);
        funnel.set("scheduleOptions", this.options);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.stateRecord = (IPositionRecord)funnel.get("stateRecord");
        this.scheduleRecord = funnel.getWithDefault("scheduleRecord", this::getScheduleRecord);
        if (this.scheduleRecord != null) {
            this.scheduleRecord.setParent(this);
        }
        this.guiPos = funnel.get("guiPos", NBTFunnel.POS2D_GETTER);
        this.conditionGuiPos = funnel.getWithDefault("conditionGuiPos", NBTFunnel.POS2D_GETTER, () -> this.conditionGuiPos);
        this.postResolveActionGuiPos = funnel.getWithDefault("postResolveActionGuiPos", NBTFunnel.POS2D_GETTER, () -> this.postResolveActionGuiPos);
        this.conditionNodeTree = funnel.getWithDefault("conditionNodeTree", () -> this.conditionNodeTree);
        this.postResolveActionNodeTree = funnel.getWithDefault("postResolveActionNodeTree", () -> this.postResolveActionNodeTree);
        this.conditionNodeTree.listen(this);
        this.postResolveActionNodeTree.listen(this.postResolveListener);
        if (tag.func_74764_b("visible")) {
            this.visible = tag.func_74767_n("visible");
        }
        this.options = funnel.getWithDefault("scheduleOptions", () -> this.options);
    }

    @Override
    public void onSetData(INode<IGuiCondition, ConditionLink> node, IGuiCondition condition, int id) {
        if (this.dataParent != null) {
            this.dataParent.markDirty();
        }
    }

    @Override
    public void onPut(INode<IGuiCondition, ConditionLink> node, int id) {
        if (this.dataParent != null) {
            this.dataParent.markDirty();
        }
    }

    @Override
    public void onRemove(INode<IGuiCondition, ConditionLink> node, int id) {
        if (this.dataParent != null) {
            this.dataParent.markDirty();
        }
    }

    @Override
    public Class<? extends BlueprintData> getDataClass() {
        return BlueprintData.class;
    }

    @Override
    public BlueprintData getDataParent() {
        return this.dataParent;
    }

    @Override
    public void setDataParent(BlueprintData blueprintData) {
        this.dataParent = blueprintData;
        this.scheduleRecord.setDataParent(blueprintData);
        this.conditionNodeTree.setDataParent(blueprintData);
        this.postResolveActionNodeTree.setDataParent(blueprintData);
    }
}

