/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.schedules;

import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.schedules.ISchedule;
import com.gildedgames.orbis.lib.data.schedules.IScheduleLayer;
import com.gildedgames.orbis.lib.data.schedules.IScheduleRecord;
import com.gildedgames.orbis.lib.data.schedules.IScheduleRecordListener;
import com.gildedgames.orbis.lib.data.schedules.ScheduleRegion;
import com.gildedgames.orbis.lib.util.ObjectFilter;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.world.IWorldObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class ScheduleRecord
implements IScheduleRecord {
    private final List<IScheduleRecordListener> listeners = Lists.newArrayList();
    private Map<Integer, ISchedule> schedules = Maps.newHashMap();
    private BlueprintData dataParent;
    private IScheduleLayer parent;
    private int nextId;

    @Override
    public void listen(IScheduleRecordListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean unlisten(IScheduleRecordListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void removeSchedule(int id) {
        ISchedule schedule = this.schedules.remove(id);
        this.listeners.forEach(o -> o.onRemoveSchedule(schedule));
    }

    @Override
    public int addSchedule(ISchedule schedule, IWorldObject parentWorldObject) {
        int id;
        boolean success;
        if (!(success = this.setSchedule(id = this.nextId++, schedule, parentWorldObject))) {
            return -1;
        }
        return id;
    }

    @Override
    public boolean setSchedule(int id, ISchedule schedule, IWorldObject parentWorldObject) {
        IRegion bb = parentWorldObject.getShape().getBoundingBox();
        BlockPos min = schedule.getBounds().getMin().func_177971_a((Vec3i)bb.getMin());
        BlockPos max = schedule.getBounds().getMax().func_177971_a((Vec3i)bb.getMin());
        if (max.func_177958_n() > bb.getMax().func_177958_n() || max.func_177956_o() > bb.getMax().func_177956_o() || max.func_177952_p() > bb.getMax().func_177952_p() || min.func_177958_n() < bb.getMin().func_177958_n() || min.func_177956_o() < bb.getMin().func_177956_o() || min.func_177952_p() < bb.getMin().func_177952_p()) {
            return false;
        }
        for (ISchedule s : this.getSchedules(ISchedule.class)) {
            if (!RegionHelp.intersects3D(schedule.getBounds(), s.getBounds())) continue;
            return false;
        }
        schedule.setDataParent(this.dataParent);
        schedule.setParent(this);
        this.schedules.put(id, schedule);
        this.listeners.forEach(o -> o.onAddSchedule(schedule));
        return true;
    }

    @Override
    public int getScheduleId(ISchedule schedule) {
        for (Map.Entry<Integer, ISchedule> entry : this.schedules.entrySet()) {
            int i = entry.getKey();
            ISchedule s = entry.getValue();
            if (!schedule.equals(s)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public <T extends ISchedule> T getSchedule(int id) {
        return (T)this.schedules.get(id);
    }

    @Override
    public <T extends ISchedule> List<T> getSchedules(Class<T> clazz) {
        return ObjectFilter.getTypesFrom(this.schedules.values(), clazz);
    }

    @Override
    public List<ISchedule> getSchedulesFromTriggerID(String triggerId) {
        ArrayList schedules = Lists.newArrayList();
        for (ScheduleRegion s : this.getSchedules(ScheduleRegion.class)) {
            if (!s.getTriggerId().equals(triggerId)) continue;
            schedules.add(s);
        }
        return schedules;
    }

    @Override
    public IScheduleLayer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IScheduleLayer parent) {
        this.parent = parent;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74768_a("nextId", this.nextId);
        funnel.setIntMap("schedules", this.schedules);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.nextId = tag.func_74762_e("nextId");
        this.schedules = funnel.getIntMap("schedules");
        this.schedules.values().forEach(s -> s.setParent(this));
    }

    @Override
    public Class<? extends BlueprintData> getDataClass() {
        return BlueprintData.class;
    }

    @Override
    public BlueprintData getDataParent() {
        return this.dataParent;
    }

    @Override
    public void setDataParent(BlueprintData blueprintData) {
        this.dataParent = blueprintData;
        this.schedules.values().forEach(s -> s.setDataParent(this.dataParent));
    }
}

